/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.layout.SimpleLayoutData;
import java.util.List;
import java.util.Observable;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutItem
extends Observable {
    public static final String LAYOUT_ITEM = "layoutItem";
    private static final String WEIGHT = "weight";
    private static final String MINIMUM_SIZE = "minimumSize";
    private static final String MAXIMUM_SIZE = "maximumSize";
    private static final String COMPONENT_DESCRIPTOR = "componentDescriptor";
    private static final String HORIZONTAL_ORIENTATION = "horizontalOrientation";
    private static final String USE_SPACING = "useSpacing";
    private static final int DEFAULT_MARGIN_SPACING = 6;
    private static final int DEFAULT_MAX_WIDTH = SimpleLayout.INFINITE_SIZE;
    private final Setting m_setting = new Setting("layoutItem");
    private SimpleLayoutData m_simpleLayoutData = new SimpleLayoutData();
    private SimpleLayout m_layout = new SimpleLayout();
    private LayoutItem m_parent;

    static {
        PersistenceToolkit.registerFetcher(LayoutItem.class, (ISettingFetcher)new ISettingFetcher<LayoutItem>(){

            public Setting getSetting(LayoutItem layoutItem) {
                return layoutItem.m_setting;
            }
        });
    }

    public LayoutItem() {
        this.setWeight(1.0f);
        this.setMinSize(0);
        this.setMaxSize(DEFAULT_MAX_WIDTH);
        this.setHorizontal(true);
        this.setUseSpacing(true);
        this.getLayout().setMargin(0);
        this.getLayout().setAlignment(1);
        this.updateLayoutData();
    }

    void updateLayoutData() {
        this.getLayoutData().setMinSize(this.getMinimumSize());
        this.getLayoutData().setMaxSize(this.getMaximumSize());
        this.getLayoutData().setWeight(this.convertWeight(this.getWeight()));
        this.getLayout().setHorizontalOrientation(this.getHorizontal());
        this.getLayout().setSpacing(this.getUseSpacing() ? 6 : 0);
    }

    private float convertWeight(double weight) {
        if (weight == Double.POSITIVE_INFINITY) {
            return SimpleLayout.INIFINITE_WEIGHT;
        }
        if (weight == 0.0) {
            return 10.0f;
        }
        return (float)(10.0 / weight);
    }

    public void splitHorizontally() {
        this.split(false);
    }

    public void splitVertically() {
        this.split(true);
        this.setChanged();
    }

    private void split(boolean vertically) {
        this.setHorizontal(vertically);
        this.add(this.createChild());
        this.add(this.createChild());
    }

    public static void initialize(LayoutItem item, IWorkbenchPartSite site) {
        item.updateLayoutData();
        for (LayoutItem child : item.getChildren()) {
            child.setParent(item);
            LayoutItem.initialize(child, site);
        }
    }

    public void add(LayoutItem item) {
        this.getChildren().add(item);
        this.setChanged();
    }

    public void remove(LayoutItem item) {
        this.getChildren().remove(item);
        this.setChanged();
    }

    public void setLayoutDataChange() {
        this.setChanged();
    }

    public List<LayoutItem> getChildren() {
        return (List)this.m_setting.getChildObject("children", new Type(List.class, new Type[]{new Type(LayoutItem.class)}));
    }

    public void createBefore(LayoutItem beforeItem) {
        this.addBefore(beforeItem, this.createChild());
    }

    public void createAfter(LayoutItem afterItem) {
        this.addAfter(afterItem, this.createChild());
    }

    private void addBefore(LayoutItem beforeItem, LayoutItem item) {
        int index = 0;
        for (LayoutItem anItem : this.getChildren()) {
            if (beforeItem.equals(anItem)) {
                this.getChildren().add(index, item);
                this.setChanged();
                return;
            }
            ++index;
        }
    }

    private void addAfter(LayoutItem afterItem, LayoutItem item) {
        int index = 0;
        for (LayoutItem anItem : this.getChildren()) {
            ++index;
            if (!afterItem.equals(anItem)) continue;
            if (index < this.getChildren().size()) {
                this.getChildren().add(index, item);
                continue;
            }
            this.getChildren().add(item);
        }
        this.setChanged();
    }

    public boolean isHorizontal() {
        return !this.m_layout.getHorizontalOrientation();
    }

    public LayoutItem getParent() {
        return this.m_parent;
    }

    public void setParent(LayoutItem item) {
        this.m_parent = item;
    }

    public ComponentDescriptor getComponentDescriptor() {
        if (this.m_setting.getChildSetting(COMPONENT_DESCRIPTOR) != null) {
            return (ComponentDescriptor)this.m_setting.getChildObject(COMPONENT_DESCRIPTOR, ComponentDescriptor.class);
        }
        return null;
    }

    public void setComponentDescripor(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor != null) {
            this.m_setting.setChildObject(COMPONENT_DESCRIPTOR, (Object)componentDescriptor);
        } else {
            this.m_setting.removeChild(this.m_setting.getChildSetting(COMPONENT_DESCRIPTOR));
        }
    }

    public LayoutItem getRoot() {
        LayoutItem item = this;
        while (item.getParent() != null) {
            item = item.getParent();
        }
        return item;
    }

    public SimpleLayoutData getLayoutData() {
        return this.m_simpleLayoutData;
    }

    public SimpleLayout getLayout() {
        return this.m_layout;
    }

    public int getMaximumSize() {
        return (Integer)this.m_setting.getChildObject(MAXIMUM_SIZE, Integer.class);
    }

    public int getMinimumSize() {
        return (Integer)this.m_setting.getChildObject(MINIMUM_SIZE, Integer.class);
    }

    public float getWeight() {
        return ((Float)this.m_setting.getChildObject(WEIGHT, Float.class)).floatValue();
    }

    public void setMinSize(int value) {
        this.m_setting.setChildObject(MINIMUM_SIZE, (Object)value);
        this.updateLayoutData();
        this.setChanged();
    }

    public void setMaxSize(int size) {
        this.m_setting.setChildObject(MAXIMUM_SIZE, (Object)size);
        this.updateLayoutData();
        this.setChanged();
    }

    public void setWeight(float weight) {
        this.m_setting.setChildObject(WEIGHT, (Object)Float.valueOf(weight));
        this.updateLayoutData();
        this.setChanged();
    }

    public void setHorizontal(boolean horizontal) {
        this.m_setting.setChildObject(HORIZONTAL_ORIENTATION, (Object)horizontal);
        this.updateLayoutData();
        this.setChanged();
    }

    public void setUseSpacing(boolean useSpacing) {
        this.m_setting.setChildObject(USE_SPACING, (Object)useSpacing);
        this.updateLayoutData();
        this.setChanged();
    }

    public boolean getUseSpacing() {
        return (Boolean)this.m_setting.getChildObject(USE_SPACING, Boolean.class);
    }

    public boolean getHorizontal() {
        return (Boolean)this.m_setting.getChildObject(HORIZONTAL_ORIENTATION, Boolean.class);
    }

    public LayoutItem createChild() {
        LayoutItem layoutItem = new LayoutItem();
        layoutItem.setParent(this);
        return layoutItem;
    }
}

