/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.behaviors.IComponent;
import com.jrockit.mc.components.ui.behaviors.IComponentDecoration;
import com.jrockit.mc.components.ui.behaviors.IComponentDescribable;
import com.jrockit.mc.components.ui.behaviors.ICreateAccessiblePart;
import com.jrockit.mc.components.ui.behaviors.ICreatePart;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.ComponentHolder;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutItemCanvas;
import com.jrockit.mc.components.ui.design.SelectionContext;
import com.jrockit.mc.components.ui.design.UnknownComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.util.Dynamic;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.ui.HelpSupport;
import com.jrockit.mc.core.ui.MCToolBarManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class GUIFactory {
    private final FormToolkit m_toolkit;
    private final IServiceLocator m_locator;

    public GUIFactory(IServiceLocator locator) {
        UIScope s = locator.getService(UIScope.class);
        UIScope comp = new UIScope(s);
        locator.registerService(comp);
        this.m_locator = locator.createChildService();
        this.m_toolkit = this.m_locator.getService(FormToolkit.class);
    }

    public void buildUI(Composite parent, LayoutItem item) {
        Object control = null;
        control = !item.getChildren().isEmpty() ? this.createPlaceHolder(parent, item) : this.createSection(parent, item);
        control.setLayoutData((Object)item.getLayoutData());
        control.addTraverseListener((TraverseListener)new SimpleTraverseListener());
    }

    /*
     * Unable to fully structure code
     */
    private Control createSection(Composite parent, LayoutItem item) {
        try {
            ch = this.createSectionComponent(parent, item);
            if (ch.component != null) {
                this.addComponentToScope(ch.component);
            }
            return ch.control;
        }
        catch (Exception e) {
            var7_5 = parent.getChildren();
            var6_6 = var7_5.length;
            var5_7 = 0;
            ** while (var5_7 < var6_6)
        }
lbl-1000:
        // 1 sources

        {
            child = var7_5[var5_7];
            if (child != null && !child.isDisposed()) {
                child.dispose();
            }
            ++var5_7;
            continue;
        }
lbl16:
        // 1 sources

        componentName = item.getComponentDescriptor() != null ? item.getComponentDescriptor().getIdentifier() : "null";
        return this.createExceptionComponent(parent, "Error initliazing component: " + componentName, e);
    }

    public void addComponentToScope(Object component) {
        UIScope comps = this.getServiceLocator().getService(UIScope.class);
        comps.addComponent(component);
    }

    private Composite createPlaceHolder(Composite parent, LayoutItem item) {
        Composite container = this.m_toolkit.createComposite(parent);
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SimpleLayout sl = item.getLayout();
        container.setLayout((Layout)sl);
        for (LayoutItem lItem : item.getChildren()) {
            this.buildUI(container, lItem);
        }
        return container;
    }

    public ComponentHolder createSectionComponent(Composite parent, LayoutItem item) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new FillLayout());
        ComponentHolder ch = this.createDisposableComponent(item.getComponentDescriptor(), control);
        ch.control = control;
        return ch;
    }

    public ComponentHolder createDisposableComponent(ComponentDescriptor cd, Composite disposeParent) {
        IComponentDecoration deco;
        ComponentHolder ch = new ComponentHolder();
        ch.component = this.createComponent(cd);
        String title = null;
        String description = null;
        int style = 0;
        if (ch.component != null && (deco = Dynamic.cast(ch.component, IComponentDecoration.class)) != null) {
            title = deco.getTitle();
            description = deco.getDescription();
            style = this.determineStyle(title, description);
        }
        UntogglableSection section = new UntogglableSection(this.m_toolkit, disposeParent, style);
        this.getToolkit().adapt((Composite)section);
        this.setTitleAndDescription(ch.component, section, title, description);
        Control control = this.createComponentControl((Composite)section, ch.component);
        this.getToolkit().adapt(control, true, true);
        section.setClient(control);
        return ch;
    }

    private void setTitleAndDescription(Object component, Section section, String title, String description) {
        if (component != null) {
            if (title != null) {
                section.setText(title);
            }
            if (description != null) {
                section.setDescription(description);
            }
        }
    }

    protected MCToolBarManager createToolbar(Section parent, ComponentDescriptor cd, String title) {
        if (title != null) {
            MCToolBarManager mct = new MCToolBarManager((Composite)parent);
            parent.setTextClient((Control)mct.getToolBar());
            this.m_locator.registerService(mct);
            Action action = HelpSupport.getHelpAction((String)cd.getIdentifier());
            if (action != null) {
                mct.add((IAction)action, MCToolBarManager.ALIGN_RIGHT);
            }
            return mct;
        }
        return null;
    }

    private int determineStyle(String title, String description) {
        int style = 0;
        if (this.hasValidText(description)) {
            style |= 0x80;
        }
        style = !this.hasValidText(title) ? (style |= 0x1000) : (style |= 0x148);
        return style;
    }

    private boolean hasValidText(String text) {
        return text != null && text.length() != 0;
    }

    public Control createComponentControl(Composite parent, Object component) {
        Control control = null;
        control = component != null ? this.initializeCreatePart(parent, component) : new UnknownComponent().createPart(parent);
        return control;
    }

    public Object createComponent(ComponentDescriptor cd) {
        if (cd != null) {
            Object object = cd.createComponent();
            if (object == null) {
                object = new UnknownComponent();
            }
            this.initializePersistence(cd, object);
            this.initializeComponent(object);
            return object;
        }
        return null;
    }

    private Control initializeCreatePart(Composite parent, Object object) {
        Control control = null;
        ICreateAccessiblePart aPart = Dynamic.cast(object, ICreateAccessiblePart.class);
        if (aPart != null && CorePlugin.getDefault().getAccessibilityMode()) {
            control = aPart.createAccessiblePart(parent);
        } else {
            ICreatePart part = Dynamic.cast(object, ICreatePart.class);
            if (part != null) {
                control = part.createPart(parent);
            }
        }
        return control;
    }

    private Control createExceptionComponent(Composite parent, String errorMessage, Exception e) {
        Composite container = this.m_toolkit.createComposite(parent);
        this.m_toolkit.paintBordersFor(container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        CLabel errorLabel = new CLabel(container, 0);
        errorLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        errorLabel.setText(errorMessage);
        errorLabel.setLayoutData((Object)gd1);
        this.m_toolkit.adapt((Composite)errorLabel);
        GridData gd3 = new GridData(4, 4, true, false);
        CLabel helpLabel = new CLabel(container, 0);
        helpLabel.setText("If this error was caused by a corrupt user interface file, resetting the user interface could potentially fix the issue. See Window -> Preferences.");
        helpLabel.setLayoutData((Object)gd3);
        this.m_toolkit.adapt((Composite)helpLabel);
        GridData gd2 = new GridData(4, 4, true, true);
        Text text = this.m_toolkit.createText(container, this.formatException(e), 514);
        text.setLayoutData((Object)gd2);
        return container;
    }

    private String formatException(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void initializePersistence(ComponentDescriptor cd, Object o) {
        IComponentDescribable persistable = Dynamic.cast(o, IComponentDescribable.class);
        if (persistable != null) {
            persistable.initialize(cd);
        }
    }

    private void initializeComponent(Object o) {
        IComponent component = Dynamic.cast(o, IComponent.class);
        if (component != null) {
            component.initialize(this.getServiceLocator().createChildService());
        }
    }

    public Composite buildDesigner(SelectionContext selectionContext, Composite parent, LayoutItem item) {
        Composite canvas = this.createDesignerCanvas(selectionContext, parent, item);
        for (LayoutItem lItem : item.getChildren()) {
            this.buildDesigner(selectionContext, canvas, lItem);
        }
        return canvas;
    }

    private Composite createDesignerCanvas(SelectionContext selectionContext, Composite parent, LayoutItem item) {
        LayoutItemCanvas canvas = new LayoutItemCanvas(selectionContext, parent, item, this.getServiceLocator());
        canvas.setLayoutData(item.getLayoutData());
        canvas.setLayout((Layout)item.getLayout());
        this.hookDesignerCanvas(selectionContext, parent, item, (Composite)canvas);
        return canvas;
    }

    private void hookDesignerCanvas(final SelectionContext selectionContext, final Composite parent, final LayoutItem item, final Composite canvas) {
        item.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                if (!canvas.isDisposed()) {
                    if (arg != null && arg.equals(Boolean.TRUE)) {
                        Control[] children = canvas.getChildren();
                        int n = 0;
                        while (n < children.length) {
                            children[n].dispose();
                            ++n;
                        }
                        for (LayoutItem li : item.getChildren()) {
                            GUIFactory.this.buildDesigner(selectionContext, canvas, li);
                        }
                    }
                    parent.layout(true, true);
                    parent.redraw();
                    parent.update();
                }
            }
        });
    }

    private FormToolkit getToolkit() {
        return this.m_toolkit;
    }

    private IServiceLocator getServiceLocator() {
        return this.m_locator;
    }

    public static class UntogglableSection
    extends Section {
        public UntogglableSection(FormToolkit toolkit, Composite parent, int sectionStyle) {
            super(parent, sectionStyle);
            this.setMenu(parent.getMenu());
            FormColors colors = toolkit.getColors();
            toolkit.adapt((Control)this, true, true);
            if (this.toggle != null) {
                this.toggle.setHoverDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
                this.toggle.setDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            }
            this.setFont(CorePlugin.getDefault().getFontColorToolkit().getStandardBoldFont());
            if ((sectionStyle & 0x100) != 0 || (sectionStyle & 0x200) != 0) {
                colors.initializeSectionToolBarColors();
                this.setTitleBarBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
                this.setTitleBarBorderColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
            }
            this.setTitleBarForeground(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        }

        public void setTitleBarForeground(Color color) {
            try {
                super.setTitleBarForeground(color);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public boolean isExpanded() {
            return false;
        }
    }
}

