/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.DesignModel;
import com.jrockit.mc.components.ui.design.DesignerPropertySheetPage;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.SelectionContext;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.services.IServiceLocatorProvider;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.core.formpage.internal.MCFormPage;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignerTab
extends MCFormPage {
    private final TabItemDescriptor m_tab;
    private IServiceLocator m_serviceLocator;
    private Composite m_container;
    private GUIFactory m_componentFactory;
    private IServiceLocator m_parentServiceLocator;

    public DesignerTab(FormEditor editor, TabItemDescriptor tab) {
        super(editor, tab.getIdentifier(), tab.getName());
        this.m_tab = tab;
        this.m_parentServiceLocator = ((IServiceLocatorProvider)this.getEditor()).getServiceLocator();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        LayoutItem item = this.m_tab.getLayoutItem();
        LayoutItem.initialize(item, this.getSite());
    }

    protected IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public void dispose() {
        super.dispose();
        this.unregisterMessageManager();
    }

    private void unregisterMessageManager() {
        if (this.m_serviceLocator != null) {
            this.m_serviceLocator.unregisterService("messageManager");
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.creatTabContents(managedForm);
    }

    private void registerMessagManager(IManagedForm managedForm) {
        this.m_serviceLocator.registerService("messageManager", managedForm.getMessageManager());
    }

    protected void scheduelCreateTabContents(final IManagedForm managedForm) {
        DisplayToolkit.safeTimerExec((Display)managedForm.getForm().getBody().getDisplay(), (int)800, (Runnable)new Runnable(){

            public void run() {
                if (!managedForm.getForm().getBody().isDisposed()) {
                    DesignerTab.this.creatTabContents(managedForm);
                }
            }
        });
    }

    private void creatTabContents(IManagedForm managedForm) {
        managedForm.getToolkit().decorateFormHeading(managedForm.getForm().getForm());
        managedForm.getForm().getBody().setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.m_container = this.createContainer(false);
        this.addDesignModeListner();
        this.registerMessagManager(managedForm);
    }

    private void addDesignModeListner() {
        this.getDesignModel().addObserver(new Observer(){

            public void update(Observable arg0, Object arg1) {
                DesignerTab.this.destroy();
                DesignerTab.this.m_container = DesignerTab.this.createContainer(true);
            }
        });
    }

    private Composite createContainer(boolean show) {
        this.m_serviceLocator = this.m_parentServiceLocator.createChildService();
        this.m_serviceLocator.registerService("workbenchPartSite", this.getSite());
        this.m_componentFactory = new GUIFactory(this.getServiceLocator());
        Composite container = this.getToolkit().createComposite(this.getManagedForm().getForm().getBody());
        container.setLayout((Layout)new SimpleLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.getDesignModel().isDesignerModeOn()) {
            this.createDesign(container);
        } else {
            this.createUI(container);
        }
        if (show) {
            this.show(this.m_serviceLocator);
        }
        Composite formBody = this.getManagedForm().getForm().getBody();
        formBody.layout(true, true);
        this.getManagedForm().getForm().getBody().update();
        return container;
    }

    private void show(IServiceLocator sl) {
        if (sl != null) {
            UIScope comp = sl.getService(UIScope.class);
            for (IShowable s : comp.getAllComponents(IShowable.class)) {
                s.show();
            }
        }
    }

    private DesignModel getDesignModel() {
        return this.getServiceLocator().getService(DesignModel.class);
    }

    private void createUI(Composite container) {
        this.m_componentFactory.buildUI(container, this.m_tab.getLayoutItem());
    }

    private void createDesign(Composite container) {
        this.m_componentFactory.buildDesigner(new SelectionContext(container), container, this.m_tab.getLayoutItem());
    }

    private void destroy() {
        if (this.m_container != null && !this.m_container.isDisposed()) {
            this.m_container.dispose();
        }
        this.m_container = null;
        if (this.m_serviceLocator != null) {
            UIScope ui = this.m_serviceLocator.getService(UIScope.class);
            if (ui.getParentScope() != null) {
                ui.getParentScope().removeChildScope(ui);
            }
            this.m_serviceLocator.dispose();
            this.m_serviceLocator = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.m_serviceLocator != null) {
            if (UIScope.class.equals((Object)adapter)) {
                return this.m_serviceLocator.getService(UIScope.class);
            }
            if (IServiceLocator.class.equals((Object)adapter)) {
                return this.m_serviceLocator;
            }
            Object object = this.findFirstAdaptableComponent(adapter);
            if (object != null) {
                return object;
            }
        }
        return super.getAdapter(adapter);
    }

    private Object findFirstAdaptableComponent(Class<?> adapter) {
        UIScope comps = this.m_serviceLocator.getService(UIScope.class);
        if (comps != null) {
            for (IAdaptable adaptable : comps.getComponentsInAncestorScopes(IAdaptable.class)) {
                Object object = adaptable.getAdapter(adapter);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public IPropertySheetPage getPropertiesSheetPage() {
        return new DesignerPropertySheetPage(this.m_componentFactory, this.m_tab.getPropertiesViewLayoutItem(), this.getServiceLocator());
    }
}

