/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.design.DesignModel;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.SelectionContext;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.layout.SimpleLayoutData;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public final class DesignerPropertySheetPage
implements IPropertySheetPage {
    private final GUIFactory m_factory;
    private final LayoutItem m_layoutItem;
    private final IServiceLocator m_serviceLocator;
    private AbstractUIComponent m_component;
    private Composite m_parent;
    private Control m_container;

    DesignerPropertySheetPage(GUIFactory factory, LayoutItem layoutItem, IServiceLocator serviceLocator) {
        this.m_factory = factory;
        this.m_layoutItem = layoutItem;
        this.m_serviceLocator = serviceLocator;
    }

    public void createControl(Composite parent) {
        this.m_parent = parent;
        SimpleLayout sl = new SimpleLayout();
        sl.setMargin(0);
        this.m_parent.setLayout((Layout)new SimpleLayout());
        this.m_container = this.createContainer(parent);
        this.addDesignModeListner();
    }

    private void addDesignModeListner() {
        this.getDesignModel().addObserver(new Observer(){

            public void update(Observable arg0, Object arg1) {
                this.destroy();
                DesignerPropertySheetPage.this.m_container = DesignerPropertySheetPage.this.createContainer(DesignerPropertySheetPage.this.m_parent);
            }

            private void destroy() {
                Control[] children = DesignerPropertySheetPage.this.m_parent.getChildren();
                int n = 0;
                while (n < children.length) {
                    children[n].dispose();
                    ++n;
                }
            }
        });
    }

    protected Control createContainer(Composite parent) {
        Object component;
        Object control = this.getDesignModel().isDesignerModeOn() ? this.m_factory.buildDesigner(new SelectionContext(parent), parent, this.m_layoutItem) : ((component = this.m_factory.createComponent(this.m_layoutItem.getComponentDescriptor())) == null ? new Composite(parent, 0) : this.m_factory.createComponentControl(parent, component));
        SimpleLayoutData sd3 = this.m_layoutItem.getLayoutData();
        sd3.setMinSize(150);
        sd3.setWeight(1.0f);
        control.setLayoutData((Object)sd3);
        return control;
    }

    private DesignModel getDesignModel() {
        return this.getServiceLocator().getService(DesignModel.class);
    }

    private IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public void dispose() {
        this.m_component.dispose(null);
    }

    public Control getControl() {
        return this.m_container;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        if (DisplayToolkit.isSafe((Widget)this.getControl())) {
            this.getControl().setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.m_component instanceof ISelectionListener) {
            ISelectionListener scl = (ISelectionListener)this.m_component;
            scl.selectionChanged(part, selection);
        }
    }
}

