/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.contributions.PathPlacementComparator;
import com.jrockit.mc.components.ui.contributions.SettingsFileToolkit;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.DesignModel;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.services.IServiceLocatorProvider;
import com.jrockit.mc.components.ui.services.ServiceLocator;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.ImageConverter;
import com.jrockit.mc.components.ui.tab.TabDescriptorRepository;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.components.ui.util.ImageDescriptor;
import com.jrockit.mc.core.MCPathEditorInput;
import com.jrockit.mc.core.MCPathFactory;
import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionGroup;
import com.jrockit.mc.core.formpage.FormPageContributionItem;
import com.jrockit.mc.core.formpage.IFormPageSelectorPart;
import com.jrockit.mc.core.formpage.internal.ButtonToolbarSelector;
import com.jrockit.mc.core.formpage.internal.FormPageContributionToolkit;
import com.jrockit.mc.core.formpage.internal.ToolbarFormEditor;
import com.jrockit.mc.core.misc.ErrorDialog;
import com.jrockit.mc.core.ui.IInputChangedListener;
import com.jrockit.mc.core.ui.IMCInputProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DesignEditor
extends ToolbarFormEditor
implements IMCInputProvider,
IServiceLocatorProvider {
    private IServiceLocator m_serviceLocator;
    private List<FormPageContribution> m_contribs;
    private ListenerList m_inputListener = new ListenerList();
    IAdaptable m_page = null;

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, DesignEditor.getValidEditorInput(input));
        this.m_serviceLocator = new ServiceLocator(null);
        this.m_serviceLocator.registerService(new DesignModel());
        this.m_serviceLocator.registerService("workbenchWindow", this.getSite().getWorkbenchWindow());
        this.m_serviceLocator.registerService("workbenchPartSite", this.getSite());
        this.m_serviceLocator.registerService(this.getContainerCopy(this.getEditorSite()));
        this.initialize(this.m_serviceLocator);
        this.initializeTabs(this.m_serviceLocator);
    }

    private Object getContainerCopy(IEditorSite site) throws PartInitException {
        UserInterfaceContribution container;
        try {
            container = ComponentsPlugin.getDefault().getUserInterfaceRepository().findContribution(site.getId());
        }
        catch (IOException e) {
            throw new PartInitException("Error loading settings file for editor " + site.getId());
        }
        return PersistenceToolkit.createWorkingCopy((Object)container);
    }

    protected void initializeTabs(IServiceLocator serviceLocator) {
        UserInterfaceContribution container = serviceLocator.getService(UserInterfaceContribution.class);
        TabDescriptorRepository tr = container.getUserInterface().getTabRepository();
        if (tr.getGroups().isEmpty()) {
            TabGroupDescriptor defaultTabGroupDescriptor = new TabGroupDescriptor();
            tr.getGroups().add(defaultTabGroupDescriptor);
            TabItemDescriptor tabItemDescriptor = new TabItemDescriptor();
            defaultTabGroupDescriptor.getTabs().add(tabItemDescriptor);
            this.getDesignerModel().setDesignerMode(true);
        }
        this.m_contribs = this.createContributions((Device)this.getSite().getWorkbenchWindow().getShell().getDisplay(), tr.getGroups());
        FormPageContributionToolkit.initializeContributionsWithEditor(this.m_contribs, (FormEditor)this);
        this.initializeToolbar();
        this.addShowHideListener((FormEditor)this);
    }

    protected void addShowHideListener(FormEditor editor) {
        editor.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() != DesignEditor.this.m_page) {
                    UIScope comp;
                    IServiceLocator sl;
                    if (DesignEditor.this.m_page != null && (sl = (IServiceLocator)DesignEditor.this.m_page.getAdapter(IServiceLocator.class)) != null) {
                        comp = sl.getService(UIScope.class);
                        for (IShowable s : comp.getAllComponents(IShowable.class)) {
                            s.hide();
                        }
                    }
                    DesignEditor.this.m_page = (IAdaptable)event.getSelectedPage();
                    sl = (IServiceLocator)DesignEditor.this.m_page.getAdapter(IServiceLocator.class);
                    if (sl != null) {
                        comp = sl.getService(UIScope.class);
                        for (IShowable s : comp.getAllComponents(IShowable.class)) {
                            s.show();
                        }
                    }
                }
            }
        });
    }

    private DesignModel getDesignerModel() {
        return this.m_serviceLocator.getService(DesignModel.class);
    }

    protected abstract void initialize(IServiceLocator var1) throws PartInitException;

    public boolean isSaveAsAllowed() {
        return false;
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    protected void initializeFormPageContributions() {
        for (FormPageContributionItem item : this.getFlattenedContributions()) {
            try {
                this.addFormPageContributionItem(item, this.getEditorInput());
            }
            catch (PartInitException e) {
                ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not initialize FormPageContribution item.", e);
            }
        }
        this.show((ISelection)((IStructuredSelection)this.getSelectorPart().getSelection()), true);
    }

    private List<FormPageContribution> createContributions(Device device, List<TabGroupDescriptor> groups) {
        ArrayList<FormPageContribution> contribs = new ArrayList<FormPageContribution>();
        ArrayList<TabGroupDescriptor> orderedGroups = new ArrayList<TabGroupDescriptor>(groups);
        Collections.sort(orderedGroups, new PathPlacementComparator());
        for (TabGroupDescriptor group : orderedGroups) {
            FormPageContributionGroup fGroup = new FormPageContributionGroup();
            fGroup.setLabel(group.getName());
            fGroup.setTooltip(group.getDescription());
            fGroup.setId(group.getIdentifier());
            fGroup.setIcon(this.getIcon(device, group, group.getIcon(), false), true);
            fGroup.setLargeIcon(this.getIcon(device, group, group.getLargeIcon(), true), true);
            fGroup.setVisible(Boolean.valueOf(true));
            contribs.add((FormPageContribution)fGroup);
            ArrayList<TabItemDescriptor> orderedTabs = new ArrayList<TabItemDescriptor>(group.getTabs());
            Collections.sort(orderedTabs, new PathPlacementComparator());
            for (TabItemDescriptor tab : orderedTabs) {
                DesignerTab dt = new DesignerTab((FormEditor)this, tab);
                FormPageContributionItem item = new FormPageContributionItem((IFormPage)dt);
                item.setLabel(tab.getName());
                item.setTooltip(tab.getDescription());
                item.setId(tab.getIdentifier());
                item.setIcon(this.getIcon(device, tab, tab.getIcon(), false), true);
                item.setVisible(Boolean.valueOf(true));
                fGroup.add((FormPageContribution)item);
            }
        }
        return contribs;
    }

    private Image getIcon(Device device, BaseDescriptor descriptor, ImageDescriptor iconData, boolean largeDefault) {
        Image image = ImageConverter.createImage(device, iconData);
        if (image == null) {
            image = largeDefault ? descriptor.createDefaultLargeIcon(device) : descriptor.createDefaultIcon(device);
        }
        return image;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    private void initializeToolbar() {
        ButtonToolbarSelector ifsp = new ButtonToolbarSelector();
        this.setSelector((IFormPageSelectorPart)ifsp);
        ifsp.setSelection((ISelection)new StructuredSelection(this.m_contribs));
        this.setSelectorVisible(true);
    }

    private static IEditorInput getValidEditorInput(IEditorInput input) {
        if (!(input instanceof MCPathEditorInput)) {
            MCPathEditorInput pathEditorInput = MCPathFactory.createMCPathEditorInput((IEditorInput)input, (boolean)false);
            if (pathEditorInput != null) {
                return pathEditorInput;
            }
            throw new IllegalArgumentException("Not valid input for FlightRecordingEditor");
        }
        return input;
    }

    private List getFlattenedContributions() {
        return FormPageContributionToolkit.flatten(this.m_contribs, FormPageContributionItem.class, (int)Integer.MAX_VALUE, (boolean)true);
    }

    public Object getAdapter(Class adapter) {
        IEditorPart part;
        if (IMessageManager.class.isAssignableFrom(adapter) && (part = this.getActiveEditor()) != null) {
            return part.getAdapter(adapter);
        }
        if (adapter == IPropertySheetPage.class) {
            return this.createWorkBenchPropertySheets();
        }
        part = this.getActiveEditor();
        if (part != null) {
            return part.getAdapter(adapter);
        }
        return null;
    }

    public Object getInput() {
        return this.m_serviceLocator;
    }

    @Override
    public IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public void addInputChangedListener(IInputChangedListener listener) {
        this.m_inputListener.add((Object)listener);
    }

    public void removeInputChangedListener(IInputChangedListener listener) {
        this.m_inputListener.remove((Object)listener);
    }

    public void dispose() {
        UserInterfaceContribution contribution = this.m_serviceLocator.getService(UserInterfaceContribution.class);
        PersistenceToolkit.commit((Object)contribution);
        try {
            SettingsFileToolkit.persistContribution(contribution);
        }
        catch (IOException e) {
            ErrorDialog.showException((Shell)this.getSite().getShell(), (String)"Error seving user settings", (Throwable)e);
        }
        if (this.m_serviceLocator != null) {
            this.m_serviceLocator.dispose();
        }
        super.dispose();
    }
}

