/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.contributions;

import com.jrockit.mc.components.ui.contributions.ActivationPolicy;
import com.jrockit.mc.components.ui.contributions.SettingsFileToolkit;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContributionFactory;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContributionMerger;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserInterfaceContributionRepository {
    private static final String ACTIVATE_BY_USER_POST_FIX = ".activatedByUser";
    private final Map<String, UserInterfaceContribution> m_containerCache = new LinkedHashMap<String, UserInterfaceContribution>();
    private final IPreferenceStore m_preferenceStore;

    public UserInterfaceContributionRepository(IPreferenceStore store) {
        this.m_preferenceStore = store;
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().endsWith(UserInterfaceContributionRepository.ACTIVATE_BY_USER_POST_FIX)) {
                    UserInterfaceContributionRepository.this.flush();
                }
            }
        });
    }

    public Collection<UserInterfaceContribution> getContributions() {
        return this.m_containerCache.values();
    }

    public UserInterfaceContribution findContribution(String id) throws IOException {
        UserInterfaceContribution contribution = this.m_containerCache.get(id);
        if (contribution == null) {
            contribution = UserInterfaceContributionFactory.createFromUserSettings(id);
            for (UserInterfaceContribution c : UserInterfaceContributionFactory.createFromExtensions()) {
                if (!this.isActivatable(c)) continue;
                UserInterfaceContributionMerger.merge(c, contribution);
            }
            this.m_containerCache.put(id, contribution);
        }
        return contribution;
    }

    private boolean isActivatable(UserInterfaceContribution source) {
        ActivationPolicy policy = source.getActivationPolicy();
        if (policy == ActivationPolicy.ACTIVATE_BY_ASKING && !this.hasAskedAboutNewContribution(source)) {
            return this.askAboutContribution(source);
        }
        if (policy == ActivationPolicy.ACTIVATE_BV_USER) {
            return this.hasBeenActivatedByUser(source);
        }
        return policy == ActivationPolicy.ACTIVATE_BY_DEFAULT;
    }

    private boolean hasBeenActivatedByUser(UserInterfaceContribution container) {
        return this.m_preferenceStore.getBoolean(String.valueOf(container.getIdentifier()) + ACTIVATE_BY_USER_POST_FIX);
    }

    private String getAskedAboutActivationPreferenceKey(UserInterfaceContribution container) {
        return String.valueOf(container.getIdentifier()) + ".hasAskedAboutContribution";
    }

    private boolean askAboutContribution(UserInterfaceContribution source) {
        this.m_preferenceStore.setValue(this.getAskedAboutActivationPreferenceKey(source), true);
        return true;
    }

    private boolean hasAskedAboutNewContribution(UserInterfaceContribution source) {
        return this.m_preferenceStore.getBoolean(this.getAskedAboutActivationPreferenceKey(source));
    }

    private void flush() {
        this.m_containerCache.clear();
    }

    public void clearUserSettings(String id) {
        try {
            SettingsFileToolkit.clearContrubition(id);
            this.m_containerCache.remove(id);
            this.findContribution(id);
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to remove setting files.", e);
        }
    }
}

