/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.contributions;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.contributions.ActivationPolicy;
import com.jrockit.mc.components.ui.design.UI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;

public final class UserInterfaceContribution {
    private static final String IDENTIFIER = "identifier";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String USER_INTERFACE_FILENAME = "userInterfaceFilename";
    private static final String ACTIVATION_POLICY = "activationPolicy";
    private static final String CONTAINER_IDENTIFIER = "containerIdentifier";
    private static final String USER_INTERFACE = "userInterface";
    private static final String VERSION = "version";
    private static final String CREATED = "created";
    private final Setting m_setting = new Setting("userInterfaceContribution");

    static {
        PersistenceToolkit.registerFetcher(UserInterfaceContribution.class, (ISettingFetcher)new ISettingFetcher<UserInterfaceContribution>(){

            public Setting getSetting(UserInterfaceContribution container) {
                return container.m_setting;
            }
        });
    }

    public String getContainerName() {
        IEditorDescriptor ed = this.getWorkbench().getEditorRegistry().findEditor(this.getContainerIdentifier());
        if (ed == null) {
            return this.getContainerIdentifier();
        }
        return ed.getLabel();
    }

    private IEditorReference getEditorReference() {
        IEditorReference[] r = this.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = 0;
        while (n < r.length) {
            if (r[n].getId().equals(this.getContainerIdentifier())) {
                return r[n];
            }
            ++n;
        }
        return null;
    }

    public ImageDescriptor getContainerImageDescriptor() {
        IEditorDescriptor ed = this.getWorkbench().getEditorRegistry().findEditor(this.getContainerIdentifier());
        ImageDescriptor d = null;
        if (ed != null) {
            d = ed.getImageDescriptor();
        }
        if (d == null) {
            d = ComponentsPlugin.getDefault().getMCImageDescriptor("design.gif");
        }
        return d;
    }

    public boolean isOpen() {
        return this.getEditorReference() != null;
    }

    private IWorkbench getWorkbench() {
        return ComponentsPlugin.getDefault().getWorkbench();
    }

    public String getIdentifier() {
        return (String)this.m_setting.getChildObject(IDENTIFIER, String.class);
    }

    public UI getUserInterface() {
        return (UI)this.m_setting.getChildObject(USER_INTERFACE, UI.class);
    }

    public void setIdentifier(String identifier) {
        this.m_setting.setChildObject(IDENTIFIER, (Object)identifier);
    }

    public void setContainerIdentifier(String containerIdentifier) {
        this.m_setting.setChildObject(CONTAINER_IDENTIFIER, (Object)containerIdentifier);
    }

    public void setName(String name) {
        this.m_setting.setChildObject(NAME, (Object)name);
    }

    public void setDescription(String description) {
        this.m_setting.setChildObject(DESCRIPTION, (Object)description);
    }

    public void setUserInterfaceFilename(String fileName) {
        this.m_setting.setChildObject(USER_INTERFACE_FILENAME, (Object)fileName);
    }

    public void setActivationPolicy(ActivationPolicy policy) {
        this.m_setting.setChildObject(ACTIVATION_POLICY, (Object)policy.toString());
    }

    public String getVersion() {
        return (String)this.m_setting.getChildObject(VERSION, String.class);
    }

    public void getVersion(String version) {
        this.m_setting.setChildObject(VERSION, (Object)version);
    }

    public void setCreationTime(long timeStamp) {
        this.m_setting.setChildObject(CREATED, (Object)timeStamp);
    }

    public long getCreationTime() {
        return (Long)this.m_setting.getChildObject(CREATED, Long.class);
    }

    public String getContainerIdentifier() {
        return (String)this.m_setting.getChildObject(CONTAINER_IDENTIFIER, String.class);
    }

    public String getName() {
        return (String)this.m_setting.getChildObject(NAME, String.class);
    }

    public String getDescription(String description) {
        return (String)this.m_setting.getChildObject(DESCRIPTION, String.class);
    }

    public String getUserInterfaceFilename() {
        return (String)this.m_setting.getChildObject(USER_INTERFACE_FILENAME, String.class);
    }

    public ActivationPolicy getActivationPolicy() {
        return ActivationPolicy.createFromString((String)this.m_setting.getChildObject(ACTIVATION_POLICY, String.class));
    }
}

