/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.contributions;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.core.CorePlugin;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public final class SettingsFileToolkit {
    static final String SETTINGS_FILENAME = "userSettings";
    static final String FILE_EXTENSION_BACKUP = ".bak";
    static final String FILE_EXTENSION_NEW = ".new";
    static final String FILE_EXTENSION_STANDARD = ".xml";

    private SettingsFileToolkit() {
        throw new Error("Don't");
    }

    public static File getSettingsDirectory() throws IOException {
        return CorePlugin.getDefault().getSettingsDirectory();
    }

    public static File getNewUserSettingsFile(String id) throws IOException {
        return new File(SettingsFileToolkit.getContainerDirectory(id), "userSettings.new");
    }

    public static File getBackupUserSettingsFile(String id) throws IOException {
        return new File(SettingsFileToolkit.getContainerDirectory(id), "userSettings.bak");
    }

    public static File getUserSettingsFile(String id) throws IOException {
        return new File(SettingsFileToolkit.getContainerDirectory(id), "userSettings.xml");
    }

    public static File getContainerDirectory(String id) throws IOException {
        File settingsDirectory = SettingsFileToolkit.getSettingsDirectory();
        File file = new File(settingsDirectory, id);
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create persistence directory for " + id + " in " + file);
        }
        return file;
    }

    public static void persistContribution(UserInterfaceContribution contribution) throws IOException {
        File newFile = SettingsFileToolkit.getNewUserSettingsFile(contribution.getIdentifier());
        File bakFile = SettingsFileToolkit.getBackupUserSettingsFile(contribution.getIdentifier());
        File settingsFile = SettingsFileToolkit.getUserSettingsFile(contribution.getIdentifier());
        if (newFile.exists()) {
            SettingsFileToolkit.deleteFile(newFile);
        }
        PersistenceToolkit.exportObjectToFile((Object)contribution, (File)newFile);
        if (newFile.exists()) {
            if (bakFile.exists()) {
                SettingsFileToolkit.deleteFile(bakFile);
            }
            if (settingsFile.exists()) {
                SettingsFileToolkit.renameFile(settingsFile, bakFile);
            }
            SettingsFileToolkit.renameFile(newFile, settingsFile);
        }
    }

    public static void clearContrubition(String id) throws IOException {
        File file = null;
        file = SettingsFileToolkit.getUserSettingsFile(id);
        if (file != null && file.exists() && !file.delete()) {
            ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not delete user settings file " + file);
        }
        if ((file = SettingsFileToolkit.getBackupUserSettingsFile(id)) != null && file.exists() && !file.delete()) {
            ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not delete user settings file " + file);
        }
    }

    private static void renameFile(File source, File destination) {
        if (!source.renameTo(destination)) {
            ComponentsPlugin.getDefault().getLogger().log(Level.WARNING, "Persistence problems. Could not rename the file " + source + " to " + destination);
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete()) {
            ComponentsPlugin.getDefault().getLogger().log(Level.WARNING, "Persistence problems. Could not delete the file " + file + " needed for saving persistence file.");
        }
    }
}

