/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.components;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeRegistry;
import java.util.logging.Level;

public final class ComponentDescriptor {
    private static final String NAME = "name";
    private static final String TYPE_IDENTIFIER = "typeIdentifier";
    private static final String IDENTIFIER = "identifier";
    private static final String DESCRIPTION = "description";
    private static final String COMPONENTS_SETTINGS = "componentSettings";
    private final Setting m_setting = new Setting("componentDescriptor");

    static {
        PersistenceToolkit.registerFetcher(ComponentDescriptor.class, (ISettingFetcher)new ISettingFetcher<ComponentDescriptor>(){

            public Setting getSetting(ComponentDescriptor serviceDescriptor) {
                return serviceDescriptor.m_setting;
            }
        });
    }

    public ComponentDescriptor() {
        this.setIdentifier("myComponentDescriptor");
    }

    public String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public String getIdentifier() {
        return (String)this.m_setting.getChildObject(IDENTIFIER, String.class);
    }

    public void setIdentifier(String name) {
        this.m_setting.setChildObject(IDENTIFIER, (Object)name);
    }

    public String getTypeIdentifier() {
        return (String)this.m_setting.getChildObject(TYPE_IDENTIFIER, String.class);
    }

    public void setTypeIdentifier(String typeIdentifier) {
        this.m_setting.setChildObject(TYPE_IDENTIFIER, (Object)typeIdentifier);
    }

    public Setting getSetting() {
        return this.m_setting;
    }

    public Setting getComponentSettings() {
        return this.m_setting.getChild(COMPONENTS_SETTINGS);
    }

    public String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public void setDescription(String description) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(description);
    }

    public Object createComponent() {
        ComponentTypeRegistry ctr = ComponentsPlugin.getDefault().getComponentTypeRegistry();
        ComponentTypeDescriptor std = ctr.getComponentTypeDescriptor(this.getTypeIdentifier());
        if (std == null) {
            ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not find component type with id " + this.getTypeIdentifier());
            return null;
        }
        return ctr.createComponent(std);
    }

    public static ComponentDescriptor createNew(String componentTypeIdentifier) {
        ComponentTypeDescriptor ctd = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(componentTypeIdentifier);
        return ComponentDescriptor.createNew(ctd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentDescriptor createNew(ComponentTypeDescriptor std) {
        ComponentTypeDescriptor componentTypeDescriptor = std;
        synchronized (componentTypeDescriptor) {
            ComponentDescriptor descriptor = new ComponentDescriptor();
            descriptor.setTypeIdentifier(std.getId());
            descriptor.setIdentifier(std.getDefaultIdentifier());
            descriptor.setName(std.getName());
            return descriptor;
        }
    }
}

