/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.base;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.behaviors.IComponent;
import com.jrockit.mc.components.ui.behaviors.IComponentDecoration;
import com.jrockit.mc.components.ui.behaviors.IComponentDescribable;
import com.jrockit.mc.components.ui.behaviors.ICreatePart;
import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.behaviors.IUserConfigurable;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.handlers.MCContextMenuManager;
import com.jrockit.mc.core.site.IServiceRegistry;
import com.jrockit.mc.core.site.SectionSite;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractUIComponent
implements IComponent,
ICreatePart,
IComponentDescribable,
IShowable,
IComponentDecoration,
IUserConfigurable {
    public static final String MESSAGE_MANAGER_ID = "messageManager";
    private SectionSite m_site;
    private IWorkbenchPartSite m_workbenchPartSite;
    private ComponentDescriptor m_componentDescriptor;
    private boolean m_isDirty = true;
    private boolean m_initialized;
    private boolean m_visible;

    public boolean initialize(IServiceLocator serviceLocator) {
        this.m_workbenchPartSite = (IWorkbenchPartSite)serviceLocator.getService("workbenchPartSite");
        this.m_site = new SectionSite(this.getIdentifier(), this.m_workbenchPartSite, (IServiceRegistry)serviceLocator);
        return true;
    }

    protected final MenuManager getMenuManager() {
        if (!this.getSite().hasService(MenuManager.class)) {
            this.getSite().registerService(MenuManager.class, (Object)new MCContextMenuManager(this.getIdentifier()));
        }
        return (MenuManager)this.getSite().getService(MenuManager.class);
    }

    public void initialize(ComponentDescriptor cd) {
        this.m_componentDescriptor = cd;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        return true;
    }

    public final void show() {
        this.m_visible = true;
        if (!this.m_initialized) {
            this.m_initialized = true;
            this.initializeUI();
        }
        if (this.isDirty()) {
            this.m_isDirty = false;
            this.refresh();
        }
    }

    protected void initializeUI() {
    }

    private boolean isDirty() {
        return this.m_isDirty;
    }

    protected void markDirty() {
        this.m_isDirty = true;
        if (this.m_visible) {
            this.refresh();
        }
    }

    protected boolean isVisible() {
        return this.getControl().isVisible();
    }

    private Control getControl() {
        return null;
    }

    protected void refresh() {
    }

    public void hide() {
        this.m_visible = false;
    }

    protected String getHumanReadable() {
        return String.valueOf(this.getComponentDescriptor().getIdentifier()) + "\t (" + this.getComponentDescriptor().getName() + ")";
    }

    protected final ComponentDescriptor getComponentDescriptor() {
        return this.m_componentDescriptor;
    }

    protected final IWorkbenchPartSite getWorkbenhPartSite() {
        return this.m_workbenchPartSite;
    }

    protected final SectionSite getSite() {
        return this.m_site;
    }

    protected final IServiceLocator getServiceLocator() {
        return (IServiceLocator)this.m_site.getServiceRegistry();
    }

    protected final String getIdentifier() {
        return this.m_componentDescriptor.getIdentifier();
    }

    protected final FormToolkit getFormToolkit() {
        return this.getServiceLocator().getService(FormToolkit.class);
    }

    protected final UIScope getComponents() {
        return this.getServiceLocator().getService(UIScope.class);
    }

    protected final Setting getComponentSettings() {
        return this.m_componentDescriptor.getComponentSettings();
    }

    public String getTitle() {
        return this.getComponentDescriptor().getName();
    }

    public String getDescription() {
        return this.getComponentDescriptor().getDescription();
    }
}

