/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.configuration;

import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ColorInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.components.ui.settings.LocalizedStringInput;
import com.jrockit.mc.components.ui.settings.UnitInput;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import com.jrockit.mc.greychart.ui.model.TickDensityName;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.configuration.DataSeriesProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChartMasterDetailFactory
implements IMasterDetailFactory {
    private static final String DATA_SERIES_STYLE = "style";
    protected static final Field[] FIELD_PROTYPES = new Field[]{DataSeriesProvider.FIELD_NAME, DataSeriesProvider.FIELD_DESCRIPTION};
    private final YAxisDescriptor m_yaxisDescriptor;
    private final ChartDescriptor m_chartdescriptor;

    protected ChartMasterDetailFactory(ChartDescriptor chartdescriptor, YAxisDescriptor yAxisDescriptor) {
        this.m_yaxisDescriptor = yAxisDescriptor;
        this.m_chartdescriptor = chartdescriptor;
    }

    public abstract IInput createDetailBaseInput(Shell var1);

    public List<IInput> createDetailInput() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add((IInput)new LocalizedStringInput("name", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_NAME_INPUT_TEXT));
        list.add((IInput)new LocalizedStringInput("description", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_DESCRIPTION_INPUT_TEXT));
        list.addAll(this.createDataSourceInputs());
        list.add((IInput)new BooleanInput("showInLegend", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_SHOW_LEGEND_INPUT_TEXT));
        list.add((IInput)new BooleanInput("stack", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_STACK_INPUT_TEXT));
        list.add((IInput)new BooleanInput("drawLine", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_DRAW_LINE_INPUT_TEXT));
        list.add((IInput)new BooleanInput("filled", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_FILL_INPUT_TEXT));
        list.add(this.createDataSeriesStyle());
        list.add((IInput)new ColorInput("lineColor", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_LINE_COLOR_INPUT_TEXT));
        list.add((IInput)new ColorInput("topColor", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_FILL_COLOR_INPUT_TEXT));
        list.add((IInput)new ColorInput("bottomColor", Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_FILL_BOTTOM_COLOR_INPUT_TEXT));
        return list;
    }

    private IInput createDataSeriesStyle() {
        ComboInput ci = new ComboInput(DATA_SERIES_STYLE, Messages.CHART_COMPONENT_CONFIGURATION_DATA_SERIES_STYLE_INPUT_TEXT);
        ci.setItems(Style.createNameKeyMap());
        return ci;
    }

    private IInput createTickDensity() {
        ComboInput ci = new ComboInput("tickDensity", "Tick Density");
        ci.setItems(TickDensityName.createNameKeyMap());
        return ci;
    }

    protected abstract List<IInput> createDataSourceInputs();

    public List createDetailList() {
        return this.m_yaxisDescriptor.getDataSeries();
    }

    public List<IInput> createMainInputs() {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        inputs.add((IInput)new BooleanInput("visible", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_VISIBLE_INPUT_TEXT));
        inputs.add((IInput)new BooleanInput("showTickMarks", Messages.CHART_COMPONENT_CONFIGURATION_AXIS_SHOW_TICK_MARKS_INPUT_TEXT));
        inputs.add(this.createTickDensity());
        inputs.add((IInput)new BooleanInput("showGridLines", Messages.CHART_COMPONENT_CONFIGURATION_AXIS_SHOW_GRID_LINES_INPUT_TEXT));
        inputs.add((IInput)new BooleanInput("alwaysShowZero", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_ALWAYS_INCLUDE_ZERO_INPUT_TEXT));
        inputs.add((IInput)new BooleanInput("autoPad", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_PAD_AXIS_INPUT_TEXT));
        inputs.add((IInput)new BooleanInput("titleLegend", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_SHOW_AXIS_LEGEND_INPUT_TEXT));
        inputs.add((IInput)new LocalizedStringInput("title", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_NAME_INPUT_TEXT));
        inputs.add((IInput)new LocalizedStringInput("description", Messages.CHART_COMPONENT_CONFIGURATION_Y_AXIS_DESCRIPTION_INPUT_TEXT));
        inputs.add((IInput)new UnitInput("unit", false));
        return inputs;
    }

    public String createMasterTableTitle() {
        return Messages.CHART_COMPONENT_CONFIGURATION_MASTER_TABLE_TITLE;
    }

    public abstract List<Object> createNew(Shell var1);

    public StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer tableViewer = new FieldTableViewer(table, FIELD_PROTYPES);
        tableViewer.setContentProvider((IContentProvider)new DataSeriesProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(FIELD_PROTYPES, (IBaseLabelProvider)new DataSeriesLabelProvider(this.m_chartdescriptor, parent.getDisplay(), 12)));
        tableViewer.setInput(this.m_yaxisDescriptor.getDataSeries());
        return tableViewer;
    }
}

