/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.configuration;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.behaviors.IStatusProvider;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.components.ui.settings.MasterDetailInput;
import com.jrockit.mc.components.ui.util.StatusProvider;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.XAxisDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ChartConfigurationWidget
extends Composite
implements IStatusProvider {
    private final StatusProvider m_statusProvider = new StatusProvider();
    private final ChartDescriptor m_graphDescriptor;
    private final IMasterDetailFactory m_leftMmasterDetailFactory;
    private final IMasterDetailFactory m_rightMmasterDetailFactory;

    public ChartConfigurationWidget(Composite parent, ChartDescriptor graphDescriptor, IMasterDetailFactory leftMmasterDetailFactory, IMasterDetailFactory rightMasterDetailFactory) {
        super(parent, 0);
        this.m_graphDescriptor = graphDescriptor;
        this.m_leftMmasterDetailFactory = leftMmasterDetailFactory;
        this.m_rightMmasterDetailFactory = rightMasterDetailFactory;
        this.setLayout((Layout)new GridLayout());
        this.create(this);
    }

    private void create(Composite parent) {
        GridData gd2 = new GridData(4, 4, true, true);
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)gd2);
        tabFolder.setLayout((Layout)new FillLayout());
        TabItem ti1 = new TabItem(tabFolder, 0);
        ti1.setText(Messages.CHART_COMPONENT_CONFIGURATION_LEFT_Y_AXIS_TAB_TITLE);
        ti1.setControl((Control)this.createAxis(tabFolder, this.m_graphDescriptor.getLeftYAxis(), this.m_leftMmasterDetailFactory));
        TabItem ti2 = new TabItem(tabFolder, 0);
        ti2.setText(Messages.CHART_COMPONENT_CONFIGURATION_RIGHT_Y_AXIS_TAB_TITLE);
        ti2.setControl((Control)this.createAxis(tabFolder, this.m_graphDescriptor.getRightYAxis(), this.m_rightMmasterDetailFactory));
        TabItem ti3 = new TabItem(tabFolder, 0);
        ti3.setText(Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_TAB_TITLE);
        ti3.setControl(this.createXAxis(tabFolder, this.m_graphDescriptor.getXAxis()).getControl());
    }

    private InputPanel createXAxis(TabFolder tabFolder, XAxisDescriptor xAxisDescriptor) {
        ArrayList<BooleanInput> inputs = new ArrayList<BooleanInput>();
        inputs.add(new BooleanInput("visible", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_SHOW_AXIS_INPUT_TEXT));
        inputs.add(new BooleanInput("showTickMarks", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_SHOW_TICK_MARKS_INPUT_TEXT));
        inputs.add(new BooleanInput("showGridLines", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_SHOW_GRID_LINES_INPUT_TEXT));
        inputs.add(new BooleanInput("extrapolateMissing", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_EXTRAPOLATE_MISSING_DATA_INPUT_TEXT));
        return new InputPanel((Composite)tabFolder, (Object)xAxisDescriptor, inputs);
    }

    private MasterDetailInput createAxis(TabFolder tabFolder, YAxisDescriptor yaAxisDescriptor, IMasterDetailFactory mdFactory) {
        MasterDetailInput mdi = new MasterDetailInput((Composite)tabFolder, PersistenceToolkit.getSetting((Object)yaAxisDescriptor), mdFactory);
        this.m_statusProvider.addStatusProvider((IStatusProvider)mdi);
        return mdi;
    }

    public void addStatusListener(IStatusListener listener) {
        this.m_statusProvider.addStatusListener(listener);
    }

    public IStatus getStatus() {
        return this.m_statusProvider.getStatus();
    }

    public void removeStatusListener(IStatusListener listener) {
        this.m_statusProvider.addStatusListener(listener);
    }
}

