/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.chart;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.ui.SwingComponentWrapperCanvas;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.ITimestampedDataVisualizer;
import com.jrockit.mc.greychart.ui.views.chart.FieldFormatter;
import java.util.List;
import javax.swing.JComponent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.AbstractAxis;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.DataSeriesProvider;
import se.hirt.greychart.data.SeriesProvider;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultXYLineRenderer;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.EmptyTitleRenderer;
import se.hirt.greychart.impl.NanoTimestampFormatter;
import se.hirt.greychart.impl.NanosXAxis;
import se.hirt.greychart.impl.TimestampedDataProvider;

public final class ChartViewer
implements ITimestampedDataVisualizer {
    private final Composite m_container;
    private final ChartDescriptor m_graphDescriptor;
    private final SeriesProvider m_dataSeriesProvider;
    private DefaultXYGreyChart m_chart;
    private DataChangeListener m_paintListener;

    public ChartViewer(Composite parent, FormToolkit toolkit, ChartDescriptor graphDescriptor, SeriesProvider dsp) {
        this.m_dataSeriesProvider = dsp;
        this.m_chart = ChartViewer.create((DataSeriesProvider)dsp);
        this.m_graphDescriptor = graphDescriptor;
        this.configureChart(this.m_chart);
        this.m_container = new SwingComponentWrapperCanvas(parent, (JComponent)new GreyChartPanel((GreyChart)this.m_chart));
        this.m_paintListener = new DataChangeListener(){

            public void onDataChange(DataChangeEvent event) {
                ChartViewer.this.m_container.redraw();
                ChartViewer.this.m_container.update();
            }
        };
        this.m_container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartViewer.this.getTimeStampedDataProvider().removeChangeListener(ChartViewer.this.m_paintListener);
            }
        });
        this.m_container.setLayout((Layout)new FillLayout());
        this.refresh();
    }

    public static DefaultXYGreyChart create(DataSeriesProvider dsp) {
        DefaultXYGreyChart chart = new DefaultXYGreyChart();
        chart.setDataProvider((DataProvider)dsp);
        chart.setXAxis((XAxis)ChartViewer.createNanoAxis(chart));
        chart.addYAxis((YAxis)ChartViewer.createYAxis(chart, YAxis.Position.LEFT));
        chart.addYAxis((YAxis)ChartViewer.createYAxis(chart, YAxis.Position.RIGHT));
        chart.setAntialiasingEnabled(true);
        chart.setTitleRenderer((ChartRenderer)new EmptyTitleRenderer((GreyChart)chart, 5));
        chart.setAutoUpdateOnDataChange(false);
        chart.setAutoUpdateOnAxisChange(true);
        chart.setAntialiasingEnabled(ChartViewer.isUsingAntialiasing());
        return chart;
    }

    private static boolean isUsingAntialiasing() {
        return CorePlugin.getDefault().getPreferenceStore().getBoolean("graphics.antialiasing");
    }

    private static DefaultYAxis createYAxis(DefaultXYGreyChart chart, YAxis.Position position) {
        DefaultYAxis yAxis = new DefaultYAxis((GreyChart)chart);
        yAxis.setMin(null);
        yAxis.setMax(null);
        yAxis.setAutoPadding(0.1);
        yAxis.setAutoRangeEnabled(true);
        yAxis.setPosition(position);
        return yAxis;
    }

    private static NanosXAxis createNanoAxis(DefaultXYGreyChart chart) {
        NanosXAxis nan = new NanosXAxis((GreyChart)chart);
        nan.setTickMarksEnabled(true);
        nan.setPaintGridLinesEnabled(true);
        nan.setFormatter((TickFormatter)new NanoTimestampFormatter());
        return nan;
    }

    private DefaultXYGreyChart getChart() {
        return this.m_chart;
    }

    public TimestampedDataProvider getTimeStampedDataProvider() {
        if (this.getChart().getDataProvider() instanceof TimestampedDataProvider) {
            return (TimestampedDataProvider)this.getChart().getDataProvider();
        }
        return null;
    }

    private ChartDescriptor getGraphDescriptor() {
        return this.m_graphDescriptor;
    }

    public Control getControl() {
        return this.m_container;
    }

    public void refresh() {
        if (this.getTimeStampedDataProvider() != null && this.m_container != null) {
            this.configureChart(this.m_chart);
            this.m_container.redraw();
            this.m_container.update();
        }
    }

    public void setRange(long startTimeNanos, long endTimeNanos) {
        ((NanosXAxis)this.getChart().getXAxis()).setRange((Number)startTimeNanos, (Number)endTimeNanos);
    }

    private void configureChart(DefaultXYGreyChart chart) {
        TimestampedDataProvider timestampedDataProvider = (TimestampedDataProvider)chart.getDataProvider();
        AbstractAxis x = (AbstractAxis)chart.getXAxis();
        ((DefaultXYLineRenderer)chart.getSeriesPlotRenderer()).setExtrapolateMissingData(this.getGraphDescriptor().getXAxis().getExtrapolateMissingData());
        x.setTitle("");
        x.setVisible(this.getGraphDescriptor().getXAxis().getVisible());
        x.setPaintGridLinesEnabled(this.getGraphDescriptor().getXAxis().getShowGridLines());
        x.setTickMarksEnabled(this.getGraphDescriptor().getXAxis().getShowTickMarks());
        YAxis[] yaxis = chart.getYAxis();
        YAxis leftYAxis = null;
        YAxis rightYAxis = null;
        YAxis[] yAxisArray = yaxis;
        int n = yaxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            YAxisDescriptor axisDescriptor = this.getAxisDescriptor(y);
            y.setTitle(axisDescriptor.getTitle());
            y.setVisible(axisDescriptor.getVisible());
            ((DefaultYAxis)y).setPaintGridLinesEnabled(axisDescriptor.getShowGridLines());
            ((DefaultYAxis)y).setTickMarksEnabled(axisDescriptor.getShowTickMarks());
            ((DefaultYAxis)y).setNumberOfTicks(6);
            ((DefaultYAxis)y).setTitleLegendEnabled(axisDescriptor.getShowTitleLegend());
            ((DefaultYAxis)y).setAlwaysShowZero(axisDescriptor.getAlwaysShowZero());
            ((DefaultYAxis)y).setAutoPadding(axisDescriptor.getAutoPad() ? 0.1 : 0.0);
            ((DefaultYAxis)y).setFormatter((TickFormatter)new FieldFormatter(axisDescriptor.getUnit()));
            ((DefaultYAxis)y).setContentType(this.getContentType(axisDescriptor.getUnit()));
            ((DefaultYAxis)y).setTickDensity(axisDescriptor.getTickDensity());
            if (axisDescriptor.getUnit().getDisplayUnit().getContentType().equals(UnitLookup.PERCENTAGE)) {
                ((DefaultYAxis)y).setAutoRangeEnabled(false);
                ((DefaultYAxis)y).setRange((Number)0, (Number)1);
                ((DefaultYAxis)y).setNumberOfTicks(10);
            }
            if (y.getPosition() == YAxis.Position.LEFT) {
                leftYAxis = y;
            } else if (y.getPosition() == YAxis.Position.RIGHT) {
                rightYAxis = y;
            }
            ++n2;
        }
        List<com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor> leftDescriptors = this.getGraphDescriptor().getDataSeriesDescriptors(YAxis.Position.LEFT);
        List<com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor> rightDescriptors = this.getGraphDescriptor().getDataSeriesDescriptors(YAxis.Position.RIGHT);
        int index = 0;
        int leftCount = leftDescriptors.size();
        DataSeries[] dataSeriesArray = timestampedDataProvider.getDataSeries();
        int n3 = dataSeriesArray.length;
        int n4 = 0;
        while (n4 < n3) {
            DefaultYAxis currentYAxis;
            com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor dsd;
            DataSeries ds = dataSeriesArray[n4];
            if (index < leftCount) {
                dsd = leftDescriptors.get(index);
                currentYAxis = (DefaultYAxis)leftYAxis;
            } else {
                dsd = rightDescriptors.get(index - leftCount);
                currentYAxis = (DefaultYAxis)rightYAxis;
            }
            DefaultDataSeriesDescriptor greyDescriptor = new DefaultDataSeriesDescriptor();
            greyDescriptor.setTopColor(dsd.getFilled() ? dsd.getTopColor().getAWTColor() : null);
            greyDescriptor.setBottomColor(dsd.getFilled() ? dsd.getBottomColor().getAWTColor() : null);
            greyDescriptor.setLineColor(dsd.getLineColor().getAWTColor());
            greyDescriptor.setName(dsd.getName());
            greyDescriptor.setDescription(dsd.getDescription());
            greyDescriptor.setMode(this.styleToRenderingMode(dsd.getStyle()));
            greyDescriptor.setStacking(dsd.getStack());
            greyDescriptor.setDrawLine(dsd.getDrawLine());
            greyDescriptor.setYAxis(currentYAxis);
            chart.setDescriptor(ds, (DataSeriesDescriptor)greyDescriptor);
            ++index;
            ++n4;
        }
        chart.setXAxis(chart.getXAxis());
    }

    private String getContentType(UnitDescriptor unit) {
        if (unit.getDisplayUnit().getContentType().equals(UnitLookup.MEMORY)) {
            return "bytes";
        }
        return "unknown";
    }

    private YAxisDescriptor getAxisDescriptor(YAxis y) {
        if (y.getPosition() == YAxis.Position.LEFT) {
            return this.getGraphDescriptor().getLeftYAxis();
        }
        return this.getGraphDescriptor().getRightYAxis();
    }

    private DataSeriesDescriptor.RenderingMode styleToRenderingMode(Style style) {
        switch (style) {
            case DENSITY: {
                return DataSeriesDescriptor.RenderingMode.DENSITY;
            }
            case NORMAL: {
                return DataSeriesDescriptor.RenderingMode.SUBSAMPLING;
            }
            case AVERAGING: {
                return DataSeriesDescriptor.RenderingMode.AVERAGING;
            }
            case INTEGRATING: {
                return DataSeriesDescriptor.RenderingMode.INTEGRATING;
            }
            case DENSITY_INTEGRATING: {
                return DataSeriesDescriptor.RenderingMode.DENSITY_INTEGRATING;
            }
        }
        return DataSeriesDescriptor.RenderingMode.AVERAGING;
    }

    public SeriesProvider getDataProvider() {
        return this.m_dataSeriesProvider;
    }
}

