/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.accessability;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.views.accessability.DataSeriesField;
import java.util.ArrayList;
import java.util.Iterator;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.data.SeriesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataValueProvider
extends AbstractFieldTableContentProvider {
    private static int FIELD_COUNT = 0;
    public static final Field FIELD_X = DataValueProvider.createValueField(Messages.ACCESSIBLE_CHART_VIEWER_COLUMN_X_NAME_TEXT, FIELD_COUNT++);
    public static final Field FIELD_Y = DataValueProvider.createValueField(Messages.ACCESSIBLE_CHART_VIEWER_COLUMN_Y_NAME_TEXT, FIELD_COUNT++);
    private SeriesProvider<IXYData<Long, Double>> m_seriesProvider;
    private final ChartDescriptor m_chartDescriptor;
    private long m_startTime = Long.MIN_VALUE;
    private long m_endTime = Long.MAX_VALUE;

    static Field createValueField(String name, int index) {
        DataSeriesField field = new DataSeriesField(index);
        field.setName(name);
        field.setVisible(true);
        field.setWidthWeight(1);
        field.setMinWidth(100);
        return field;
    }

    public DataValueProvider(ChartDescriptor cd, SeriesProvider<IXYData<Long, Double>> provider) {
        this.m_chartDescriptor = cd;
        this.m_seriesProvider = provider;
    }

    public Object[] getColumnObject(Object input) {
        IXYData xy = (IXYData)input;
        Object[] result = new Object[FIELD_COUNT];
        result[DataValueProvider.FIELD_X.INDEX] = ((Number)xy.getX()).longValue();
        result[DataValueProvider.FIELD_Y.INDEX] = xy.getY();
        return result;
    }

    public void setRange(Long startTime, long endTime) {
        this.m_startTime = startTime;
        this.m_endTime = endTime;
    }

    public Object[] getRowElements(Object input) {
        Integer index = (Integer)input;
        if (input != null && this.m_seriesProvider != null && index < this.m_seriesProvider.getDataSeries().length) {
            DataSeries ds = this.m_seriesProvider.getDataSeries()[index];
            ArrayList<IXYData> values = new ArrayList<IXYData>();
            Iterator it = ds.createIterator(Long.MIN_VALUE, Long.MAX_VALUE);
            while (it.hasNext()) {
                IXYData next = (IXYData)it.next();
                if ((Long)next.getX() < this.m_startTime || (Long)next.getX() > this.m_endTime) continue;
                values.add(next);
            }
            return values.toArray();
        }
        return new Object[0];
    }

    public ChartDescriptor getGraphDescriptor() {
        return this.m_chartDescriptor;
    }
}

