/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views.accessability;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.MultiField;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.core.ui.fields.FieldToolkit;
import com.jrockit.mc.greychart.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.AxisDescriptor;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.ITimestampedDataVisualizer;
import com.jrockit.mc.greychart.ui.views.accessability.DataSeriesField;
import com.jrockit.mc.greychart.ui.views.accessability.DataValueProvider;
import com.jrockit.mc.greychart.ui.views.accessability.SimpleDataSeriesProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.data.SeriesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibleChartViewer
implements ITimestampedDataVisualizer {
    private static Field[] FIELD_PROTOTYPES = new Field[]{DataValueProvider.FIELD_X, DataValueProvider.FIELD_Y};
    private final DataValueProvider m_dataValueProvider;
    private final Composite m_container;
    private final Map<ContentType, Field> m_contentTypeMapping = new LinkedHashMap<ContentType, Field>();
    private final SeriesProvider<IXYData<Long, Double>> m_dataSeriesProvider;
    private final ChartDescriptor m_chartDescriptor;
    private ComboViewer m_comboViewer;
    private FieldTableViewer m_tableViewer;

    public AccessibleChartViewer(Composite parent, FormToolkit formToolkit, ChartDescriptor chartDescriptor, SeriesProvider<IXYData<Long, Double>> provider) {
        this.m_dataSeriesProvider = provider;
        this.m_dataValueProvider = new DataValueProvider(chartDescriptor, provider);
        this.initializeFieldContentTypeMapping();
        this.m_container = formToolkit.createComposite(parent);
        this.m_container.setLayout((Layout)new GridLayout(2, false));
        this.m_container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        formToolkit.paintBordersFor(this.m_container);
        this.create(this.m_container, formToolkit);
        this.m_chartDescriptor = chartDescriptor;
        this.m_comboViewer.setInput((Object)chartDescriptor);
        this.m_comboViewer.refresh();
        if (!chartDescriptor.getDataSeriesDescriptors().isEmpty()) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)chartDescriptor.getDataSeriesDescriptors().get(0)), true);
        }
    }

    void initializeFieldContentTypeMapping() {
        this.m_contentTypeMapping.put(UnitLookup.MEMORY, DataSeriesField.BYTE_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.TIMESTAMP, DataSeriesField.TIME_STAMP_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.PERCENTAGE, DataSeriesField.PERCENTAGE_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.TIMESPAN, DataSeriesField.TIME_SPAN_FIELD);
        this.m_contentTypeMapping.put(UnitLookup.COUNT, DataSeriesField.NUMBERFIELD_FIELD);
    }

    private void create(Composite parent, FormToolkit toolkit) {
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        Label label = toolkit.createLabel(parent, Messages.ACCESSIBLE_CHART_VIEWER_DATASERIES_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        this.m_comboViewer = this.createComboViewer(parent, toolkit);
        this.m_comboViewer.getControl().setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.m_tableViewer = this.createTableViewer(parent, toolkit);
        this.m_tableViewer.getControl().setLayoutData((Object)gd3);
        UnitDescriptor unitDescriptor = new UnitDescriptor();
        unitDescriptor.setDisplayUnit((DisplayUnit)UnitLookup.TIMESTAMP.getDisplayUnits().get(0));
        this.getChartDescriptor().getXAxis().setUnit(unitDescriptor);
    }

    private ComboViewer createComboViewer(Composite parent, FormToolkit toolkit) {
        Combo combo = new Combo(parent, 65544);
        combo.setVisibleItemCount(15);
        toolkit.adapt((Composite)combo);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setContentProvider((IContentProvider)new SimpleDataSeriesProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider(this.m_chartDescriptor, parent.getDisplay(), 12));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (!ss.isEmpty()) {
                    AccessibleChartViewer.this.selectDataSeries((DataSeriesDescriptor)ss.getFirstElement());
                }
            }
        });
        return viewer;
    }

    private void selectDataSeries(DataSeriesDescriptor selected) {
        int index = 0;
        for (DataSeriesDescriptor dsd : this.getChartDescriptor().getDataSeriesDescriptors()) {
            if (dsd.equals(selected)) {
                this.setupFields(selected);
                this.m_tableViewer.setInput((Object)new Integer(index));
            }
            ++index;
        }
    }

    private void setupFields(DataSeriesDescriptor dsd) {
        YAxisDescriptor yaAxisDescriptor = this.getAxisFromIndex(dsd);
        String name = dsd.getName();
        this.updateField(this.getYField(), yaAxisDescriptor, name);
        this.updateField(this.getXField(), this.getChartDescriptor().getXAxis(), "Time");
        this.m_tableViewer.refreshLayout(true);
    }

    private YAxisDescriptor getAxisFromIndex(DataSeriesDescriptor dsd) {
        if (this.getChartDescriptor().getLeftYAxis().getDataSeries().contains(dsd)) {
            return this.getChartDescriptor().getLeftYAxis();
        }
        return this.getChartDescriptor().getRightYAxis();
    }

    private MultiField getYField() {
        return (MultiField)this.m_tableViewer.getFields()[1];
    }

    private MultiField getXField() {
        return (MultiField)this.m_tableViewer.getFields()[0];
    }

    private void updateField(MultiField field, AxisDescriptor axisDescriptor, String name) {
        UnitDescriptor unit = axisDescriptor.getUnit();
        ContentType ct = unit.getDisplayUnit().getContentType();
        field.selectField(this.lookupField(ct));
        field.setName(name);
    }

    private Field lookupField(ContentType ct) {
        Field field = this.m_contentTypeMapping.get(ct);
        return field == null ? DataSeriesField.NUMBERFIELD_FIELD : field;
    }

    private FieldTableViewer createTableViewer(Composite parent, FormToolkit formToolkit) {
        Table table = formToolkit.createTable(this.m_container, 268501762);
        FieldTableViewer viewer = new FieldTableViewer(table, FieldToolkit.instantiateFieldArray((Field[])FIELD_PROTOTYPES));
        viewer.setContentProvider((IContentProvider)this.m_dataValueProvider);
        return viewer;
    }

    @Override
    public Control getControl() {
        return this.m_container;
    }

    private ChartDescriptor getChartDescriptor() {
        return this.m_dataValueProvider.getGraphDescriptor();
    }

    @Override
    public void refresh() {
        this.m_tableViewer.refresh();
    }

    @Override
    public SeriesProvider<IXYData<Long, Double>> getDataProvider() {
        return this.m_dataSeriesProvider;
    }

    @Override
    public void setRange(long startTime, long endTime) {
        this.m_dataValueProvider.setRange(startTime, endTime);
        this.m_tableViewer.refresh();
    }
}

