/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.views.legend.IPositionProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public final class DataSeriesLabelProvider
extends LabelProvider
implements IPositionProvider {
    private final Map<DataSeriesDescriptor, Image> m_thumbNailCache = new HashMap<DataSeriesDescriptor, Image>();
    private final Display m_display;
    private final int m_size;
    private final ChartDescriptor m_chartDescriptor;

    public DataSeriesLabelProvider(ChartDescriptor chartDescriptor, Display display, int size) {
        this.m_chartDescriptor = chartDescriptor;
        this.m_display = display;
        this.m_size = size;
    }

    public Image getImage(Object element) {
        DataSeriesDescriptor dsd = (DataSeriesDescriptor)element;
        Image image = this.m_thumbNailCache.get(element);
        if (image != null) {
            image.dispose();
        }
        image = dsd.getFilled() || !dsd.getDrawLine() ? this.createGradientImage(dsd.getTopColor(), dsd.getBottomColor()) : this.createGradientImage(dsd.getLineColor(), dsd.getLineColor());
        this.m_thumbNailCache.put(dsd, image);
        return image;
    }

    public int getPosition(Object element) {
        DataSeriesDescriptor dsd = (DataSeriesDescriptor)element;
        if (this.m_chartDescriptor.getLeftYAxis().getDataSeries().contains(dsd)) {
            return 16384;
        }
        return 131072;
    }

    private Image createGradientImage(MCColor topColor, MCColor bottomColor) {
        Image image = new Image((Device)this.m_display, this.m_size, this.m_size);
        GC gc = new GC((Drawable)image);
        Color color1 = topColor.createSWTColor((Device)this.m_display);
        Color color2 = bottomColor.createSWTColor((Device)this.m_display);
        Pattern gradient = new Pattern((Device)this.m_display, 0.0f, 0.0f, 0.0f, (float)this.m_size, color1, color2);
        gc.setBackgroundPattern(gradient);
        gc.fillRectangle(image.getBounds());
        gc.setForeground(this.m_display.getSystemColor(24));
        gc.drawRectangle(0, 0, this.m_size - 1, this.m_size - 1);
        color1.dispose();
        color2.dispose();
        gradient.dispose();
        gc.dispose();
        return image;
    }

    public String getText(Object element) {
        DataSeriesDescriptor dsd = (DataSeriesDescriptor)element;
        return dsd.getName();
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        for (Image image : this.m_thumbNailCache.values()) {
            image.dispose();
        }
        this.m_thumbNailCache.clear();
    }
}

