/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.model;

import java.util.LinkedHashMap;
import java.util.Map;
import se.hirt.greychart.TickDensity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TickDensityName {
    VARIABLE("variable", "Variable"),
    VERY_DENSE("veryDense", "Very dense"),
    DENSE("dense", "Dense"),
    NORMAL("normal", "Normal"),
    SPARSE("sparse", "Sparse"),
    VERY_SPARSE("verySparse", "Very sparse");

    private final String name;
    final String key;

    private TickDensityName(String key, String name) {
        this.name = name;
        this.key = key;
    }

    public static TickDensityName toName(String key) {
        TickDensityName[] tickDensityNameArray = TickDensityName.values();
        int n = tickDensityNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            TickDensityName s = tickDensityNameArray[n2];
            if (s.key.equals(key)) {
                return s;
            }
            ++n2;
        }
        return VARIABLE;
    }

    public static TickDensity toDensity(String key) {
        return TickDensityName.nameToDensity(TickDensityName.toName(key));
    }

    public static TickDensity nameToDensity(TickDensityName name) {
        switch (name) {
            case VERY_DENSE: {
                return TickDensity.VERY_DENSE;
            }
            case DENSE: {
                return TickDensity.DENSE;
            }
            case NORMAL: {
                return TickDensity.NORMAL;
            }
            case SPARSE: {
                return TickDensity.SPARSE;
            }
            case VERY_SPARSE: {
                return TickDensity.VERY_SPARSE;
            }
        }
        return TickDensity.VARIABLE;
    }

    public static Map<String, String> createNameKeyMap() {
        LinkedHashMap<String, String> styleMap = new LinkedHashMap<String, String>();
        styleMap.put(TickDensityName.VARIABLE.key, TickDensityName.VARIABLE.name);
        styleMap.put(TickDensityName.VERY_DENSE.key, TickDensityName.VERY_DENSE.name);
        styleMap.put(TickDensityName.DENSE.key, TickDensityName.DENSE.name);
        styleMap.put(TickDensityName.NORMAL.key, TickDensityName.NORMAL.name);
        styleMap.put(TickDensityName.SPARSE.key, TickDensityName.SPARSE.name);
        styleMap.put(TickDensityName.VERY_SPARSE.key, TickDensityName.VERY_SPARSE.name);
        return styleMap;
    }
}

