/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.model;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.XAxisDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.hirt.greychart.YAxis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChartDescriptor {
    private static final String X_AXIS = "xAxis";
    private static final String RIGHT_YAXIS = "rightYaxis";
    private static final String LEFT_YAXIS = "leftYaxis";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    public static final String NAME = "chartDescriptor";
    private final Setting m_setting = new Setting("chartDescriptor");

    static {
        PersistenceToolkit.registerFetcher(ChartDescriptor.class, (ISettingFetcher)new ISettingFetcher<ChartDescriptor>(){

            public Setting getSetting(ChartDescriptor graphDescriptor) {
                return graphDescriptor.m_setting;
            }
        });
    }

    public ChartDescriptor() {
        this.getXAxis().setVisible(true);
        this.getLeftYAxis().setVisible(true);
        this.getLeftYAxis().setTitle("");
        this.getRightYAxis().setVisible(false);
        this.getRightYAxis().setTitle("");
    }

    public List<DataSeriesDescriptor> getDataSeriesDescriptors(YAxis.Position position) {
        ArrayList<DataSeriesDescriptor> list = new ArrayList<DataSeriesDescriptor>();
        if (position == YAxis.Position.LEFT) {
            list.addAll(this.getLeftYAxis().getDataSeries());
        } else {
            list.addAll(this.getRightYAxis().getDataSeries());
        }
        return Collections.unmodifiableList(list);
    }

    public List<DataSeriesDescriptor> getDataSeriesDescriptors() {
        ArrayList<DataSeriesDescriptor> list = new ArrayList<DataSeriesDescriptor>();
        list.addAll(this.getLeftYAxis().getDataSeries());
        list.addAll(this.getRightYAxis().getDataSeries());
        return Collections.unmodifiableList(list);
    }

    public List<DataSeriesDescriptor> getLegendDescriptors() {
        ArrayList<DataSeriesDescriptor> list = new ArrayList<DataSeriesDescriptor>();
        for (DataSeriesDescriptor ds : this.getDataSeriesDescriptors()) {
            if (!ds.getShowInLegend()) continue;
            list.add(ds);
        }
        return Collections.unmodifiableList(list);
    }

    public void setTitle(String title) {
        ((LocalizedString)this.m_setting.getChildObject(TITLE, LocalizedString.class)).setText(title);
    }

    public String getTitle() {
        return ((LocalizedString)this.m_setting.getChildObject(TITLE, LocalizedString.class)).getText();
    }

    public String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public void setDescription(String description) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(description);
    }

    public YAxisDescriptor getLeftYAxis() {
        return (YAxisDescriptor)this.m_setting.getChildObject(LEFT_YAXIS, YAxisDescriptor.class);
    }

    public YAxisDescriptor getRightYAxis() {
        return (YAxisDescriptor)this.m_setting.getChildObject(RIGHT_YAXIS, YAxisDescriptor.class);
    }

    public XAxisDescriptor getXAxis() {
        return (XAxisDescriptor)this.m_setting.getChildObject(X_AXIS, XAxisDescriptor.class);
    }
}

