/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads.support;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.console.ui.misc.CompositeSupport;
import com.jrockit.mc.console.ui.threads.support.LockInfoCompositeSupport;
import com.jrockit.mc.console.ui.threads.support.MonitorInfoCompositeSupport;
import com.jrockit.mc.console.ui.threads.support.StackTraceElementCompositeSupport;
import javax.management.openmbean.CompositeData;

public class ThreadInfoCompositeSupport
extends CompositeSupport
implements IMCThread {
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String THREAD_STATE = "threadState";
    private static final String BLOCKED_TIME = "blockedTime";
    private static final String BLOCKED_COUNT = "blockedCount";
    private static final String WAITED_TIME = "waitedTime";
    private static final String WAITED_COUNT = "waitedCount";
    private static final String LOCK_NAME = "lockName";
    private static final String LOCK_OWNER_ID = "lockOwnerId";
    private static final String LOCK_OWNER_NAME = "lockOwnerName";
    private static final String STACK_TRACE = "stackTrace";
    private static final String SUSPENDED = "suspended";
    private static final String IN_NATIVE = "inNative";
    private static final String LOCK_INFO = "lockInfo";
    private static final String LOCKED_MONITORS = "lockedMonitors";
    private static final String LOCKED_SYNCS = "lockedSynchronizers";
    public static final double UNKNOWN_NUMBER_OF_CORES = -477623.0;
    public static final double CPU_TIME_NOT_ENABLED = -456236.0;
    public static final double TOO_MANY_THREADS = -356236.0;
    public static final long ALLOCATION_NOT_ENABLED = -256236L;
    private Boolean m_deadLocked;
    private double m_cpuTime = -456236.0;
    private long m_allocatedBytes = -256236L;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThreadInfoCompositeSupport)) {
            return false;
        }
        ThreadInfoCompositeSupport otherA = (ThreadInfoCompositeSupport)((Object)other);
        return this.getThreadId().equals(otherA.getThreadId());
    }

    public int hashCode() {
        return this.getThreadId().intValue();
    }

    public ThreadInfoCompositeSupport(CompositeData cd) {
        super(cd);
    }

    public Long getThreadId() {
        return this.getLong(THREAD_ID);
    }

    public String getThreadName() {
        return this.getString(THREAD_NAME);
    }

    public String getThreadState() {
        return this.getString(THREAD_STATE);
    }

    public Long getBlockedTime() {
        return this.getLong(BLOCKED_TIME);
    }

    public Long getBlockedCount() {
        return this.getLong(BLOCKED_COUNT);
    }

    public Long getWaitedTime() {
        return this.getLong(WAITED_TIME);
    }

    public Long getWaitedCount() {
        return this.getLong(WAITED_COUNT);
    }

    public LockInfoCompositeSupport getLockInfo() {
        return new LockInfoCompositeSupport(this.getCompositeData(LOCK_INFO));
    }

    public String getLockName() {
        return this.getString(LOCK_NAME);
    }

    public Long getLockOwnerId() {
        return this.getLong(LOCK_OWNER_ID);
    }

    public String getLockOwnerName() {
        return this.getString(LOCK_OWNER_NAME);
    }

    public StackTraceElementCompositeSupport[] getStackTrace() {
        CompositeData[] compositeData = this.getCompositeDataArray(STACK_TRACE);
        StackTraceElementCompositeSupport[] stackTraceElementProxies = new StackTraceElementCompositeSupport[compositeData.length];
        int n = 0;
        while (n < compositeData.length) {
            stackTraceElementProxies[n] = new StackTraceElementCompositeSupport(compositeData[n]);
            ++n;
        }
        return stackTraceElementProxies;
    }

    public Boolean isSuspended() {
        return this.getBoolean(SUSPENDED);
    }

    public Boolean isInNative() {
        return this.getBoolean(IN_NATIVE);
    }

    public MonitorInfoCompositeSupport[] getLockedMonitors() {
        CompositeData[] compositeData = this.getCompositeDataArray(LOCKED_MONITORS);
        MonitorInfoCompositeSupport[] monitorInfoProxies = new MonitorInfoCompositeSupport[compositeData.length];
        int n = 0;
        while (n < compositeData.length) {
            monitorInfoProxies[n] = new MonitorInfoCompositeSupport(compositeData[n]);
            ++n;
        }
        return monitorInfoProxies;
    }

    public LockInfoCompositeSupport[] getLockedSynchronizers() {
        CompositeData[] compositeData = this.getCompositeDataArray(LOCKED_SYNCS);
        LockInfoCompositeSupport[] lockInfoProxies = new LockInfoCompositeSupport[compositeData.length];
        int n = 0;
        while (n < compositeData.length) {
            lockInfoProxies[n] = new LockInfoCompositeSupport(compositeData[n]);
            ++n;
        }
        return lockInfoProxies;
    }

    public Boolean isDeadlocked() {
        return this.m_deadLocked;
    }

    public void setDeadlocked(Boolean deadLocked) {
        this.m_deadLocked = deadLocked;
    }

    public void setCPUTime(double threadCPUTime) {
        this.m_cpuTime = threadCPUTime;
    }

    public double getCPUTime() {
        return this.m_cpuTime;
    }

    public long getAllocatedBytes() {
        return this.m_allocatedBytes;
    }

    public void setAllocatedBytes(long allocatedBytes) {
        this.m_allocatedBytes = allocatedBytes;
    }

    public String getThreadGroup() {
        return null;
    }
}

