/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.PollManager;
import com.jrockit.mc.console.ui.threads.ThreadModelException;
import com.jrockit.mc.console.ui.threads.ThreadsPlugin;
import com.jrockit.mc.console.ui.threads.support.MonitorInfoCompositeSupport;
import com.jrockit.mc.console.ui.threads.support.StackTraceElementCompositeSupport;
import com.jrockit.mc.console.ui.threads.support.ThreadInfoCompositeSupport;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.eclipse.jface.util.IPropertyChangeListener;

public class ThreadsModel {
    private static final String THREAD_OBJECT_NAME = "java.lang:type=Threading";
    private static final String JROCKIT_THREADING_OBJECT_NAME = "oracle.jrockit.management:type=Threading";
    private static final String THREAD_ALL_THREAD_IDS = "AllThreadIds";
    private static final String THREAD_FIND_DEADLOCKED_THREADS = "findMonitorDeadlockedThreads";
    private static final String THREAD_GET_THREAD_INFO = "getThreadInfo";
    private static final String THREAD_GET_ALLOCATED_BYTES = "getAllocatedBytes";
    private static final String THREAD_GET_CPU_TIME = "getCpuTime";
    private static final String[] THREAD_ALL_THREAD_IDS_SIGNATURE = new String[]{"[J"};
    private static final String[] THREAD_GET_THREADS_INFO_WITH_STACKTRACES_SIGNATURE = new String[]{"[J", "int"};
    private static final String[] THREAD_GET_ALLOCATED_BYTES_SIGNATURE = new String[]{"[J"};
    private static final String[] THREAD_FIND_DEADLOCKED_THREADS_IDS_SIGNATURE = new String[0];
    private static final String[] THREAD_GET_CPU_TIME_SIGNATURE = new String[]{"[J"};
    private final PollManager m_pollManager = new PollManager();
    private final IConnectionHandle m_connectionHandle;
    private volatile boolean m_cpuTimeEnabled;
    private volatile boolean m_findDeadlocked;
    private volatile ThreadInfoCompositeSupport[] m_threads;
    private int m_numberOfCPUs = -1;
    private Map m_cpuSampleTimes = new HashMap();
    private boolean m_allocationEnabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ThreadsModel(IConnectionHandle connectionHandle) {
        ConsolePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_connectionHandle = connectionHandle;
    }

    public void dispose() {
        ConsolePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_pollManager.stop();
    }

    public void setDeadlockDetectionEnabled(boolean findDeadlocked) {
        if (findDeadlocked != this.m_findDeadlocked) {
            this.m_findDeadlocked = findDeadlocked;
            this.getPollManager().poll();
        }
    }

    private IMBeanService getMBeanService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMBeanService)this.m_connectionHandle.getService((Class)clazz);
    }

    public boolean isDeadlockeDetectionEnabled() {
        return this.m_findDeadlocked;
    }

    public PollManager getPollManager() {
        return this.m_pollManager;
    }

    public ObjectName getThreadMxBean() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(THREAD_OBJECT_NAME);
    }

    public int getNumberOfCPUs() {
        if (this.m_numberOfCPUs == -1) {
            IProxyNames names;
            Object result;
            this.m_numberOfCPUs = 0;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.jrockit.mc.rjmx.proxy.IProxyNames");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((result = this.getAttribute((names = (IProxyNames)this.m_connectionHandle.getService((Class)clazz)).getAttributeDescriptor(IProxyNames.Key.OS_CPU_LOADS))) != null) {
                this.m_numberOfCPUs = ((double[])result).length;
            }
        }
        return this.m_numberOfCPUs;
    }

    public ThreadInfoCompositeSupport[] getAllThreadIds() {
        return this.m_threads;
    }

    private void addCPUInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isCPUTimeEnabled()) {
            int cpuCores = this.getNumberOfCPUs();
            long[] threadIDs = ThreadsModel.toIDArray(tips);
            Object o = null;
            try {
                o = this.invoke(JROCKIT_THREADING_OBJECT_NAME, THREAD_GET_CPU_TIME, new Object[]{threadIDs}, THREAD_GET_CPU_TIME_SIGNATURE);
            }
            catch (InstanceNotFoundException e) {
                this.setCPUTimeEnabled(false);
                throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_CPU_TIME_NOT_AVAILABLE_MESSAGE, e);
            }
            long[] cpuTimes = null;
            cpuTimes = o instanceof long[] ? (long[])o : new long[]{};
            int n = 0;
            while (n < tips.length) {
                if (cpuCores > 0) {
                    tips[n].setCPUTime(this.calculateCPUTime(tips[n].getThreadId(), cpuTimes[n], cpuCores));
                } else {
                    tips[n].setCPUTime(-477623.0);
                }
                ++n;
            }
        }
    }

    public void setAllocationEnabled(boolean enabled) {
        this.m_allocationEnabled = enabled;
        this.getPollManager().poll();
    }

    public boolean isAllocationEnabled() {
        return this.m_allocationEnabled;
    }

    public void setCPUTimeEnabled(boolean enabled) {
        this.m_cpuSampleTimes.clear();
        this.m_cpuTimeEnabled = enabled;
        this.getPollManager().poll();
    }

    public boolean isCPUTimeEnabled() {
        return this.m_cpuTimeEnabled;
    }

    private double calculateCPUTime(Long threadId, long cpuTime, int cpus) {
        long wallClockTime = System.currentTimeMillis() * 1000L * 1000L;
        if (cpuTime != -1L) {
            CPUSample last = (CPUSample)this.m_cpuSampleTimes.get(threadId);
            if (last == null) {
                CPUSample sample = new CPUSample();
                sample.time = wallClockTime;
                sample.value = cpuTime;
                this.m_cpuSampleTimes.put(threadId, sample);
                return Double.NEGATIVE_INFINITY;
            }
            double cpuTimeDiff = cpuTime - last.value;
            long wallClockDiff = wallClockTime - last.time;
            last.value = cpuTime;
            last.time = wallClockTime;
            return wallClockDiff > 0L ? cpuTimeDiff / (double)((long)cpus * wallClockDiff) : Double.NEGATIVE_INFINITY;
        }
        return -456236.0;
    }

    private Object getAttribute(String mBean, String attributeName) {
        return this.getAttribute(new AttributeDescriptor(mBean, attributeName));
    }

    private Object getAttribute(AttributeDescriptor descriptor) {
        MBeanServerConnection connection;
        block5: {
            IMBeanService service;
            block4: {
                try {
                    service = this.getMBeanService();
                    if (service != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    ThreadsPlugin.getDefault().getLogger().log(Level.WARNING, "Error when getting information from ThreadMxBean.", e);
                    return null;
                }
            }
            connection = service.getMBeanServerConnection();
            if (connection != null) break block5;
            return null;
        }
        return connection.getAttribute(descriptor.getObjectName(), descriptor.getAttributeName());
    }

    private Object invoke(String mBean, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException {
        block8: {
            if (this.m_connectionHandle.isConnected()) break block8;
            return null;
        }
        try {
            return this.getMBeanService().getMBeanServerConnection().invoke(new ObjectName(mBean), operationName, params, signature);
        }
        catch (MalformedObjectNameException e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (MBeanException e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (ReflectionException e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (NullPointerException e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (IOException e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (JMRuntimeException e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        return null;
    }

    public void addDeadlockInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isDeadlockeDetectionEnabled()) {
            Object deadLockedIds = null;
            try {
                deadLockedIds = this.invoke(THREAD_OBJECT_NAME, THREAD_FIND_DEADLOCKED_THREADS, new Object[0], THREAD_FIND_DEADLOCKED_THREADS_IDS_SIGNATURE);
            }
            catch (InstanceNotFoundException e) {
                this.setDeadlockDetectionEnabled(false);
                throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_DEADLOCK_DETECTION_AVAILABLE_MESSAGE, e);
            }
            long[] deadlocked = null;
            deadlocked = deadLockedIds instanceof long[] ? (long[])deadLockedIds : new long[]{};
            int n = 0;
            while (n < tips.length) {
                if (tips[n] != null) {
                    tips[n].setDeadlocked(Boolean.FALSE);
                    int m = 0;
                    while (m < deadlocked.length) {
                        Long l = tips[n].getThreadId();
                        if (l != null && l == deadlocked[m]) {
                            tips[n].setDeadlocked(Boolean.TRUE);
                            break;
                        }
                        ++m;
                    }
                }
                ++n;
            }
        }
    }

    private void addAllocationInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isAllocationEnabled()) {
            Object o;
            long[] ids = ThreadsModel.toIDArray(tips);
            try {
                o = this.invoke(JROCKIT_THREADING_OBJECT_NAME, THREAD_GET_ALLOCATED_BYTES, new Object[]{ids}, THREAD_GET_ALLOCATED_BYTES_SIGNATURE);
            }
            catch (InstanceNotFoundException e) {
                this.setAllocationEnabled(false);
                throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_ALLOCATION_AVAILABLE_MESSAGE, e);
            }
            long[] allocs = null;
            allocs = o instanceof long[] ? (long[])o : new long[]{};
            int n = 0;
            while (n < tips.length) {
                if (tips[n] != null) {
                    tips[n].setAllocatedBytes(allocs[n]);
                }
                ++n;
            }
        }
    }

    private static long[] toIDArray(ThreadInfoCompositeSupport[] tips) {
        long[] ids = new long[tips.length];
        int i = 0;
        while (i < tips.length) {
            if (tips[i] != null) {
                ids[i] = tips[i].getThreadId();
            }
            ++i;
        }
        return ids;
    }

    public ThreadInfoCompositeSupport[] getThreadInfo(long[] threadIDArray, Integer depth) throws ThreadModelException {
        CompositeData[] object;
        Object[] params = new Object[]{threadIDArray, depth};
        CompositeData[] cdArray = object = this.getThreadInfos(params, THREAD_GET_THREADS_INFO_WITH_STACKTRACES_SIGNATURE);
        ThreadInfoCompositeSupport[] threadInfoWithStackTrace = new ThreadInfoCompositeSupport[cdArray.length];
        ArrayList<ThreadInfoCompositeSupport> result = new ArrayList<ThreadInfoCompositeSupport>();
        int n = 0;
        while (n < threadInfoWithStackTrace.length) {
            if (cdArray[n] != null) {
                result.add(new ThreadInfoCompositeSupport(cdArray[n]));
            }
            ++n;
        }
        ThreadInfoCompositeSupport[] threadInfoCompositeSupport = new ThreadInfoCompositeSupport[result.size()];
        result.toArray(threadInfoCompositeSupport);
        this.addDeadlockInformation(threadInfoCompositeSupport);
        this.addCPUInformation(threadInfoCompositeSupport);
        this.addAllocationInformation(threadInfoCompositeSupport);
        return threadInfoCompositeSupport;
    }

    public MonitorInfoCompositeSupport[] getLockedMonitors(StackTraceElementCompositeSupport step, ThreadInfoCompositeSupport threadInfo) {
        ArrayList<MonitorInfoCompositeSupport> list = new ArrayList<MonitorInfoCompositeSupport>();
        if (threadInfo != null) {
            MonitorInfoCompositeSupport[] monitorInfoProxy = threadInfo.getLockedMonitors();
            int n = 0;
            while (n < monitorInfoProxy.length) {
                if (monitorInfoProxy[n].getLockedStackFrame() == step) {
                    list.add(monitorInfoProxy[n]);
                }
                ++n;
            }
        }
        MonitorInfoCompositeSupport[] result = new MonitorInfoCompositeSupport[list.size()];
        list.toArray(result);
        return result;
    }

    public void resetThreadMax() {
        Object[] params = new Object[]{};
        String[] siganture = new String[]{};
        try {
            this.getMBeanService().getMBeanServerConnection().invoke(this.getThreadMxBean(), "resetPeakThreadCount", params, siganture);
        }
        catch (Exception e) {
            ThreadsPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
    }

    public void update() throws ThreadModelException {
        Object[] params;
        CompositeData[] objectInfos;
        Object result1 = this.getAttribute(THREAD_OBJECT_NAME, THREAD_ALL_THREAD_IDS);
        if (result1 instanceof long[] && (objectInfos = this.getThreadInfos(params = new Object[]{result1}, THREAD_ALL_THREAD_IDS_SIGNATURE)) != null) {
            ArrayList<ThreadInfoCompositeSupport> tList = new ArrayList<ThreadInfoCompositeSupport>(objectInfos.length);
            int n = 0;
            while (n < objectInfos.length) {
                if (objectInfos[n] != null) {
                    tList.add(new ThreadInfoCompositeSupport(objectInfos[n]));
                }
                ++n;
            }
            ThreadInfoCompositeSupport[] tips = new ThreadInfoCompositeSupport[tList.size()];
            tList.toArray(tips);
            this.m_threads = tips;
            this.addDeadlockInformation(tips);
            this.addCPUInformation(tips);
            this.addAllocationInformation(tips);
        }
    }

    private CompositeData[] getThreadInfos(Object[] params, String[] signature) throws ThreadModelException {
        Object result2;
        try {
            result2 = this.invoke(THREAD_OBJECT_NAME, THREAD_GET_THREAD_INFO, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE, e);
        }
        if (result2 instanceof CompositeData[]) {
            return (CompositeData[])result2;
        }
        throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE);
    }

    public boolean isConnected() {
        return this.m_connectionHandle.isConnected();
    }

    private static class CPUSample {
        public long time;
        public long value;

        private CPUSample() {
        }
    }
}

