/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.console.ui.threads.AllThreadsContentProvider;
import com.jrockit.mc.console.ui.threads.CPULoadBackgroundTablerPaint;
import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.PollManager;
import com.jrockit.mc.console.ui.threads.RefreshPollAction;
import com.jrockit.mc.console.ui.threads.ThreadModelException;
import com.jrockit.mc.console.ui.threads.ThreadsModel;
import com.jrockit.mc.console.ui.threads.ThreadsPlugin;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.sections.FieldTableViewerSectionPart;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ThreadTableSectionPart
extends FieldTableViewerSectionPart
implements PollManager.Pollable {
    private static Field[] FIELDPROTOTYPES = new Field[]{AllThreadsContentProvider.FIELD_THREAD_NAME, AllThreadsContentProvider.FIELD_THREAD_STATE, AllThreadsContentProvider.FIELD_BLOCKED_COUNT, AllThreadsContentProvider.FIELD_BLOCKED_TIME, AllThreadsContentProvider.FIELD_WAITED_COUNT, AllThreadsContentProvider.FIELD_WAITED_TIME, AllThreadsContentProvider.FIELD_CPU_TIME, AllThreadsContentProvider.FIELD_IS_DEADLOCKED, AllThreadsContentProvider.FIELD_LOCK_NAME, AllThreadsContentProvider.FIELD_LOCK_OWNER_ID, AllThreadsContentProvider.FIELD_LOCK_OWNER_NAME, AllThreadsContentProvider.FIELD_THREAD_ID, AllThreadsContentProvider.FIELD_IS_NATIVE, AllThreadsContentProvider.FIELD_IS_SUSPENDED, AllThreadsContentProvider.FIELD_ALLOCATED_BYTES};
    private static DateFormat m_dateFormat = DateFormat.getTimeInstance(2);
    private ThreadsModel m_threadsModel;
    private RefreshPollAction m_pollAction;
    private Button buttonCpuTiming;
    private Button buttonDeadlockDetection;
    private Button buttonAllocation;

    protected Composite createTopControl(Composite parent) {
        Composite container = this.getFormToolkit().createComposite(parent);
        this.m_fieldViewerFilterControl = this.createViewerFilterControl(container);
        this.buttonCpuTiming = this.createTimingButton(container);
        this.buttonDeadlockDetection = this.createDeadlockDetection(container);
        this.buttonAllocation = this.createAllocation(container);
        RowLayout layout = new RowLayout();
        layout.center = true;
        container.setLayout((Layout)layout);
        return container;
    }

    private Button createTimingButton(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.ThreadTableSectionPart_ENABLE_THREAD_CPU_PROFILING_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setCPUTimeEnabled(button.getSelection());
            }
        });
        return button;
    }

    private Button createDeadlockDetection(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.ThreadTableSectionPart_ENABLE_DEADLOCK_DETECTION_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setDeadlockDetectionEnabled(button.getSelection());
            }
        });
        return button;
    }

    private Button createAllocation(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.ThreadTableSectionPart_ENABLE_THREAD_ALLOCATION_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThreadTableSectionPart.this.m_threadsModel.setAllocationEnabled(button.getSelection());
            }
        });
        return button;
    }

    public ThreadTableSectionPart(Composite parent, FormToolkit toolkit, ThreadsModel threadsModel, String sectionIdetifier) {
        super(parent, toolkit, 384, sectionIdetifier, FIELDPROTOTYPES, ThreadsPlugin.getDefault().getMCDialogSettings());
        this.m_threadsModel = threadsModel;
    }

    protected ThreadsModel getModel() {
        return this.m_threadsModel;
    }

    public void initialize(IManagedForm form) {
        this.m_pollAction = new RefreshPollAction(Messages.ThreadTableSectionPart_REFRESH_STACK_TRACE, this.m_threadsModel.getPollManager(), this);
        this.getMCToolBarManager().add((IAction)this.m_pollAction);
        super.initialize(form);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.ThreadTableSectionPart_SECTION_TEXT);
        section.setDescription(Messages.ThreadTableSectionPart_SECTION_DESCRIPTION);
        section.setData("name", (Object)"threads.ThreadsTab.LiveThreadsTable");
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new AllThreadsContentProvider());
        this.getTableViewer().setInput((Object)this.getModel());
        int numberOfCPUS = this.getModel().getNumberOfCPUs();
        if (numberOfCPUS > 0) {
            this.getTableViewer().getTable().addListener(40, (Listener)new CPULoadBackgroundTablerPaint(this.getFields(), numberOfCPUS));
        }
        this.selectFirstElement();
    }

    public boolean poll() {
        Control control = this.getTableViewer().getControl();
        if (control == null || control.isDisposed()) {
            return false;
        }
        Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        if (!this.m_threadsModel.isConnected()) {
            return false;
        }
        try {
            this.m_threadsModel.update();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!ThreadTableSectionPart.this.m_threadsModel.isConnected()) {
                        ThreadTableSectionPart.this.m_threadsModel.getPollManager().stop();
                    }
                    ThreadTableSectionPart.this.getTableViewer().refresh();
                    Section section = ThreadTableSectionPart.this.getSection();
                    if (!section.isDisposed()) {
                        section.setDescription(NLS.bind((String)Messages.ThreadTableSectionPart_SECTION_DESCRIPTION_DATE, (Object)m_dateFormat.format(new Date())));
                    }
                }
            });
        }
        catch (ThreadModelException e) {
            this.updateButtonStatedFromModel();
            DialogToolkit.showExceptionDialogAsync((Display)this.getForm().getDisplay(), (String)Messages.ThreadTableSectionPart_DIALOG_FEATURE_NOT_AVAILABLE_TITLE0, (String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void updateButtonStatedFromModel() {
        DisplayToolkit.safeSyncExec((Display)this.getForm().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ThreadTableSectionPart.this.buttonCpuTiming.setSelection(ThreadTableSectionPart.this.getModel().isCPUTimeEnabled());
                ThreadTableSectionPart.this.buttonAllocation.setSelection(ThreadTableSectionPart.this.getModel().isAllocationEnabled());
                ThreadTableSectionPart.this.buttonDeadlockDetection.setSelection(ThreadTableSectionPart.this.getModel().isDeadlockeDetectionEnabled());
            }
        });
    }

    public final class FindDeadlockedAction
    extends Action {
        public FindDeadlockedAction(String name) {
            super(name, 2);
            this.setToolTipText(name);
            this.setChecked(false);
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("live-thread-deadlocked-16.PNG"));
            this.setDisabledImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("live-thread-deadlocked-grey-16.PNG"));
        }

        public void run() {
            ThreadTableSectionPart.this.getModel().setDeadlockDetectionEnabled(this.isChecked());
        }
    }
}

