/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.ThreadMasterDetailBlock;
import com.jrockit.mc.console.ui.threads.ThreadsModel;
import com.jrockit.mc.console.ui.threads.ThreadsPlugin;
import com.jrockit.mc.core.layout.ReflowExpansionListener;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.layout.SimpleLayoutData;
import com.jrockit.mc.rjmx.ConnectionDescriptorToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.ISectionPartModifier;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ThreadTab
extends ConsoleTab
implements XmlEnabled {
    private static final String PREFERENCE_KEY_THREADS_DATA = "threadsData";
    private static final String HELP_THREAD_TAB_THREAD_GRAPH_SECTION_CONTEXT = "com.jrockit.mc.console.ui.threads.help_ThreadGraphSection";
    private ThreadsModel m_model;
    private CombinedChartSectionPart m_graphSectionPart;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.m_model = new ThreadsModel(this.getConnectionHandle());
        if (!this.initTabFromStore(ThreadsPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_THREADS_DATA, this)) {
            this.createDefaults(managedForm);
        }
        managedForm.reflow(true);
    }

    private void createDefaults(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        if (this.supportJMXRMI()) {
            this.createThreadUsageGraph(managedForm, form.getBody(), false);
            this.createMasterDetailBlock(managedForm, form.getBody(), this.m_model);
        } else {
            this.createThreadUsageGraph(managedForm, form.getBody(), true);
        }
    }

    private boolean supportJMXRMI() {
        try {
            return !ConnectionDescriptorToolkit.isUsingRMP((IConnectionDescriptor)this.getConnectionHandle().getDescriptor());
        }
        catch (IOException e) {
            return false;
        }
    }

    public void createMasterDetailBlock(IManagedForm managedForm, Composite parent, ThreadsModel model) {
        ThreadMasterDetailBlock masterDetailBlock = new ThreadMasterDetailBlock((IFormPage)this, model);
        SimpleLayoutData layoutData = new SimpleLayoutData();
        layoutData.setWeight(1.0f);
        masterDetailBlock.createContent(managedForm, parent);
        this.setUpLayout(parent);
        masterDetailBlock.getSashForm().setLayoutData((Object)layoutData);
        masterDetailBlock.getSashForm().setWeights(new int[]{2, 1});
    }

    private void createThreadUsageGraph(IManagedForm managedForm, Composite parent, boolean single) {
        this.setUpLayout(parent);
        int style = single ? 256 : 258;
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, parent, this.getConnectionHandle());
        guiBuilder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)HELP_THREAD_TAB_THREAD_GRAPH_SECTION_CONTEXT);
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.ThreadGraphSectionPart_LIVE_THREAD_GRAPH_TITLE);
        guiBuilder.setProperty(AttributeVisualizerBuilder.STYLE, (Object)style);
        guiBuilder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_Y, (Object)Messages.ThreadGraphSectionPart_THREAD_COUNT_GRAPH_LABEL);
        guiBuilder.setProperty(AttributeVisualizerBuilder.RANGE_TYPE_AXIS_Y, (Object)1);
        this.setSectionPartModifierProperty(guiBuilder, managedForm, single);
        this.m_graphSectionPart = (CombinedChartSectionPart)guiBuilder.createChart();
        IProxyNames proxyNames = this.getMBeanService().getProxyNames();
        this.m_graphSectionPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.THREAD_PEAK_THREAD_COUNT));
        this.m_graphSectionPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.THREAD_THREAD_COUNT));
        this.m_graphSectionPart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.THREAD_DAEMON_THREAD_COUNT));
        this.m_graphSectionPart.setFormInput((Object)this.getConnectionHandle());
    }

    private void setUpLayout(Composite parent) {
        SimpleLayout layout = new SimpleLayout();
        layout.setHorizontalOrientation(false);
        parent.setLayout((Layout)layout);
    }

    public void dispose() {
        super.dispose();
        if (this.m_model != null) {
            this.m_model.dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(ThreadsPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_THREADS_DATA, this);
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getDescriptor().getGUID());
        this.m_graphSectionPart.exportToXml(e);
    }

    public String getComponentTag() {
        return "ThreadTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        IManagedForm managedForm = this.getManagedForm();
        Composite parent = managedForm.getForm().getBody();
        boolean single = !this.supportJMXRMI();
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)"CombinedChartSectionPart");
        if (this.listContainsChart(l)) {
            this.initializeChartFromXml(managedForm, parent, single, (Element)l.get(0));
        }
        if (!single) {
            this.createMasterDetailBlock(managedForm, parent, this.m_model);
        }
    }

    private boolean listContainsChart(List l) {
        return l != null && l.size() == 1;
    }

    private void initializeChartFromXml(IManagedForm managedForm, Composite parent, boolean single, Element element) throws Exception {
        this.setUpLayout(parent);
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        this.setSectionPartModifierProperty(guiBuilder, managedForm, single);
        this.m_graphSectionPart = (CombinedChartSectionPart)guiBuilder.createChart();
        this.m_graphSectionPart.initializeFromXml(element);
    }

    private void setSectionPartModifierProperty(AttributeVisualizerBuilder guiBuilder, final IManagedForm managedForm, final boolean single) {
        guiBuilder.setProperty("SectionPartModifier", (Object)new ISectionPartModifier(){

            public void modifySectionPart(SectionPart sectionPart) {
                Section section = sectionPart.getSection();
                if (!single) {
                    SimpleLayoutData sd = ReflowExpansionListener.createCollapsed((ExpandableComposite)section);
                    sd.setWeight(2.0f);
                    section.setLayoutData((Object)sd);
                    section.addExpansionListener((IExpansionListener)new ReflowExpansionListener(managedForm));
                    section.setExpanded(false);
                } else {
                    section.setLayoutData((Object)new SimpleLayoutData());
                    section.setExpanded(true);
                }
            }
        });
    }
}

