/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.PollManager;
import com.jrockit.mc.console.ui.threads.RefreshPollAction;
import com.jrockit.mc.console.ui.threads.StackTraceContentProvider;
import com.jrockit.mc.console.ui.threads.ThreadsModel;
import com.jrockit.mc.console.ui.threads.ThreadsPlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.sections.FieldTreeViewerSectionPart;
import com.jrockit.mc.core.ui.fields.FieldTreeViewer;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class StackTraceSectionPart
extends FieldTreeViewerSectionPart
implements PollManager.Pollable {
    private static DateFormat m_dateFormat = DateFormat.getTimeInstance(2);
    private final ThreadsModel m_threadsModel;
    private RefreshPollAction m_pollAction;
    public static final Field[] FIELD_PROTOTYPES = new Field[]{StackTraceContentProvider.FIELD_STACK_TRACE};

    public StackTraceSectionPart(Composite parent, String sectionIdentifier, IManagedForm form, ThreadsModel threadsModel) {
        super(parent, form.getToolkit(), 384, sectionIdentifier, FIELD_PROTOTYPES, ThreadsPlugin.getDefault().getMCDialogSettings());
        this.m_threadsModel = threadsModel;
    }

    public void initialize(IManagedForm form) {
        this.m_pollAction = new RefreshPollAction(Messages.StackTraceSectionPart_ACTION_REFRESH_STACK_TRACE_TEXT, this.m_threadsModel.getPollManager(), this);
        this.getMCToolBarManager().add((IAction)this.m_pollAction);
        super.initialize(form);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.StackTraceSectionPart_SECTION_TEXT);
        section.setDescription(Messages.StackTraceSectionPart_SECTION_DESCRIPTION);
    }

    public void saveDialogSettings(IDialogSettings settings) {
    }

    public void loadDialogSettings(IDialogSettings settings) {
    }

    protected void setupSelectionListeners() {
    }

    protected void initializePart() {
        super.initializePart();
        this.getTreeViewer().getTree().setHeaderVisible(false);
        this.ensureContentProvider();
        this.getTreeViewer().setInput(null);
    }

    void ensureContentProvider() {
        if (this.getTreeViewer().getContentProvider() == null) {
            this.getTreeViewer().setContentProvider((IContentProvider)new StackTraceContentProvider(this.m_threadsModel));
            this.getTreeViewer().setAutoExpandLevel(5);
        }
    }

    public boolean poll() {
        FieldTreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return false;
        }
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return false;
        }
        Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        if (!this.m_threadsModel.isConnected()) {
            return false;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                FieldTreeViewer viewer;
                if (!StackTraceSectionPart.this.m_threadsModel.isConnected()) {
                    StackTraceSectionPart.this.m_threadsModel.getPollManager().stop();
                }
                if ((viewer = StackTraceSectionPart.this.getTreeViewer()) != null && !viewer.getControl().isDisposed()) {
                    StackTraceSectionPart.this.getTreeViewer().setInput(StackTraceSectionPart.this.getTreeViewer().getInput());
                    StackTraceSectionPart.this.updateTimeStamp();
                }
            }
        });
        return true;
    }

    public void updateTimeStamp() {
        if (this.getSection() != null && !this.getSection().isDisposed()) {
            this.getSection().setDescription(NLS.bind((String)Messages.StackTraceSectionPart_SECTION_DESCRIPTION_DATE, (Object)m_dateFormat.format(new Date())));
        }
    }

    public void setInput(ISelection masterSelection) {
        this.ensureContentProvider();
        this.getTreeViewer().setInput((Object)masterSelection);
        this.updateTimeStamp();
    }
}

