/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.ThreadModelException;
import com.jrockit.mc.console.ui.threads.ThreadsModel;
import com.jrockit.mc.console.ui.threads.ThreadsPlugin;
import com.jrockit.mc.console.ui.threads.TraceMMXBeanMethodField;
import com.jrockit.mc.console.ui.threads.support.ThreadInfoCompositeSupport;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.AbstractFieldTreeContentProvider;
import com.jrockit.mc.core.ui.fields.FieldToolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class StackTraceContentProvider
extends AbstractFieldTreeContentProvider {
    public static int FIELD_COUNT;
    public static final Field FIELD_STACK_TRACE;
    private final ThreadsModel m_threadsModel;
    static /* synthetic */ Class class$0;

    static {
        FIELD_STACK_TRACE = new TraceMMXBeanMethodField(FIELD_COUNT++);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.console.ui.threads.StackTraceContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldToolkit.initializeFields((String)"com.jrockit.mc.console.ui.threads.fields", (Class)clazz);
    }

    public StackTraceContentProvider(ThreadsModel threadsModel) {
        this.m_threadsModel = threadsModel;
    }

    public Object[] getRowChildren(Object parentElement) {
        if (parentElement instanceof IStructuredSelection) {
            return this.getElements(parentElement);
        }
        if (parentElement instanceof ThreadInfoCompositeSupport) {
            return ((ThreadInfoCompositeSupport)((Object)parentElement)).getStackTrace();
        }
        return new Object[0];
    }

    public static long[] extractThreadIDsFromSelection(IStructuredSelection selection) {
        ArrayList<Long> threadIDs = new ArrayList<Long>();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            ThreadInfoCompositeSupport tics = (ThreadInfoCompositeSupport)((Object)iterator.next());
            Long id = tics.getThreadId();
            if (id == null) continue;
            threadIDs.add(id);
        }
        long[] threadIDArray = new long[threadIDs.size()];
        int n = 0;
        while (n < threadIDArray.length) {
            threadIDArray[n] = (Long)threadIDs.get(n);
            ++n;
        }
        return threadIDArray;
    }

    public Object[] getRowElements(Object inputElement) {
        if (inputElement instanceof IStructuredSelection) {
            long[] threadIDArray = StackTraceContentProvider.extractThreadIDsFromSelection((IStructuredSelection)inputElement);
            try {
                return this.m_threadsModel.getThreadInfo(threadIDArray, new Integer(Integer.MAX_VALUE));
            }
            catch (ThreadModelException e) {
                ThreadsPlugin.getDefault().getLogger().log(Level.WARNING, Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE, e);
            }
        }
        return new Object[0];
    }

    protected Object[] getColumnObject(Object object) {
        Object[] result = new Object[FIELD_COUNT];
        result[StackTraceContentProvider.FIELD_STACK_TRACE.INDEX] = object;
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected boolean hasRowChildren(Object element) {
        return this.getRowChildren(element).length > 0;
    }
}

