/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.console.ui.ConsolePlugin;
import java.util.Vector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PollManager
implements Runnable,
IPropertyChangeListener {
    private Vector m_pollableObjects = new Vector();
    private volatile long m_pollingInterval = 3000L;
    private volatile boolean m_keepAlive = false;

    public PollManager() {
        this.fetchUpdateInterval();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.fetchUpdateInterval();
    }

    public void fetchUpdateInterval() {
        int pollingInterval = ConsolePlugin.getDefault().getPreferenceStore().getInt("console.ui.threaddump.update.interval.");
        this.m_pollingInterval = pollingInterval == 0 ? 3000 : pollingInterval;
    }

    public synchronized void addPollee(Pollable pollee) {
        if (!this.m_pollableObjects.contains(pollee)) {
            this.m_pollableObjects.add(pollee);
            this.updatePollThread();
            this.notify();
        }
    }

    public synchronized void removePollee(Pollable pollee) {
        if (this.m_pollableObjects.remove(pollee)) {
            this.updatePollThread();
        }
    }

    public synchronized void resume() {
        this.updatePollThread();
    }

    public synchronized void pause() {
        this.stopIfNotStopped();
    }

    public void stop() {
        this.m_pollableObjects.clear();
        this.updatePollThread();
    }

    private void updatePollThread() {
        if (this.m_pollableObjects.size() > 0) {
            this.startIfNotStarted();
        } else {
            this.stopIfNotStopped();
        }
    }

    private void startIfNotStarted() {
        if (!this.m_keepAlive) {
            this.m_keepAlive = true;
            new Thread((Runnable)this, "Polling Thread").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIfNotStopped() {
        if (this.m_keepAlive) {
            this.m_keepAlive = false;
            PollManager pollManager = this;
            synchronized (pollManager) {
                this.notify();
            }
        }
    }

    public synchronized boolean isPolling(Pollable pollableObject) {
        return this.m_pollableObjects.contains(pollableObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_keepAlive) {
            try {
                if (this.m_keepAlive) {
                    this.pollAllPollees();
                }
                PollManager pollManager = this;
                synchronized (pollManager) {
                    this.wait(this.m_pollingInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAllPollees() {
        Vector vector = this.m_pollableObjects;
        synchronized (vector) {
            Object[] pollees = this.m_pollableObjects.toArray();
            int i = 0;
            while (i < pollees.length) {
                Pollable pollableObject = (Pollable)pollees[i];
                if (!pollableObject.poll()) {
                    this.m_pollableObjects.remove(pollableObject);
                }
                ++i;
            }
        }
    }

    public synchronized void poll() {
        this.notifyAll();
    }

    static interface Pollable {
        public boolean poll();
    }
}

