/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.console.connection.RmpPushHandler;
import com.jrockit.console.rmp.RMPOperation;
import com.jrockit.console.rmp.SubscribableRMPConnector;
import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public abstract class SubscriptionOperationCluster
implements RMPOperation {
    private static final int UPDATE_INTERVAL = 100;
    private SubscribableRMPConnector rmpConnector;
    private String subscriptionCommand;
    private LongValueSubscriptionListener subscriptionListener;
    private HashMap operationTargetToSubscriptionIDMap;
    private String setEnableOperationName;
    private String isOperationName;
    private String getOperationName;
    private String operationTargetType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SubscriptionOperationCluster(SubscribableRMPConnector rmpConnector, String enableOperationName, String isOperationName, String getOperationName, String operationTargetType, String subscriptionCommand) {
        this.setEnableOperationName = enableOperationName;
        this.isOperationName = isOperationName;
        this.getOperationName = getOperationName;
        this.rmpConnector = rmpConnector;
        this.operationTargetType = operationTargetType;
        this.subscriptionCommand = subscriptionCommand;
        this.operationTargetToSubscriptionIDMap = new HashMap();
        this.subscriptionListener = new LongValueSubscriptionListener();
    }

    public Object performRMPOperation(String operationName, Object[] params) throws IOException {
        if (operationName.equals(this.setEnableOperationName)) {
            this.setEnabled(params[0], (Boolean)params[1]);
            return null;
        }
        if (operationName.equals(this.isOperationName)) {
            return new Boolean(this.isEnabled(params[0]));
        }
        if (operationName.equals(this.getOperationName)) {
            return new Long(this.getOperationValue(params[0]));
        }
        throw new UnsupportedOperationException("Operation " + operationName + " could not be found.");
    }

    private long getOperationValue(Object operationTarget) {
        Long subscriptionID = (Long)this.operationTargetToSubscriptionIDMap.get(operationTarget);
        return this.subscriptionListener.getValue(subscriptionID);
    }

    private boolean isEnabled(Object o) {
        return this.operationTargetToSubscriptionIDMap.containsKey(o);
    }

    private void setEnabled(Object operationTarget, boolean enable) throws IOException {
        if (enable) {
            if (!this.operationTargetToSubscriptionIDMap.containsKey(operationTarget)) {
                if (this.operationTargetToSubscriptionIDMap.size() == 0) {
                    this.rmpConnector.registerSubscriptionListener(this.subscriptionListener);
                }
                Long subscriptionID = new Long(this.rmpConnector.createNewSubscriptionID());
                this.subscriptionListener.clearID(subscriptionID);
                this.startSubscription(subscriptionID, operationTarget);
                this.operationTargetToSubscriptionIDMap.put(operationTarget, subscriptionID);
            }
        } else {
            this.stopSubscription(operationTarget);
            if (this.operationTargetToSubscriptionIDMap.size() == 0) {
                this.rmpConnector.unregisterSubscriptionListener(this.subscriptionListener);
            }
        }
    }

    private void startSubscription(long subscriptionID, Object operationTarget) throws IOException {
        String aspectData = this.getAspectData(operationTarget);
        try {
            if (!this.rmpConnector.sendSubscribe(subscriptionID, aspectData, 100, true)) {
                throw new IOException("Enabling an RMP subscription by invoking the operation " + this.setEnableOperationName + " and sending RMP subscription command " + aspectData + " returned false.");
            }
        }
        catch (JRockitConnectionException e) {
            IOException ioe = new IOException("An RMP problem occured when invoking operation " + this.setEnableOperationName + " with RMP subscription command " + aspectData);
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void stopSubscription(Object operationTarget) throws IOException {
        String aspectData = this.getAspectData(operationTarget);
        try {
            if (!this.rmpConnector.sendUnsubscribe(aspectData)) {
                throw new IOException("Disabling an RMP subscription by invoking the operation " + this.setEnableOperationName + " with command " + aspectData + " returned false.");
            }
            this.operationTargetToSubscriptionIDMap.remove(operationTarget);
        }
        catch (JRockitConnectionException e) {
            IOException ioe = new IOException("An RMP problem occured when invoking operation " + this.setEnableOperationName + " with RMP subscription command " + aspectData);
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected String getSubscriptionCommand() {
        return this.subscriptionCommand;
    }

    protected abstract String getAspectData(Object var1);

    protected abstract String buildArgumentString(Object var1);

    public MBeanOperationInfo[] getOperationInfos() {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[3];
        MBeanParameterInfo[] parameterInfo = new MBeanParameterInfo[2];
        parameterInfo[0] = new MBeanParameterInfo("operationTarget", this.operationTargetType, "The entity to monitor.");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        parameterInfo[1] = new MBeanParameterInfo("Enable flag", clazz.getName(), "Whether to enable or disable monitoring.");
        infos[0] = new MBeanOperationInfo(this.setEnableOperationName, "Enables or disables monitoring.", parameterInfo, Void.TYPE.getName(), 1);
        parameterInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("operationTarget", this.operationTargetType, "The entity to monitor.")};
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        infos[1] = new MBeanOperationInfo(this.isOperationName, "Returns whether monitoring is enabled.", parameterInfo, clazz2.getName(), 0);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        infos[2] = new MBeanOperationInfo(this.getOperationName, "Returns the value of the monitored property.", parameterInfo, clazz3.getName(), 0);
        return infos;
    }

    class LongValueSubscriptionListener
    implements RmpPushHandler {
        private HashMap values = new HashMap();

        LongValueSubscriptionListener() {
        }

        public void dispatch(long subscriptionID, long timestamp, String aspectRmpName, String aspectValue) {
            Long id = new Long(subscriptionID);
            this.setValue(id, aspectValue);
        }

        public synchronized void clearID(Long subscriptionID) {
            this.values.remove(subscriptionID);
        }

        public synchronized long getValue(Long subscriptionID) {
            Long value = null;
            while ((value = (Long)this.values.get(subscriptionID)) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return value;
        }

        public synchronized void setValue(Long subscriptionID, String aspectValue) {
            this.values.put(subscriptionID, new Long(aspectValue));
            this.notifyAll();
        }
    }
}

