/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.console.connection.ConnectorModel;
import com.jrockit.console.connection.RmpErrorHandler;
import com.jrockit.console.connection.RmpPushHandler;
import java.util.ArrayList;
import java.util.Iterator;

public class SubscribableRMPConnector
extends ConnectorModel {
    private ArrayList subscriptionListeners = new ArrayList();
    private ArrayList errorHandlers = new ArrayList();
    RmpPushHandler subscriptionDispatcher = new RmpPushHandler(){

        public void dispatch(long subscriptionID, long timestamp, String aspectRmpName, String aspectValue) {
            Iterator iter = SubscribableRMPConnector.this.subscriptionListeners.iterator();
            while (iter.hasNext()) {
                ((RmpPushHandler)iter.next()).dispatch(subscriptionID, timestamp, aspectRmpName, aspectValue);
            }
        }
    };

    public void handleRmpException(Exception e) {
        Iterator iter = this.errorHandlers.iterator();
        while (iter.hasNext()) {
            ((RmpErrorHandler)iter.next()).handleRmpException(e);
        }
    }

    public void handleSystemMessage(String message) {
        Iterator iter = this.errorHandlers.iterator();
        while (iter.hasNext()) {
            ((RmpErrorHandler)iter.next()).handleSystemMessage(message);
        }
    }

    public SubscribableRMPConnector(String host, int port) {
        super(host, port);
    }

    public RmpPushHandler getRmpPushHandler() {
        return this.subscriptionDispatcher;
    }

    public void registerSubscriptionListener(RmpPushHandler subscriptionListener) {
        this.subscriptionListeners.add(subscriptionListener);
    }

    public void unregisterSubscriptionListener(RmpPushHandler subscriptionListener) {
        this.subscriptionListeners.remove(subscriptionListener);
    }

    public void registerErrorHandler(RmpErrorHandler errorHandler) {
        this.errorHandlers.add(errorHandler);
    }

    public void unregisterErrorHandler(RmpErrorHandler errorHandler) {
        this.errorHandlers.remove(errorHandler);
    }
}

