/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.console.rmp.RMPBean;
import com.jrockit.console.rmp.SubscribableRMPConnector;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidApplicationException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class RMPBeanServerConnection
implements MBeanServerConnection {
    public static final String RMP_BEAN_CANONICAL_NAME = "com.jrockit:type=RMPBean";
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rmp");
    private ObjectName rmpBeanName;
    private RMPBean rmpBean;
    static /* synthetic */ Class class$0;

    public RMPBeanServerConnection(SubscribableRMPConnector rmpConnector) {
        try {
            this.rmpBeanName = new ObjectName(RMP_BEAN_CANONICAL_NAME);
            this.rmpBean = new RMPBean(rmpConnector, this.rmpBeanName);
        }
        catch (MalformedObjectNameException e) {
            RuntimeException re = new RuntimeException("Object name construction failed! (should never occur)");
            re.initCause(e);
            throw re;
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        if (name.equals(this.rmpBeanName)) {
            try {
                return this.rmpBean.getAttribute(attribute);
            }
            catch (RuntimeException e) {
                throw new MBeanException(e, e.getMessage());
            }
        }
        throw new InstanceNotFoundException("Could not find ObjectName: " + name);
    }

    public AttributeList getAttributes(ObjectName beanName, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        if (beanName.equals(this.rmpBeanName)) {
            try {
                try {
                    return this.rmpBean.getAttributes(attributes);
                }
                catch (RuntimeException e) {
                    throw new MBeanException(e, e.getMessage());
                }
            }
            catch (AttributeNotFoundException e) {
                throw new ReflectionException(e);
            }
            catch (MBeanException e) {
                throw new ReflectionException(e);
            }
        }
        throw new InstanceNotFoundException("Could not find ObjectName: " + beanName);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (name.equals(this.rmpBeanName)) {
            try {
                this.rmpBean.setAttribute(attribute);
            }
            catch (RuntimeException e) {
                throw new MBeanException(e, e.getMessage());
            }
        } else {
            throw new InstanceNotFoundException("Could not find ObjectName: " + name);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if (name.equals(this.rmpBeanName)) {
            try {
                return this.rmpBean.invoke(operationName, params, signature);
            }
            catch (RuntimeException e) {
                throw new MBeanException(e, e.getMessage());
            }
        }
        throw new InstanceNotFoundException("Could not find ObjectName: " + name);
    }

    public String[] getDomains() throws IOException {
        String[] domains = new String[]{this.rmpBeanName.getDomain()};
        return domains;
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        if (name.equals(this.rmpBeanName)) {
            try {
                try {
                    return this.rmpBean.setAttributes(attributes);
                }
                catch (RuntimeException e) {
                    throw new MBeanException(e, e.getMessage());
                }
            }
            catch (MBeanException e) {
                throw new ReflectionException(e);
            }
        }
        throw new InstanceNotFoundException("Could not find ObjectName: " + name);
    }

    public String getDefaultDomain() throws IOException {
        return this.rmpBeanName.getDomain();
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        return name.equals(this.rmpBeanName);
    }

    public Integer getMBeanCount() throws IOException {
        return new Integer(1);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        if (name.equals(this.rmpBeanName)) {
            return this.rmpBean.getMBeanInfo();
        }
        throw new InstanceNotFoundException("Could not find MBean with name " + name);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        if (name.equals(this.rmpBeanName)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jrockit.console.rmp.RMPBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return className.equals(clazz.getName());
        }
        throw new InstanceNotFoundException("ObjectName " + name.getCanonicalName() + " is not supported by this MBeanServerConnection.");
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        if (name.equals(this.rmpBeanName)) {
            return new ObjectInstance(name, this.rmpBean.getClass().getName());
        }
        throw new InstanceNotFoundException("Could not find MBean with name " + name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
        HashSet<RMPBean> set = new HashSet<RMPBean>();
        if (this.queryNames(name, query).contains(this.rmpBeanName)) {
            set.add(this.rmpBean);
        }
        return set;
    }

    public Set queryNames(ObjectName name, QueryExp query) throws IOException {
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        if (name == null || name.getDomain() == null && name.getKeyPropertyList().size() == 0 || name.apply(this.rmpBeanName)) {
            try {
                if (query == null || query.apply(this.rmpBeanName)) {
                    set.add(this.rmpBeanName);
                }
            }
            catch (BadStringOperationException badStringOperationException) {
            }
            catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            }
            catch (BadAttributeValueExpException badAttributeValueExpException) {
            }
            catch (InvalidApplicationException invalidApplicationException) {
                // empty catch block
            }
        }
        return set;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        System.err.println("WARNING: Adding notifications not implemented on RMP connector.");
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        throw new UnsupportedOperationException("Not implemented on RMP connector.");
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        System.err.println("WARNING: Removing notification listener not implemented.");
    }
}

