/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.console.rmp.ClassProxyOperations;
import com.jrockit.console.rmp.CtrlBreakOperation;
import com.jrockit.console.rmp.DivisionRMPAttribute;
import com.jrockit.console.rmp.ExceptionCountOperations;
import com.jrockit.console.rmp.InvocationCountOperations;
import com.jrockit.console.rmp.JRAOperations;
import com.jrockit.console.rmp.MappedRMPAttribute;
import com.jrockit.console.rmp.MemleakOperations;
import com.jrockit.console.rmp.RMPAttribute;
import com.jrockit.console.rmp.RMPOperation;
import com.jrockit.console.rmp.SubscribableRMPConnector;
import com.jrockit.console.rmp.SubtractionRMPAttribute;
import com.jrockit.console.rmp.TimingOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class RMPBean {
    private SubscribableRMPConnector rmpConnector;
    private HashMap attributeMap;
    private HashMap operationMap;
    private ArrayList rmpOperations;
    private MBeanInfo beanInfo;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public RMPBean(SubscribableRMPConnector connector, ObjectName beanName) {
        this.rmpConnector = connector;
        this.attributeMap = new HashMap();
        this.populateAttributeMap();
        this.populateOperationList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.console.rmp.RMPBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.beanInfo = new MBeanInfo(clazz.getName(), "Bean for RMP operations", this.getAttributeInfos(), new MBeanConstructorInfo[0], this.getOperationInfos(), new MBeanNotificationInfo[0]);
    }

    public Object getAttribute(String arg0) throws AttributeNotFoundException, MBeanException, ReflectionException {
        RMPAttribute attribute = (RMPAttribute)this.attributeMap.get(arg0);
        if (attribute != null) {
            try {
                return attribute.getValue();
            }
            catch (IOException e) {
                throw new MBeanException(e, e.getMessage());
            }
        }
        throw new AttributeNotFoundException("Could not find attribute " + attribute);
    }

    public void setAttribute(Attribute arg0) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        RMPAttribute attribute = (RMPAttribute)this.attributeMap.get(arg0.getName());
        if (attribute != null && attribute.getInfo().isWritable()) {
            try {
                attribute.setValue(arg0.getValue());
            }
            catch (IOException e) {
                throw new MBeanException(e, e.getMessage());
            }
        } else {
            throw new AttributeNotFoundException("Could not find or access attribute " + arg0.getName());
        }
    }

    public AttributeList getAttributes(String[] arg0) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeList list = new AttributeList();
        int i = 0;
        while (i < arg0.length) {
            Attribute attr = new Attribute(arg0[i], this.getAttribute(arg0[i]));
            list.add(attr);
            ++i;
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList arg0) {
        AttributeList successfullySetAttributes = new AttributeList();
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                successfullySetAttributes.add(attr);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
            }
            catch (MBeanException mBeanException) {
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return successfullySetAttributes;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        RMPOperation operation = (RMPOperation)this.operationMap.get(operationName);
        if (operation != null) {
            try {
                return operation.performRMPOperation(operationName, params);
            }
            catch (IOException e) {
                throw new MBeanException(e, e.getMessage());
            }
        }
        throw new MBeanException(new NoSuchMethodException("Unable to invoke method " + operationName), "Unable to invoke method " + operationName);
    }

    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    private MBeanOperationInfo[] getOperationInfos() {
        ArrayList<MBeanOperationInfo> operationInfoList = new ArrayList<MBeanOperationInfo>();
        Iterator iter = this.rmpOperations.iterator();
        while (iter.hasNext()) {
            RMPOperation op = (RMPOperation)iter.next();
            operationInfoList.addAll(Arrays.asList(op.getOperationInfos()));
        }
        return operationInfoList.toArray(new MBeanOperationInfo[operationInfoList.size()]);
    }

    private MBeanAttributeInfo[] getAttributeInfos() {
        ArrayList<MBeanAttributeInfo> infos = new ArrayList<MBeanAttributeInfo>();
        Iterator iter = this.attributeMap.values().iterator();
        while (iter.hasNext()) {
            infos.add(((RMPAttribute)iter.next()).getInfo());
        }
        return infos.toArray(new MBeanAttributeInfo[infos.size()]);
    }

    private void populateOperationList() {
        this.rmpOperations = new ArrayList();
        this.rmpOperations.add(new InvocationCountOperations(this.rmpConnector));
        this.rmpOperations.add(new ExceptionCountOperations(this.rmpConnector));
        this.rmpOperations.add(new TimingOperations(this.rmpConnector));
        this.rmpOperations.add(new MemleakOperations(this.rmpConnector));
        this.rmpOperations.add(new JRAOperations(this.rmpConnector));
        this.rmpOperations.add(new ClassProxyOperations(this.rmpConnector));
        this.rmpOperations.add(new CtrlBreakOperation(this.rmpConnector));
        this.operationMap = new HashMap();
        int i = 0;
        while (i < this.rmpOperations.size()) {
            MBeanOperationInfo[] operationInfos = ((RMPOperation)this.rmpOperations.get(i)).getOperationInfos();
            int j = 0;
            while (j < operationInfos.length) {
                this.operationMap.put(operationInfos[j].getName(), this.rmpOperations.get(i));
                ++j;
            }
            ++i;
        }
    }

    private void populateAttributeMap() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("ExitOnOutOfMemory", clazz.getName(), "IEOO", "EXOO");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("HeapSizeLocked", clazz2.getName(), "MILH", "MELH");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("UsedPhysicalMemory", clazz3.getName(), "MEUP", null);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("FreePhysicalMemory", clazz4.getName(), "MEFP", null);
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("TotalPhysicalMemory", clazz5.getName(), "METP", null);
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("AvailableProcessors", clazz6.getName(), "#CPU", null);
        Class<?> clazz7 = class$3;
        if (clazz7 == null) {
            try {
                clazz7 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("CPULoad", clazz7.getName(), "CPLD", null);
        Class<?> clazz8 = class$2;
        if (clazz8 == null) {
            try {
                clazz8 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("SetNurserySize", clazz8.getName(), null, "MESN");
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("CPUAffinity", clazz9.getName(), "AFFI", "SAFF");
        Class<?> clazz10 = class$5;
        if (clazz10 == null) {
            try {
                clazz10 = class$5 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("ThreadStackDump", clazz10.getName(), "VMSD", null);
        Class<?> clazz11 = class$2;
        if (clazz11 == null) {
            try {
                clazz11 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("TotalHeapMemory", clazz11.getName(), "METH", "MESH");
        Class<?> clazz12 = class$2;
        if (clazz12 == null) {
            try {
                clazz12 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("UsedHeapMemory", clazz12.getName(), "MEUH", null);
        Class<?> clazz13 = class$2;
        if (clazz13 == null) {
            try {
                clazz13 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("FreeHeapMemory", clazz13.getName(), "MEFH", null);
        Class<?> clazz14 = class$2;
        if (clazz14 == null) {
            try {
                clazz14 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("CurrentTime", clazz14.getName(), "CRTM", null);
        Class<?> clazz15 = class$3;
        if (clazz15 == null) {
            try {
                clazz15 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("VMGeneratedCPULoad", clazz15.getName(), "VMCP", null);
        Class<?> clazz16 = class$5;
        if (clazz16 == null) {
            try {
                clazz16 = class$5 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("GarbageCollectorStrategy", clazz16.getName(), "GCSY", "SGCC");
        Class<?> clazz17 = class$2;
        if (clazz17 == null) {
            try {
                clazz17 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("StartTime", clazz17.getName(), "STIM", null);
        Class<?> clazz18 = class$2;
        if (clazz18 == null) {
            try {
                clazz18 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("NurserySize", clazz18.getName(), "METN", null);
        Class<?> clazz19 = class$2;
        if (clazz19 == null) {
            try {
                clazz19 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("ThreadCount", clazz19.getName(), "TH#T", null);
        Class<?> clazz20 = class$2;
        if (clazz20 == null) {
            try {
                clazz20 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("RunningNonDaemonThreads", clazz20.getName(), "TH#N", null);
        Class<?> clazz21 = class$6;
        if (clazz21 == null) {
            try {
                clazz21 = class$6 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("MLSPort", clazz21.getName(), "MPOR", null);
        Class<?> clazz22 = class$7;
        if (clazz22 == null) {
            try {
                clazz22 = class$7 = Class.forName("javax.management.openmbean.TabularData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToAttributeMap("SystemProperties", clazz22.getName(), "SYSP", null);
        Class<?> clazz23 = class$2;
        if (clazz23 == null) {
            try {
                clazz23 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.attributeMap.put("Uptime", new SubtractionRMPAttribute(this.rmpConnector, "Uptime", clazz23.getName(), "CRTM", "STIM"));
        Class<?> clazz24 = class$8;
        if (clazz24 == null) {
            try {
                clazz24 = class$8 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.attributeMap.put("HeapMemoryUsagePercent", new DivisionRMPAttribute(this.rmpConnector, "HeapMemoryUsagePercent", clazz24.getName(), "MEUH", "METH"));
        Class<?> clazz25 = class$8;
        if (clazz25 == null) {
            try {
                clazz25 = class$8 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.attributeMap.put("PhysicalMemoryUsagePercent", new DivisionRMPAttribute(this.rmpConnector, "PhysicalMemoryUsagePercent", clazz25.getName(), "MEUP", "METP"));
    }

    private void addToAttributeMap(String attributeName, String type, String getter, String setter) {
        this.attributeMap.put(attributeName, new MappedRMPAttribute(this.rmpConnector, attributeName, type, getter, setter));
    }
}

