/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.console.connection.ConnectorModel;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.rmp.RMPOperation;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MemleakOperations
implements RMPOperation {
    private static final String OPERATION_START = "startMLS";
    private static final String OPERATION_STOP = "shutDownMLS";
    private static final String ATTRIBUTE_VERSIONS = "MLSVersions";
    private static final int INFO_START = 0;
    private static final int INFO_STOP = 1;
    private static final int INFO_VERSIONS = 2;
    private ConnectorModel rmpConnector;
    private MBeanOperationInfo[] infos;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public MemleakOperations(ConnectorModel connector) {
        this.rmpConnector = connector;
        MBeanParameterInfo[] startParameters = new MBeanParameterInfo[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[0] = new MBeanParameterInfo("requiredProtocol", clazz.getName(), "Required protocol version.");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[1] = new MBeanParameterInfo("port", clazz2.getName(), "Desired TCP port number for MLS.");
        this.infos = new MBeanOperationInfo[3];
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.infos[0] = new MBeanOperationInfo(OPERATION_START, "Starts MLS.", startParameters, clazz3.getName(), 1);
        this.infos[1] = new MBeanOperationInfo(OPERATION_STOP, "Stops MLS.", new MBeanParameterInfo[0], Boolean.TYPE.getName(), 1);
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.infos[2] = new MBeanOperationInfo(ATTRIBUTE_VERSIONS, "Stops MLS.", mBeanParameterInfoArray, clazz4.getName(), 1);
    }

    public Object performRMPOperation(String operationName, Object[] params) throws IOException, MBeanException {
        try {
            if (operationName.equals(OPERATION_START)) {
                String arguments = params[0] + "#" + params[1];
                String portString = this.rmpConnector.sendQuery("SMEM" + arguments);
                MemleakOperations.checkForLegacyException(portString);
                return Integer.valueOf(portString);
            }
            if (operationName.equals(OPERATION_STOP)) {
                return this.rmpConnector.sendCommand("EMEM", null);
            }
            if (operationName.equals(ATTRIBUTE_VERSIONS)) {
                String verString = this.rmpConnector.sendQuery("MVER");
                return verString != null ? this.parseCSV(verString) : new int[]{};
            }
            throw new MBeanException(new Exception("This RMPOperation object does not support the operation name " + operationName));
        }
        catch (NumberFormatException e) {
            throw new MBeanException(new Exception("RMPOperation " + operationName + " returned an unexpected non-numerical value."));
        }
        catch (JRockitServerException e) {
            throw new MBeanException(e);
        }
        catch (JRockitConnectionException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void checkForLegacyException(String response) throws MBeanException {
        Exception cause;
        String illegalName;
        if (response == null || !response.startsWith("class ")) {
            return;
        }
        int colonPos = response.indexOf(58);
        if (colonPos < 0) {
            return;
        }
        String exName = response.substring(6, colonPos);
        String msg = response.substring(colonPos + 1);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.IllegalAccessException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (exName.equals(illegalName = clazz.getName())) {
            cause = new IllegalAccessException(msg);
        } else {
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("java.lang.RuntimeException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cause = exName.equals(clazz2.getName()) && msg.startsWith(illegalName) ? new IllegalAccessException(msg.substring(illegalName.length() + 2)) : new Exception(msg);
        }
        throw new MBeanException(cause);
    }

    private int[] parseCSV(String commaSepVersions) throws MBeanException {
        StringTokenizer st = new StringTokenizer(commaSepVersions, "{,}");
        int[] portArray = new int[st.countTokens()];
        int i = 0;
        try {
            while (st.hasMoreElements()) {
                portArray[i++] = Integer.parseInt(st.nextToken());
            }
        }
        catch (NumberFormatException nfe) {
            throw new MBeanException(nfe);
        }
        return portArray;
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return this.infos;
    }
}

