/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.util.GarbageCollectorChangeEventWrapper;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.common.util.ReflectionToolkit;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.rmp.CoreDataParser;
import com.jrockit.console.rmp.RMPAttribute;
import com.jrockit.console.rmp.RMPBeanServerConnection;
import com.jrockit.console.rmp.SubscribableRMPConnector;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;

public class MappedRMPAttribute
implements RMPAttribute {
    private static HashMap typeNameToParserMap = new HashMap();
    private SubscribableRMPConnector rmpConnection;
    private String attributeName;
    private String typeName;
    private String rmpQuery;
    private String rmpCommand;

    static {
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.BOOLEAN_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.LONG_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.INTEGER_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.DOUBLE_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.STRING_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.BITMASK_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.GARBAGE_COLLECTION_CHANGE_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.LONG_PAIR_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.METHOD_IDENTIFIERS_PARSER);
        MappedRMPAttribute.mapParsedTypeToParser(CoreDataParser.TABULAR_DATA_PARSER);
    }

    protected MappedRMPAttribute(SubscribableRMPConnector connector, String attributeName, String type, String getterQuery, String setterCommand) {
        this.attributeName = attributeName;
        this.rmpConnection = connector;
        this.typeName = type;
        this.rmpQuery = getterQuery;
        this.rmpCommand = setterCommand;
    }

    public String getName() {
        return this.attributeName;
    }

    public boolean isReadable() {
        return this.rmpQuery != null;
    }

    public boolean isWritable() {
        return this.rmpCommand != null;
    }

    public Object getValue() throws IOException, MBeanException {
        if (this.isReadable()) {
            try {
                return MappedRMPAttribute.convertToAttributeValue(this.rmpConnection.sendQuery(this.rmpQuery), this.getTypeName());
            }
            catch (JRockitServerException e) {
                throw new MBeanException(e);
            }
            catch (JRockitConnectionException e) {
                IOException ioe = new IOException("A problem occured when getting the value for attribute " + this.getName());
                ioe.initCause(e);
                throw ioe;
            }
        }
        throw new UnsupportedOperationException("Attribute " + this.getName() + " is not readable.");
    }

    public void setValue(Object o) throws IOException, MBeanException {
        if (this.isWritable()) {
            try {
                this.rmpConnection.sendCommand(this.rmpCommand, this.convertAttributeValueToString(o));
            }
            catch (JRockitServerException e) {
                throw new MBeanException(e);
            }
            catch (JRockitConnectionException e) {
                IOException ioe = new IOException("A problem occured when setting the value for attribute " + this.getName());
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            throw new UnsupportedOperationException("Attribute " + this.getName() + " is not writable.");
        }
    }

    private static void mapParsedTypeToParser(CoreDataParser parser) {
        typeNameToParserMap.put(parser.getDataClass().getName(), parser);
    }

    protected static Object convertToAttributeValue(String string, String typeName) {
        CoreDataParser parser = (CoreDataParser)typeNameToParserMap.get(typeName);
        if (parser == null) {
            RMPBeanServerConnection.getLogger().log(Level.SEVERE, "Could not find parser for type: " + typeName);
            return null;
        }
        Object o = parser.parse(string);
        if (!parser.getDataClass().isAssignableFrom(o.getClass())) {
            RMPBeanServerConnection.getLogger().log(Level.SEVERE, " value mismatch " + o + " type " + typeName);
        }
        return o;
    }

    protected String convertAttributeValueToString(Object value) {
        if (this.getTypeName().equals(CoreDataParser.BITMASK_PARSER.getDataClass().getName())) {
            return MappedRMPAttribute.convertToBitmask(value);
        }
        if (this.getTypeName().equals(CoreDataParser.LONG_PAIR_PARSER.getDataClass().getName())) {
            Object[] longPair = (Object[])value;
            return String.valueOf(longPair[0].toString()) + " " + longPair[1];
        }
        if (this.getTypeName().equals(CoreDataParser.GARBAGE_COLLECTION_CHANGE_PARSER.getDataClass().getName())) {
            return ((GarbageCollectorChangeEventWrapper)value).exportToString();
        }
        if (this.getTypeName().equals(CoreDataParser.METHOD_IDENTIFIERS_PARSER.getDataClass().getName())) {
            return ReflectionToolkit.encodeArrayToString((MethodIdentifier[])((MethodIdentifier[])value));
        }
        return value.toString();
    }

    protected SubscribableRMPConnector getRMPConnector() {
        return this.rmpConnection;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public MBeanAttributeInfo getInfo() {
        return new MBeanAttributeInfo(this.getName(), this.getTypeName(), "RMP attribute", this.isReadable(), this.isWritable(), false);
    }

    static String convertToBitmask(Object obj) {
        if (!(obj instanceof int[])) {
            return null;
        }
        int[] bitmask = (int[])obj;
        StringBuffer buf = new StringBuffer(bitmask.length << 5);
        int lastOne = 0;
        int i = 0;
        while (i < bitmask.length) {
            int j = 0;
            while (j < 32) {
                if (MappedRMPAttribute.testBit(j, bitmask[i])) {
                    buf.append('1');
                    lastOne = buf.length();
                } else {
                    buf.append('0');
                }
                ++j;
            }
            ++i;
        }
        return buf.substring(0, lastOne);
    }

    static boolean testBit(int bitPos, int i) {
        return (1 << bitPos & i) != 0;
    }
}

