/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.console.connection.ConnectorModel;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.rmp.RMPOperation;
import java.io.IOException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class JRAOperations
implements RMPOperation {
    private static final int START_JRA_RECORDING = 0;
    private static final int STOP_JRA_RECORDING = 1;
    private ConnectorModel rmpConnector;
    private MBeanOperationInfo[] infos;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public JRAOperations(ConnectorModel connector) {
        this.rmpConnector = connector;
        MBeanParameterInfo[] startParameters = new MBeanParameterInfo[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[0] = new MBeanParameterInfo("recordingTime", clazz.getName(), "How long time to record JRA data.");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[1] = new MBeanParameterInfo("fileName", clazz2.getName(), "The name of the JRA data file.");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[2] = new MBeanParameterInfo("useMethodSamples", clazz3.getName(), "Whether to perform method sampling and include the samples in the recording.");
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[3] = new MBeanParameterInfo("useGCSamples", clazz4.getName(), "Whether to perform GC sampling and include the samples in the recording.");
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        startParameters[4] = new MBeanParameterInfo("useNativeSamples", clazz5.getName(), "Whether to include samples from threads executing native code.");
        this.infos = new MBeanOperationInfo[2];
        this.infos[0] = new MBeanOperationInfo("startJRARecording", "Starts a JRA recording and returns a boolean specifying whether it was started.", startParameters, Boolean.TYPE.getName(), 1);
        this.infos[1] = new MBeanOperationInfo("stopJRARecording", "Stops a running JRA recording and returns a boolean specifying whether it was ended.", new MBeanParameterInfo[0], Boolean.TYPE.getName(), 1);
    }

    public Object performRMPOperation(String operationName, Object[] params) throws IOException, MBeanException {
        if (operationName.equals(this.infos[0].getName())) {
            if (params.length == 5) {
                String arguments = String.valueOf(((Integer)params[0]).toString()) + "#" + (String)params[1];
                int i = 2;
                while (i < params.length) {
                    arguments = String.valueOf(arguments) + "#" + Boolean.toString((Boolean)params[i] == false);
                    ++i;
                }
                try {
                    return new Boolean(this.rmpConnector.sendCommand("SJRA", arguments));
                }
                catch (JRockitServerException e) {
                    throw new MBeanException(e);
                }
                catch (JRockitConnectionException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            throw new MBeanException(new Exception("Expected five parameters to operation " + operationName + ", got " + params.length));
        }
        if (operationName.equals(this.infos[1].getName())) {
            try {
                return new Boolean(this.rmpConnector.sendCommand("EJRA", ""));
            }
            catch (JRockitServerException e) {
                throw new MBeanException(e);
            }
            catch (JRockitConnectionException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        throw new MBeanException(new Exception("This RMPOperation object does not support the operation name " + operationName));
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return this.infos;
    }
}

