/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.console.connection.RmpErrorHandler;
import com.jrockit.console.rmp.RMPBeanServerConnection;
import com.jrockit.console.rmp.SubscribableRMPConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.security.auth.Subject;

public class JMXOverRMPConnector
implements JMXConnector {
    private SubscribableRMPConnector rmpConnector;
    private RMPBeanServerConnection beanServerConnection;
    private ArrayList notificationListeners;
    private long notificationSequenceNumber;
    private String connectionId;
    private RmpErrorHandler rmpErrorHandler = new InternalRMPErrorHandler();

    protected JMXOverRMPConnector(String host, int port) {
        this.rmpConnector = new SubscribableRMPConnector(host, port);
        this.rmpConnector.registerErrorHandler(this.rmpErrorHandler);
        this.beanServerConnection = new RMPBeanServerConnection(this.rmpConnector);
        this.notificationListeners = new ArrayList();
        this.connectionId = "rmp://" + this.rmpConnector.getCompactName();
    }

    public void connect() throws IOException {
        this.connect((Map)null);
    }

    public void connect(Map arg0) throws IOException {
        try {
            this.rmpConnector.connect();
            this.fireNotification(new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.notificationSequenceNumber++, "The connection was opened.", null));
        }
        catch (JRockitConnectionException e) {
            IOException ioe = new IOException("Problem connecting to RMP server.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    public MBeanServerConnection getMBeanServerConnection(Subject arg0) throws IOException {
        return this.beanServerConnection;
    }

    public void close() throws IOException {
        this.rmpConnector.disconnect();
        this.fireNotification(new JMXConnectionNotification("jmx.remote.connection.closed", this, this.connectionId, this.notificationSequenceNumber++, "The connection was closed normally.", null));
    }

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationListeners.add(new ListenerComposite(listener, filter, handback));
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        boolean found = false;
        Iterator iter = this.notificationListeners.iterator();
        while (iter.hasNext()) {
            NotificationListener l = ((ListenerComposite)iter.next()).getListener();
            if (l != notificationListener) continue;
            found = true;
            iter.remove();
        }
        if (!found) {
            throw new ListenerNotFoundException("Could not find and remove a notification listener.");
        }
    }

    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (!this.notificationListeners.remove(new ListenerComposite(listener, filter, handback))) {
            throw new ListenerNotFoundException("Could not find and remove a listener with the specified filter and handback object.");
        }
    }

    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    private void fireNotification(JMXConnectionNotification notification) {
        Iterator iter = this.notificationListeners.iterator();
        while (iter.hasNext()) {
            ListenerComposite composite = (ListenerComposite)iter.next();
            if (composite.getFilter() != null && !composite.getFilter().isNotificationEnabled(notification)) continue;
            composite.getListener().handleNotification(notification, composite.getHandback());
        }
    }

    class InternalRMPErrorHandler
    implements RmpErrorHandler {
        InternalRMPErrorHandler() {
        }

        public void handleRmpException(Exception exception) {
            if (JMXOverRMPConnector.this.rmpConnector.isConnectionLost()) {
                String string = JMXOverRMPConnector.this.connectionId;
                JMXOverRMPConnector jMXOverRMPConnector = JMXOverRMPConnector.this;
                long l = jMXOverRMPConnector.notificationSequenceNumber;
                jMXOverRMPConnector.notificationSequenceNumber = l + 1L;
                JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.failed", this, string, l, "An RMP exception occured.", exception);
                JMXOverRMPConnector.this.fireNotification(notification);
            }
        }

        public void handleSystemMessage(String message) {
            String string = JMXOverRMPConnector.this.connectionId;
            JMXOverRMPConnector jMXOverRMPConnector = JMXOverRMPConnector.this;
            long l = jMXOverRMPConnector.notificationSequenceNumber;
            jMXOverRMPConnector.notificationSequenceNumber = l + 1L;
            JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.failed", this, string, l, "Connection was closed.", message);
            JMXOverRMPConnector.this.fireNotification(notification);
        }
    }

    static class ListenerComposite {
        private NotificationListener listener;
        private NotificationFilter filter;
        private Object handback;

        public ListenerComposite(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public boolean equals(Object o) {
            if (o instanceof ListenerComposite) {
                ListenerComposite c = (ListenerComposite)o;
                return this.listener == c.listener && this.filter == c.filter && this.handback == c.handback;
            }
            return false;
        }

        public NotificationListener getListener() {
            return this.listener;
        }

        public NotificationFilter getFilter() {
            return this.filter;
        }

        public Object getHandback() {
            return this.handback;
        }
    }
}

