/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.util.DebugPrinter;
import com.jrockit.common.util.GarbageCollectorChangeEventWrapper;
import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.common.util.ReflectionToolkit;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public interface CoreDataParser {
    public static final String DEFAULT_PARAM_DELIMITER = " ";
    public static final CoreDataParser BOOLEAN_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            String lowerCaseData = coreData.toLowerCase();
            if (lowerCaseData.equals("true")) {
                return new Boolean(true);
            }
            if (lowerCaseData.equals("false")) {
                return new Boolean(false);
            }
            throw new IllegalCoreDataException("Error parsing data '" + coreData + "': must be either 'true' or 'false'");
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser LONG_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            try {
                return new Long(coreData);
            }
            catch (NumberFormatException e) {
                throw new IllegalCoreDataException("Error parsing data '" + coreData + "': " + e.toString());
            }
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser INTEGER_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            try {
                return new Integer(coreData);
            }
            catch (NumberFormatException e) {
                throw new IllegalCoreDataException("Error parsing data '" + coreData + "': " + e.toString());
            }
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser BITMASK_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            return this.decodeStringToBitMask(coreData);
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }

        public int[] decodeStringToBitMask(String data) {
            int[] resultArray = new int[data.length() + 31 >> 5];
            int i = 0;
            while (i < data.length()) {
                if (data.charAt(i) == '1') {
                    int n = i >> 5;
                    resultArray[n] = resultArray[n] | 1 << (i & 0x1F);
                }
                ++i;
            }
            return resultArray;
        }
    };
    public static final CoreDataParser DOUBLE_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            try {
                return new Double(coreData);
            }
            catch (NumberFormatException e) {
                throw new IllegalCoreDataException("Error parsing data '" + coreData + "': " + e.toString());
            }
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser GARBAGE_COLLECTION_CHANGE_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            return new GarbageCollectorChangeEventWrapper(coreData);
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.jrockit.common.util.GarbageCollectorChangeEventWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser STRING_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            return coreData;
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser LONG_PAIR_PARSER = new TupleParser(new CoreDataParser[]{LONG_PARSER, LONG_PARSER}, " ");
    public static final CoreDataParser METHOD_IDENTIFIERS_PARSER = new CoreDataParser(){

        public Object parse(String coreData) {
            MethodIdentifier[] methods;
            try {
                methods = ReflectionToolkit.decodeArrayFromString((String)coreData);
            }
            catch (MalformedDescriptorException e) {
                DebugPrinter.exception((Throwable)e);
                return new MethodIdentifier[0];
            }
            return methods;
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("[Lcom.jrockit.common.util.MethodIdentifier;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };
    public static final CoreDataParser TABULAR_DATA_PARSER = new CoreDataParser(){
        private String[] compositeKeys = new String[]{"key", "value"};
        private CompositeType compositeType = null;

        private CompositeType getCompositeType() throws OpenDataException {
            if (this.compositeType == null) {
                this.compositeType = new CompositeType("Properties row type", "Type specifying the rows in a properties table.", this.compositeKeys, new String[]{"The property keys.", "The property values."}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            }
            return this.compositeType;
        }

        public Object parse(String coreData) {
            try {
                ArrayList<CompositeDataSupport> compDatas = new ArrayList<CompositeDataSupport>();
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(coreData.getBytes("ISO-8859-1")));
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = props.getProperty(key);
                    compDatas.add(new CompositeDataSupport(this.getCompositeType(), this.compositeKeys, new String[]{key, value}));
                }
                TabularDataSupport tabData = new TabularDataSupport(new TabularType("Properties table", "A table of key-value properties", this.getCompositeType(), this.compositeKeys));
                tabData.putAll(compDatas.toArray(new CompositeData[compDatas.size()]));
                return tabData;
            }
            catch (Exception e) {
                throw new IllegalCoreDataException(e.getMessage());
            }
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("javax.management.openmbean.TabularData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    };

    public Object parse(String var1) throws IllegalCoreDataException, UnsupportedOperationException;

    public Class getDataClass();

    public static class IllegalCoreDataException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 3828262511892670110L;

        public IllegalCoreDataException(String s) {
            super(s);
        }
    }

    public static class TupleParser
    implements CoreDataParser {
        private CoreDataParser[] m_subParsers;
        private String m_delimiter;

        public TupleParser(CoreDataParser[] subParsers, String delimiter) {
            this.m_subParsers = subParsers;
            this.m_delimiter = delimiter;
        }

        public Object parse(String coreData) {
            Long[] array = new Long[this.m_subParsers.length];
            StringTokenizer tokenizer = new StringTokenizer(coreData, this.m_delimiter);
            int i = 0;
            while (i < array.length) {
                if (!tokenizer.hasMoreTokens()) {
                    throw new IllegalCoreDataException("Too few parameters, expected " + array.length + " but only found " + i + " in data: '" + coreData + "'");
                }
                String value = tokenizer.nextToken();
                array[i] = this.m_subParsers[i].parse(value);
                ++i;
            }
            if (tokenizer.hasMoreTokens()) {
                throw new IllegalCoreDataException("Too many parameters, expected only " + array.length + " in data: '" + coreData + "'");
            }
            return array;
        }

        public Class getDataClass() {
            Class<?> clazz;
            try {
                clazz = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
    }
}

