/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.ReflectionToolkit;
import com.jrockit.console.connection.ConnectorModel;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.rmp.RMPOperation;
import java.io.IOException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class ClassProxyOperations
implements RMPOperation {
    private static final int IS_THROWABLE_OPERATION = 0;
    private static final int GET_METHODS_OPERATION = 1;
    private ConnectorModel rmpConnector;
    private MBeanOperationInfo[] infos;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ClassProxyOperations(ConnectorModel connector) {
        this.rmpConnector = connector;
        MBeanParameterInfo[] stringParameterInfo = new MBeanParameterInfo[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringParameterInfo[0] = new MBeanParameterInfo("className", clazz.getName(), "A class to be introspected remotely.");
        this.infos = new MBeanOperationInfo[2];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.infos[0] = new MBeanOperationInfo("isThrowable", "Returns whether the specified string represents a class that is a descendent of java.lang.Throwable", stringParameterInfo, clazz2.getName(), 0);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("[Lcom.jrockit.common.util.MethodIdentifier;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.infos[1] = new MBeanOperationInfo("getMethods", "Returns the methods of the specified class name.", stringParameterInfo, clazz3.getName(), 0);
    }

    public Object performRMPOperation(String operationName, Object[] params) throws IOException, MBeanException {
        if (params.length != 1 || !(params[0] instanceof String)) {
            throw new MBeanException(new IllegalArgumentException("Operation parameter must be a single string."));
        }
        String className = (String)params[0];
        if (operationName.equals(this.infos[0].getName())) {
            try {
                return this.performIsThrowable(className);
            }
            catch (JRockitConnectionException e) {
                throw new MBeanException((Exception)((Object)e));
            }
        }
        if (operationName.equals(this.infos[1].getName())) {
            try {
                return this.performGetMethods(className);
            }
            catch (JRockitConnectionException e) {
                throw new MBeanException((Exception)((Object)e));
            }
            catch (MalformedDescriptorException e) {
                throw new MBeanException((Exception)((Object)e));
            }
        }
        throw new MBeanException(new Exception("This RMPOperation object does not support the operation name " + operationName));
    }

    private Object performIsThrowable(String className) throws JRockitConnectionException, MBeanException {
        try {
            String result = this.rmpConnector.sendQuery("EXTH" + className);
            if ("".equals(result)) {
                throw new MBeanException(new ClassNotFoundException("Couldn't find the class " + className + " loaded at " + this.rmpConnector.getName()));
            }
            return new Boolean(result.equalsIgnoreCase("true"));
        }
        catch (JRockitServerException e) {
            throw new MBeanException(e);
        }
    }

    private Object performGetMethods(String className) throws JRockitConnectionException, MBeanException, MalformedDescriptorException {
        try {
            String result = this.rmpConnector.sendQuery("RRCL" + className);
            if ("".equals(result)) {
                throw new MBeanException(new ClassNotFoundException("Couldn't find the class " + className + " loaded at " + this.rmpConnector.getName()));
            }
            int firstDelimiterIndex = result.indexOf("!");
            String classNamePart = result.substring(0, firstDelimiterIndex);
            String methodPart = result.substring(firstDelimiterIndex);
            if (!className.equals(classNamePart)) {
                throw new MBeanException(new Exception("Method introspection returned data for a different class name than the requested one."));
            }
            return ReflectionToolkit.decodeArrayFromString((String)methodPart);
        }
        catch (JRockitServerException e) {
            throw new MBeanException(e);
        }
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return this.infos;
    }
}

