/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.connection;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.DebugPrinter;
import com.jrockit.console.connection.RmpConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

class RmpReaderThread
implements Runnable {
    private RmpConnection m_connection;
    private InputStream m_in;
    private boolean m_isAlive = false;
    private boolean m_isStarted = false;
    private boolean m_exitSent;

    public RmpReaderThread(RmpConnection rmpConnection, Socket socket) throws IOException {
        this.m_connection = rmpConnection;
        this.m_in = socket.getInputStream();
        Thread t = new Thread((Runnable)this, "[JRockit] Connection Reader");
        t.setDaemon(true);
        t.start();
    }

    public void close() {
        this.setAlive(false);
    }

    public boolean isStarted() {
        return this.m_isStarted;
    }

    private boolean isAlive() {
        return this.m_isAlive;
    }

    private void setAlive(boolean aBoolean) {
        this.m_isAlive = aBoolean;
    }

    public void prepareToClose() {
        this.m_exitSent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        this.setAlive(true);
        var1_1 = this;
        synchronized (var1_1) {
            this.m_isStarted = true;
            this.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl28
        }
        do {
            try {
                rmpPacket = RmpPacket.readFromStream((InputStream)this.m_in);
                if (rmpPacket.getType() == 5) {
                    this.m_connection.handleSubscriptionUpdate(rmpPacket);
                    continue;
                }
                if (rmpPacket.getType() == 6) {
                    this.m_connection.handleSystemMessage(rmpPacket);
                    continue;
                }
                this.m_connection.handleIncomingReply(rmpPacket);
            }
            catch (InterruptedIOException rmpPacket) {
            }
            catch (JRockitConnectionException e) {
                this.setAlive(false);
                if (this.m_exitSent) continue;
                this.m_connection.handleConnectionException((Exception)e);
            }
lbl28:
            // 7 sources

        } while (this.isAlive());
        try {
            this.m_in.close();
        }
        catch (IOException e) {
            DebugPrinter.println((String)"Error while closing write connection:");
            DebugPrinter.exception((Throwable)e);
        }
        this.m_connection.closeSocket();
    }
}

