/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.connection;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.rmp.JRockitConnectionLostException;
import com.jrockit.common.rmp.JRockitConnectionRefusedException;
import com.jrockit.common.rmp.JRockitNotAnRmpServerException;
import com.jrockit.common.rmp.JRockitRmpPacketTimeOutException;
import com.jrockit.common.rmp.JRockitServerNotListeningException;
import com.jrockit.common.rmp.JRockitTooManyConnectionsException;
import com.jrockit.common.rmp.JRockitUnknownHostException;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.DebugPrinter;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.connection.RmpDispatcherThread;
import com.jrockit.console.connection.RmpErrorHandler;
import com.jrockit.console.connection.RmpPushHandler;
import com.jrockit.console.connection.RmpReaderThread;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RmpConnection {
    private Map m_incomingPackets = Collections.synchronizedMap(new HashMap());
    private long m_idCounter = 0L;
    private Socket m_socket;
    private OutputStream m_out;
    private final RmpReaderThread m_readerThread;
    private final RmpDispatcherThread m_dispatcherThread;
    private Exception m_error;
    private RmpErrorHandler m_errorHandler;
    private boolean m_alive;
    private boolean m_shutdownInitiated = false;
    private boolean m_handshaking;
    private int m_socketTimeout = Integer.parseInt(System.getProperty("com.jrockit.console.preferences.socket_timeout", "15000"));
    private int m_rmpReplyTimeout = Integer.parseInt(System.getProperty("com.jrockit.console.preferences.rmp_reply_timeout", "13000"));
    public static final int NO_UPDATE_TIME_AVAILABLE = Integer.MIN_VALUE;
    public static final long NO_TIMESTAMP_AVAILABLE = -1L;
    public static final String PROPERTY_SOCKET_TIMEOUT = "com.jrockit.console.preferences.socket_timeout";
    public static final String PROPERTY_RMP_REPLY_TIMEOUT = "com.jrockit.console.preferences.rmp_reply_timeout";
    public static final String DEFAULT_SOCKET_TIMEOUT = "15000";
    public static final String DEFAULT_RMP_REPLY_TIMEOUT = "13000";
    private long m_latestTimestamp = -1L;
    public static final RmpErrorHandler IGNORING_ERROR_HANDLER = new RmpErrorHandler(){

        public void handleRmpException(Exception e) {
            DebugPrinter.exception((Throwable)e);
        }

        public void handleSystemMessage(String message) {
            System.out.println("System Message: " + message);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RmpConnection(String serverName, int port, RmpPushHandler pushHandler, RmpErrorHandler errorHandler) throws JRockitConnectionRefusedException {
        DebugPrinter.println((String)("Socket timeout: " + this.m_socketTimeout));
        DebugPrinter.println((String)("RmpReply timeout: " + this.m_rmpReplyTimeout));
        this.m_errorHandler = errorHandler;
        this.m_dispatcherThread = new RmpDispatcherThread(pushHandler);
        try {
            this.m_socket = new Socket(serverName, port);
            this.m_socket.setSoTimeout(this.getSocketTimeout());
            this.m_socket.setTcpNoDelay(true);
            this.m_out = this.m_socket.getOutputStream();
            this.m_alive = true;
            this.m_readerThread = new RmpReaderThread(this, this.m_socket);
        }
        catch (UnknownHostException e) {
            this.m_dispatcherThread.close();
            throw new JRockitUnknownHostException(e);
        }
        catch (ConnectException e) {
            this.killConnection();
            throw new JRockitServerNotListeningException(serverName, port, (Exception)e);
        }
        catch (Exception e) {
            this.killConnection();
            throw new JRockitConnectionRefusedException("Can't create connection to JRockit on " + serverName + " at port " + port, e);
        }
        RmpReaderThread rmpReaderThread = this.m_readerThread;
        synchronized (rmpReaderThread) {
            while (!this.m_readerThread.isStarted()) {
                try {
                    this.m_readerThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.handshake();
    }

    private void handshake() throws JRockitConnectionRefusedException {
        this.m_handshaking = true;
        RmpPacket resultPacket = null;
        try {
            RmpPacket rmpPacket = new RmpPacket(1, this.getNextId(), "HELO");
            resultPacket = this.sendRmpWithReply(rmpPacket);
        }
        catch (JRockitRmpPacketTimeOutException e) {
            if ("HELO".equals(e.getCommand())) {
                this.throwRefusedException((JRockitConnectionRefusedException)new JRockitNotAnRmpServerException((Exception)((Object)e)));
            } else {
                this.throwRefusedException(new JRockitConnectionRefusedException("Handshaking with JRockit failed due to connection error", (Exception)((Object)e)));
            }
        }
        catch (JRockitConnectionException e) {
            this.throwRefusedException(new JRockitConnectionRefusedException("Handshaking with JRockit failed due to connection error", (Exception)((Object)e)));
        }
        if (resultPacket.getType() == 0) {
            if ("OK".equals(resultPacket.getData())) {
                this.m_handshaking = false;
                return;
            }
            if ("MAXE".equals(resultPacket.getCommand())) {
                this.throwRefusedException((JRockitConnectionRefusedException)new JRockitTooManyConnectionsException(Integer.parseInt(resultPacket.getParameters())));
            } else {
                this.throwRefusedException(new JRockitConnectionRefusedException("Handshaking with JRockit server failed. Connection refused, reason unknown."));
            }
        } else {
            this.throwRefusedException(new JRockitConnectionRefusedException("Handshaking with JRockit server failed. Incorrect packet type as reply."));
        }
    }

    public synchronized long getNextId() {
        return this.m_idCounter++;
    }

    public int getRmpReplyTimeout() {
        return this.m_rmpReplyTimeout;
    }

    public int getSocketTimeout() {
        return this.m_socketTimeout;
    }

    void handleSubscriptionUpdate(RmpPacket rmpPacket) {
        this.updateLatestTimestamp(rmpPacket.getTimestamp());
        this.m_dispatcherThread.addForDispatching(rmpPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncomingReply(RmpPacket rmpPacket) {
        this.updateLatestTimestamp(rmpPacket.getTimestamp());
        this.m_incomingPackets.put(new Long(rmpPacket.getMessageId()), rmpPacket);
        RmpConnection rmpConnection = this;
        synchronized (rmpConnection) {
            this.notifyAll();
        }
    }

    void handleSystemMessage(RmpPacket rmpPacket) {
        this.updateLatestTimestamp(rmpPacket.getTimestamp());
        this.killConnection();
        this.m_errorHandler.handleSystemMessage(rmpPacket.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConnectionException(Exception e) {
        RmpConnection rmpConnection = this;
        synchronized (rmpConnection) {
            if (this.m_handshaking) {
                this.m_error = e;
                return;
            }
        }
        if (!this.m_shutdownInitiated) {
            this.m_error = e;
            this.killConnection();
            this.m_errorHandler.handleRmpException(e);
        }
    }

    private void updateLatestTimestamp(long timestamp) {
        if (timestamp > this.m_latestTimestamp) {
            this.m_latestTimestamp = timestamp;
        }
    }

    private RmpPacket sendRmpWithReply(RmpPacket rmpPacket) throws JRockitConnectionException {
        this.doSendPacket(rmpPacket);
        return this.getReplyPacket(rmpPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendPacket(RmpPacket rmpPacket) throws JRockitConnectionException {
        RmpConnection rmpConnection = this;
        synchronized (rmpConnection) {
            if (!this.m_alive) {
                throw new JRockitConnectionException("Connection is closed. Can't send packet '" + rmpPacket.getCommand() + "'.");
            }
            try {
                rmpPacket.writeToStream(this.m_out);
            }
            catch (JRockitConnectionException e) {
                this.throwException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RmpPacket getReplyPacket(RmpPacket rmpPacket) throws JRockitConnectionException {
        Long packetId = new Long(rmpPacket.getMessageId());
        RmpPacket resultPacket = (RmpPacket)this.m_incomingPackets.remove(packetId);
        long maxRetryTime = System.currentTimeMillis() + (long)this.getRmpReplyTimeout();
        while (resultPacket == null && System.currentTimeMillis() <= maxRetryTime) {
            try {
                RmpConnection rmpConnection = this;
                synchronized (rmpConnection) {
                    this.wait(this.getRmpReplyTimeout());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resultPacket = (RmpPacket)this.m_incomingPackets.remove(packetId);
        }
        if (resultPacket == null) {
            this.throwException((JRockitConnectionException)((Object)new JRockitRmpPacketTimeOutException(rmpPacket.getCommand())));
        }
        return resultPacket;
    }

    public boolean sendCommand(String command, String argument) throws JRockitConnectionException, JRockitServerException {
        RmpPacket rmpPacket = new RmpPacket(1, this.getNextId(), String.valueOf(command) + argument);
        RmpPacket resultPacket = this.sendRmpWithReply(rmpPacket);
        if (resultPacket.getType() == -1) {
            this.throwEmbeddedException(resultPacket.getData());
        }
        return this.isAckOK(resultPacket);
    }

    private boolean isAckOK(RmpPacket resultPacket) {
        return resultPacket.getType() == 0 && "OK".equals(resultPacket.getData());
    }

    public boolean sendCommand(String command) throws JRockitConnectionException, JRockitServerException {
        return this.sendCommand(command, "");
    }

    public String sendQuery(String query) throws JRockitConnectionLostException, JRockitConnectionException, JRockitServerException {
        RmpPacket rmpPacket = new RmpPacket(2, this.getNextId(), query);
        RmpPacket resultPacket = this.sendRmpWithReply(rmpPacket);
        switch (resultPacket.getType()) {
            case 3: {
                return resultPacket.getData();
            }
            case -1: {
                this.throwEmbeddedException(resultPacket.getData());
            }
        }
        throw new JRockitConnectionException("Incorrect packet type as reply to query '" + query + "'. Type was: " + resultPacket.getType());
    }

    public boolean sendSubscribe(long subscriptionID, String aspectData, int updateInterval, boolean forceUpdate) throws JRockitConnectionException {
        RmpPacket rmpPacket = RmpPacket.createSubscribePacket((long)subscriptionID, (String)aspectData, (int)updateInterval, (boolean)forceUpdate);
        RmpPacket resultPacket = this.sendRmpWithReply(rmpPacket);
        return this.isAckOK(resultPacket);
    }

    public boolean sendUnsubscribe(String aspectName) throws JRockitConnectionException {
        RmpPacket rmpPacket = RmpPacket.createUnsubscribePacket((long)this.getNextId(), (String)aspectName);
        RmpPacket resultPacket = this.sendRmpWithReply(rmpPacket);
        return this.isAckOK(resultPacket);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean close() {
        boolean niceShutdown = false;
        if (!this.m_alive) {
            return false;
        }
        this.m_shutdownInitiated = true;
        try {
            try {
                RmpPacket rmpPacket = new RmpPacket(1, this.getNextId(), "EXIT");
                this.doSendPacket(rmpPacket);
                RmpPacket resultPacket = this.getReplyPacket(rmpPacket);
                niceShutdown = this.isAckOK(resultPacket);
            }
            catch (JRockitConnectionException ignored) {
                DebugPrinter.println((String)"jrockit connection exception when waiting for shutdown ok packet");
                DebugPrinter.exception((Throwable)ignored);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.killConnection();
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.killConnection();
            return niceShutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDownStreams() {
        Socket socket = this.m_socket;
        synchronized (socket) {
            if (!this.isOpen()) {
                return;
            }
            try {
                if (this.m_out != null) {
                    this.m_out.close();
                }
            }
            catch (IOException ignored) {
                DebugPrinter.println((String)("Error while shutting down output:" + ignored));
                DebugPrinter.exception((Throwable)ignored);
            }
            try {
                this.m_socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isOpen() {
        return this.m_alive && !this.m_shutdownInitiated;
    }

    public boolean errorHasOccurred() {
        return this.m_error != null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.killConnection();
    }

    protected void throwEmbeddedException(String errPacketPayload) throws JRockitServerException {
        String[] parts = errPacketPayload.split("\u0000");
        int len = parts.length;
        if (len > 1 && parts[0].equals("EXCP")) {
            String exClassNames = parts[1];
            String exMsg = len > 2 ? parts[2] : null;
            String exStackTrace = len > 3 ? parts[3] : null;
            JRockitServerException e = new JRockitServerException(exMsg, exClassNames, exStackTrace);
            this.m_error = e;
            throw e;
        }
    }

    private void throwException(JRockitConnectionException e) throws JRockitConnectionException {
        this.m_error = e;
        this.killConnection();
        throw e;
    }

    private void throwRefusedException(JRockitConnectionRefusedException e) throws JRockitConnectionRefusedException {
        this.m_error = e;
        this.killConnection();
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSocket() {
        Socket socket = this.m_socket;
        synchronized (socket) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void killConnection() {
        if (this.m_socket != null) {
            this.closeDownStreams();
        }
        if (this.m_readerThread != null) {
            this.m_readerThread.close();
        }
        if (this.m_dispatcherThread != null) {
            this.m_dispatcherThread.close();
        }
        this.m_alive = false;
    }

    public long getLatestTimestamp() {
        return this.m_latestTimestamp;
    }

    public Exception getLastError() {
        return this.m_error;
    }
}

