/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.connection;

import java.io.PrintStream;
import java.io.PrintWriter;

public class JRockitServerException
extends Exception {
    protected String[] causeClassNames;
    protected String causeStackTrace;

    public JRockitServerException(String msg, Exception cause) {
        super(msg, cause);
    }

    public JRockitServerException(String msg, String causeClassNames, String causeStackTrace) {
        this(msg, causeClassNames.split(" "), causeStackTrace);
    }

    public JRockitServerException(String msg, String[] causeClassNames, String causeStackTrace) {
        super(msg);
        this.causeClassNames = causeClassNames != null && causeClassNames.length > 0 ? causeClassNames : null;
        this.causeStackTrace = causeStackTrace;
    }

    public boolean isCauseInstanceOf(Class exceptionClass) {
        if (this.causeClassNames != null) {
            String className = exceptionClass.getName();
            int i = 0;
            while (i < this.causeClassNames.length) {
                if (className.equals(this.causeClassNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        Throwable e = this.getCause();
        while (e != null) {
            if (e instanceof JRockitServerException) {
                return ((JRockitServerException)e).isCauseInstanceOf(exceptionClass);
            }
            if (exceptionClass.isInstance(e)) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private String[] getCausedByLines() {
        if (this.causeStackTrace != null) {
            return ("Caused by: " + this.causeStackTrace).split("[\r\n]+");
        }
        if (this.causeClassNames != null) {
            String line = "Caused by: " + this.causeClassNames[0];
            if (this.getMessage() != null) {
                line = String.valueOf(line) + ": " + this.getMessage();
            }
            return new String[]{line};
        }
        return new String[0];
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        String[] lines = this.getCausedByLines();
        int i = 0;
        while (i < lines.length) {
            out.println(lines[i]);
            ++i;
        }
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        String[] lines = this.getCausedByLines();
        int i = 0;
        while (i < lines.length) {
            out.println(lines[i]);
            ++i;
        }
    }
}

