/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.console.connection;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.util.Assertion;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.connection.RmpConnection;
import com.jrockit.console.connection.RmpErrorHandler;
import com.jrockit.console.connection.RmpPushHandler;

public class ConnectorModel
implements RmpErrorHandler {
    private String m_serverName;
    private int m_port;
    private long m_startTime = -1L;
    private String m_name;
    private RmpPushHandler m_rmpPushHandler;
    private RmpConnection m_connection;
    private long m_savedLatestTimestamp = -1L;

    public ConnectorModel() {
    }

    public ConnectorModel(String serverName, int port) {
        this();
        this.setPort(port);
        this.setServerName(serverName);
    }

    public String getCompactName() {
        return String.valueOf(this.getServerName()) + ":" + this.getPort();
    }

    public boolean isConnected() {
        return this.m_connection != null && this.m_connection.isOpen();
    }

    public boolean isConnectionLost() {
        return this.m_connection != null && !this.m_connection.isOpen() && this.m_connection.errorHasOccurred();
    }

    public long getLatestTimestamp() {
        if (this.m_connection != null) {
            return this.m_connection.getLatestTimestamp();
        }
        return this.m_savedLatestTimestamp;
    }

    public void setName(String name) {
        this.m_name = this.m_name != null ? name : name;
    }

    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.getPort() != 7090 ? this.getCompactName() : this.getServerName();
        }
        return this.m_name;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setServerName(String serverName) {
        this.m_serverName = serverName;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void connect() throws JRockitConnectionException {
        Assertion.assertNotNull((Object)this.getServerName());
        Assertion.assertTrue((this.getPort() != 0 ? 1 : 0) != 0);
        if (this.isConnected()) {
            return;
        }
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_savedLatestTimestamp = this.m_connection.getLatestTimestamp();
        }
        this.m_connection = new RmpConnection(this.getServerName(), this.getPort(), this.getRmpPushHandler(), this);
        this.setStartTime(System.currentTimeMillis());
    }

    public RmpPushHandler getRmpPushHandler() {
        return this.m_rmpPushHandler;
    }

    public void connect(String serverName, int port) throws JRockitConnectionException {
        this.setServerName(serverName);
        this.setPort(port);
        this.connect();
    }

    public long createNewSubscriptionID() {
        if (this.m_connection == null) {
            return 0L;
        }
        return this.m_connection.getNextId();
    }

    public void disconnect() {
        if (this.m_connection == null) {
            return;
        }
        this.m_savedLatestTimestamp = this.m_connection.getLatestTimestamp();
        this.m_connection.close();
        this.m_connection = null;
    }

    public void handleRmpException(Exception e) {
    }

    public boolean sendCommand(String command, String argument) throws JRockitConnectionException, JRockitServerException {
        if (this.m_connection == null) {
            throw new JRockitConnectionException("Not connected");
        }
        return this.m_connection.sendCommand(command, argument);
    }

    public String sendQuery(String query) throws JRockitConnectionException, JRockitServerException {
        if (this.m_connection == null) {
            throw new JRockitConnectionException("Not connected");
        }
        return this.m_connection.sendQuery(query);
    }

    public boolean sendSubscribe(long subscriptionID, String aspectData, int updateInterval, boolean forceUpdate) throws JRockitConnectionException {
        if (this.m_connection == null) {
            throw new JRockitConnectionException("Not connected");
        }
        return this.m_connection.sendSubscribe(subscriptionID, aspectData, updateInterval, forceUpdate);
    }

    public boolean sendUnsubscribe(String aspectName) throws JRockitConnectionException {
        if (this.m_connection == null) {
            throw new JRockitConnectionException("Not connected");
        }
        return this.m_connection.sendUnsubscribe(aspectName);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }

    private void setStartTime(long startTime) {
        this.m_startTime = startTime;
    }

    public boolean equivalent(ConnectorModel connectorModel) {
        return this.getServerName().equalsIgnoreCase(connectorModel.getServerName()) && this.getPort() == connectorModel.getPort();
    }

    public void handleSystemMessage(String message) {
    }
}

