/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.wizards.Messages;
import com.jrockit.mc.common.security.IEncryptionScheme;
import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.common.security.SecurityManagerFactory;
import com.jrockit.mc.core.ui.HelpSupport;
import com.jrockit.mc.rjmx.ConnectionDescriptorToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IConnectionManager;
import com.jrockit.mc.rjmx.JMXDescriptorBuilder;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import com.jrockit.mc.rjmx.ui.security.SecurityToolkit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public final class ConnectionWizardPage
extends WizardPage {
    private static final String PROTOCOL_RMP = "rmp";
    private static final String PROTOCOL_RMI = "rmi";
    static final String PAGE_NAME = Messages.ConnectionWizardPage_PAGE_NAME;
    private IConnectionDescriptor descriptor;
    private Text hostNameField;
    private Text userNameField;
    private Text portField;
    private Text commandLineLabelField;
    private Label commandLineCaption;
    private Text passwordField;
    private Text connectionNameField;
    private Button storePasswordButton;
    private final InputVerifier verifier = new InputVerifier();
    private boolean hasEditedConnectionName = false;
    private JMXServiceURL currentUrl;
    private Button rmpButton;
    private Button jmxrmiButton;
    private Button customUrlButton;
    private Text testConnectionStatusText;
    private boolean enableTextVerifier = true;
    private StackLayout fieldStackLayout;
    private Composite hostNamePortFieldComposite;
    private Composite serviceUrlComposite;
    private Composite fieldStack;
    private Text serviceUrlField;

    private void setInputFieldsShowing(boolean showServiceUrlField) {
        if (showServiceUrlField) {
            this.enableTextVerifier = false;
            this.serviceUrlField.setText(this.currentUrl.toString());
            this.enableTextVerifier = true;
            this.fieldStackLayout.topControl = this.serviceUrlComposite;
            this.fieldStack.layout();
        } else {
            this.fieldStackLayout.topControl = this.hostNamePortFieldComposite;
            this.fieldStack.layout();
        }
    }

    private boolean updateHostAndPortFromServiceURL() {
        try {
            JMXServiceURL tmpUrl = new JMXServiceURL(this.serviceUrlField.getText());
            IConnectionDescriptor descriptor = new JMXDescriptorBuilder().url(tmpUrl).build();
            this.hostNameField.setText(ConnectionDescriptorToolkit.getHostName((IConnectionDescriptor)descriptor));
            this.portField.setText(String.valueOf(ConnectionDescriptorToolkit.getPort((IConnectionDescriptor)descriptor)));
            this.setErrorMessage(null);
            return true;
        }
        catch (MalformedURLException e) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_MESSAGE_NOT_VALID_SERVICE_URL, (Object)e.getLocalizedMessage()));
            this.setPageComplete(false);
            return false;
        }
    }

    public ConnectionWizardPage(IConnectionDescriptor descriptor) {
        super(PAGE_NAME, Messages.ConnectionWizardPage_PAGE_TITLE, null);
        this.descriptor = descriptor;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite c = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(2, false));
        this.fieldStackLayout = new StackLayout();
        this.fieldStack = new Composite(c, 0);
        this.fieldStack.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fieldStack.setLayout((Layout)this.fieldStackLayout);
        this.hostNamePortFieldComposite = new Composite(this.fieldStack, 0);
        GridLayout l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        this.hostNamePortFieldComposite.setLayout((Layout)l);
        Label hostNameLabel = new Label(this.hostNamePortFieldComposite, 16384);
        hostNameLabel.setText(Messages.ConnectionWizardPage_HOST_CAPTION);
        hostNameLabel.setToolTipText(Messages.ConnectionWizardPage_HOST_TOOLTIP);
        this.hostNameField = new Text(this.hostNamePortFieldComposite, 2052);
        GridData data = new GridData(768);
        this.hostNameField.setLayoutData((Object)data);
        Label portLabel = new Label(this.hostNamePortFieldComposite, 16384);
        portLabel.setText(Messages.ConnectionWizardPage_PORT_CAPTION);
        portLabel.setToolTipText(Messages.ConnectionWizardPage_PORT_TOOLTIP);
        this.portField = new Text(this.hostNamePortFieldComposite, 2052);
        data = new GridData(768);
        this.portField.setLayoutData((Object)data);
        this.serviceUrlComposite = new Composite(this.fieldStack, 0);
        l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        this.serviceUrlComposite.setLayout((Layout)l);
        Label serviceLabel = new Label(this.serviceUrlComposite, 16384);
        serviceLabel.setText(Messages.ConnectionWizardPage_SERVICE_URL_CAPTION);
        serviceLabel.setToolTipText(Messages.ConnectionWizardPage_SERVICE_URL_TOOLTIP);
        this.serviceUrlField = new Text(this.serviceUrlComposite, 2052);
        serviceLabel.setToolTipText(Messages.ConnectionWizardPage_SERVICE_URL_TOOLTIP);
        data = new GridData(768);
        this.serviceUrlField.setLayoutData((Object)data);
        JDKVersionSelector jdkVersionSelector = new JDKVersionSelector();
        Label jdkVersionLabel = new Label(c, 16384);
        jdkVersionLabel.setText(Messages.ConnectionWizardPage_LABEL_HOST_JDK_VERSION_TEXT);
        jdkVersionLabel.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_HOST_JDK_VERSION_DESCRIPTION_TEXT);
        Composite radioComposite = new Composite(c, 0);
        radioComposite.setLayout((Layout)new GridLayout(3, false));
        this.rmpButton = new Button(radioComposite, 16);
        this.rmpButton.setText(Messages.ConnectionWizardPage_BUTTON_JDK14_TEXT);
        this.rmpButton.addSelectionListener((SelectionListener)jdkVersionSelector);
        this.jmxrmiButton = new Button(radioComposite, 16);
        this.jmxrmiButton.setText(Messages.ConnectionWizardPage_BUTTON_JDK15_TEXT);
        this.jmxrmiButton.addSelectionListener((SelectionListener)jdkVersionSelector);
        this.customUrlButton = new Button(radioComposite, 16);
        this.customUrlButton.setText(Messages.ConnectionWizardPage_BUTTON_CUSTOM_JMX_SERVICE_URL_TEXT);
        this.customUrlButton.addSelectionListener((SelectionListener)jdkVersionSelector);
        data = new GridData(768);
        radioComposite.setLayoutData((Object)data);
        if (this.descriptor != null && ConnectionDescriptorToolkit.isLocal((IConnectionDescriptor)this.descriptor)) {
            this.commandLineCaption = new Label(c, 16384);
            this.commandLineCaption.setText(Messages.ConnectionWizardPage_CAPTION_COMMAND_LINE);
            this.commandLineCaption.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_COMMAND_LINE);
            this.commandLineLabelField = new Text(c, 2060);
            this.commandLineLabelField.setToolTipText(Messages.ConnectionWizardPage_TOOLTIP_COMMAND_LINE);
            data = new GridData(768);
            this.commandLineLabelField.setLayoutData((Object)data);
        }
        this.createLine(c, 2);
        Label userNameLabel = new Label(c, 16384);
        userNameLabel.setText(Messages.ConnectionWizardPage_USER_CAPTION);
        userNameLabel.setToolTipText(Messages.ConnectionWizardPage_USER_TOOLTIP);
        this.userNameField = new Text(c, 2052);
        data = new GridData(768);
        this.userNameField.setLayoutData((Object)data);
        Label passwordLabel = new Label(c, 16384);
        passwordLabel.setText(Messages.ConnectionWizardPage_PASSWORD_CAPTION);
        passwordLabel.setToolTipText(Messages.ConnectionWizardPage_PASSWORD_TOOLTIP);
        this.passwordField = new Text(c, 0x400804);
        data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        Label dummy = new Label(c, 16384);
        dummy.setText("");
        this.storePasswordButton = new Button(c, 32);
        this.storePasswordButton.setText(Messages.ConnectionWizardPage_STORE_CAPTION);
        data = new GridData(768);
        this.storePasswordButton.setLayoutData((Object)data);
        this.createLine(c, 2);
        Label connectionNameLabel = new Label(c, 16384);
        connectionNameLabel.setText(Messages.ConnectionWizardPage_CONNECTION_NAME_CAPTION);
        connectionNameLabel.setToolTipText(Messages.ConnectionWizardPage_CONNECTION_NAME_TOOLTIP);
        this.connectionNameField = new Text(c, 2052);
        data = new GridData(768);
        this.connectionNameField.setLayoutData((Object)data);
        Label connectionStatusLabel = new Label(c, 16384);
        connectionStatusLabel.setText(Messages.ConnectionWizardPage_STATUS_CAPTION);
        connectionStatusLabel.setToolTipText(Messages.ConnectionWizardPage_STATUS_TOOLTIP);
        Composite testConnectionComposite = new Composite(c, 16384);
        data = new GridData(768);
        testConnectionComposite.setLayoutData((Object)data);
        l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        testConnectionComposite.setLayout((Layout)l);
        this.testConnectionStatusText = new Text(testConnectionComposite, 18440);
        this.testConnectionStatusText.setText(Messages.ConnectionWizardPage_STATUS_IS_UNTESTED);
        data = new GridData(768);
        this.testConnectionStatusText.setLayoutData((Object)data);
        Button testConnectionButton = new Button(testConnectionComposite, 0x1000000);
        testConnectionButton.setText(Messages.ConnectionWizardPage_TEST_CONNECTION_CAPTION);
        testConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionWizardPage.this.testConnection();
            }
        });
        Action faqAction = HelpSupport.getHelpAction((String)"com.jrockit.mc.docs.FAQ");
        if (faqAction != null) {
            this.createLine(c, 2);
            FormText fText = new FormText(c, 0);
            fText.setText(Messages.ConnectionWizardPage_FAQ_TIP_TEXT, true, true);
            GridData gridDataFAQ = new GridData(768);
            gridDataFAQ.horizontalSpan = 2;
            fText.setLayoutData((Object)gridDataFAQ);
            fText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((IAction)faqAction){
                private final /* synthetic */ IAction val$faqAction;
                {
                    this.val$faqAction = iAction;
                }

                public void linkActivated(HyperlinkEvent e) {
                    this.val$faqAction.run();
                }
            });
        }
        this.setControl((Control)c);
        this.initializeFields();
        this.hostNameField.addModifyListener((ModifyListener)this.verifier);
        this.connectionNameField.addModifyListener((ModifyListener)this.verifier);
        this.serviceUrlField.addModifyListener((ModifyListener)this.verifier);
        this.portField.addModifyListener((ModifyListener)this.verifier);
        this.userNameField.addModifyListener((ModifyListener)this.verifier);
        this.checkIsPageComplete();
    }

    private void initializeFields() {
        IConnectionDescriptor props = this.descriptor;
        if (props == null) {
            try {
                props = new JMXDescriptorBuilder().hostName(ConnectionDescriptorToolkit.VALUE_LOCALHOST).port(ConnectionDescriptorToolkit.getDefaultPort()).name(ConnectionDescriptorToolkit.VALUE_LOCALHOST).build();
            }
            catch (IllegalStateException e) {
                JRockitBrowserPlugin.getDefault().getLogger().log(Level.SEVERE, "The unthinkable has happened!", e);
            }
        }
        this.hostNameField.setText(ConnectionDescriptorToolkit.getHostName((IConnectionDescriptor)props));
        this.portField.setText("" + ConnectionDescriptorToolkit.getPort((IConnectionDescriptor)props));
        String userName = ConnectionDescriptorToolkit.getUser((IConnectionDescriptor)props);
        this.userNameField.setText(userName == null ? "" : userName);
        this.connectionNameField.setText(props.getName() == null ? "" : props.getName());
        this.storePasswordButton.setSelection(ConnectionDescriptorToolkit.isExportingPassword((IConnectionDescriptor)props));
        if (ConnectionDescriptorToolkit.isExportingPassword((IConnectionDescriptor)props)) {
            String pwd = null;
            try {
                pwd = ConnectionDescriptorToolkit.getPassword((IConnectionDescriptor)props, (IConnectionManager)RJMXPlugin.getDefault().getConnectionManager());
            }
            catch (SecurityException e) {
                DialogToolkit.showException((Shell)this.getShell(), (String)"Problem decrypting password!", (String)"There was a problem descrypting the password!", (Throwable)e);
                e.printStackTrace();
            }
            this.passwordField.setText(pwd == null ? "" : pwd);
        }
        try {
            this.currentUrl = props.createJMXServiceURL();
            IConnectionDescriptor defaultUrlPathExtractorDesc = new JMXDescriptorBuilder().hostName(ConnectionDescriptorToolkit.getHostName((IConnectionDescriptor)props)).port(ConnectionDescriptorToolkit.getPort((IConnectionDescriptor)props)).useRMP(!this.currentUrl.getProtocol().equals(PROTOCOL_RMI)).build();
            String defaultUrlPath = defaultUrlPathExtractorDesc.createJMXServiceURL().getURLPath();
            if (this.currentUrl.getProtocol().equals(PROTOCOL_RMP) && this.currentUrl.getURLPath().equals(defaultUrlPath)) {
                this.rmpButton.setSelection(true);
            } else if (this.currentUrl.getProtocol().equals(PROTOCOL_RMI) && this.currentUrl.getURLPath().equals(defaultUrlPath)) {
                this.jmxrmiButton.setSelection(true);
            } else {
                this.customUrlButton.setSelection(true);
            }
        }
        catch (IOException e) {
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.FINE, e.getMessage(), e);
        }
        this.setInputFieldsShowing(this.customUrlButton.getSelection());
        if (ConnectionDescriptorToolkit.isLocal((IConnectionDescriptor)props)) {
            this.hostNameField.setEditable(false);
            this.portField.setEditable(false);
            this.connectionNameField.setEditable(false);
            this.serviceUrlField.setEditable(false);
            this.userNameField.setEditable(false);
            this.passwordField.setEditable(false);
            this.commandLineLabelField.setText((String)props.getExtendedProperties().get("com.jrockit.connectioninfo.commandline"));
            this.rmpButton.setEnabled(false);
            this.jmxrmiButton.setEnabled(false);
            this.customUrlButton.setEnabled(false);
        }
    }

    private void checkIsPageComplete() {
        if (this.descriptor != null && ConnectionDescriptorToolkit.isLocal((IConnectionDescriptor)this.descriptor)) {
            this.setErrorMessage(null);
            this.setMessage(Messages.ConnectionWizardPage_MESSAGE_LOCAL_CONNECTION);
            this.setPageComplete(false);
            return;
        }
        if (RJMXPlugin.getDefault().getDescriptorRepository().findDescriptorByConnectionName(this.connectionNameField.getText()) != null && this.descriptor == null) {
            this.setErrorMessage(MessageFormat.format(Messages.ConnectionWizardPage_ERROR_MESSAGE_NAME_ALREADY_EXIST, this.connectionNameField.getText()));
            this.setPageComplete(false);
            return;
        }
        if (this.customUrlButton.getSelection()) {
            try {
                this.currentUrl = new JMXServiceURL(this.serviceUrlField.getText());
                this.setErrorMessage(null);
            }
            catch (MalformedURLException ex) {
                this.setMessage(null);
                this.setErrorMessage(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_MESSAGE_NOT_VALID_SERVICE_URL, (Object)ex.getLocalizedMessage()));
                this.setPageComplete(false);
                return;
            }
        }
        try {
            int port = Integer.parseInt(this.portField.getText());
            if (port < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.setMessage(null);
            this.setErrorMessage(Messages.ConnectionWizardPage_ERROR_MESSAGE_PORT_MUST_BE_INTEGER);
            this.setPageComplete(false);
            return;
        }
        try {
            IConnectionDescriptor props = new JMXDescriptorBuilder().hostName(this.getHostName()).port(this.getPort()).useRMP(!this.jmxrmiButton.getSelection()).build();
            this.currentUrl = props.createJMXServiceURL();
        }
        catch (IOException ex) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)Messages.ConnectionWizardPage_ERROR_MESSAGE_NOT_VALID_SERVICE_URL, (Object)ex.getLocalizedMessage()));
            this.setPageComplete(false);
            return;
        }
        IConnectionDescriptor props = new JMXDescriptorBuilder().url(this.currentUrl).userName(this.getUserName()).exportPassword(false).name(this.getConnectionName()).build();
        if (RJMXPlugin.getDefault().getDescriptorRepository().contains(props) && this.descriptor == null) {
            this.setErrorMessage(Messages.ConnectionWizardPage_ERROR_MESSAGE_CONNECTION_CONFIG_ALREADY_EXIST);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.ConnectionWizardPage_MESSAGE_ENTER_CONNECTION_DETAILS);
        this.setPageComplete(true);
    }

    public IConnectionDescriptor storeToModel() throws SecurityException {
        JMXDescriptorBuilder builder = new JMXDescriptorBuilder();
        if (this.getPassword() != null && this.getPassword().length() > 0) {
            IEncryptionScheme scheme = SecurityManagerFactory.getSecurityManager().getEncryptionScheme();
            builder.encryptedPassword(SecurityToolkit.encrypt((Shell)this.getShell(), (String)this.getPassword(), (IEncryptionScheme)scheme), scheme.getIdentifier());
            builder.exportPassword(this.storePasswordButton.getSelection());
        }
        builder.url(this.currentUrl).userName(this.getUserName()).name(this.getConnectionName());
        if (this.descriptor != null) {
            builder.GUID(this.descriptor.getGUID());
        }
        return builder.build();
    }

    private void testConnection() {
        final String[] result = new String[1];
        IConnectionDescriptor descriptor = null;
        try {
            descriptor = this.storeToModel();
        }
        catch (SecurityException e) {
            result[0] = e.getMessage();
        }
        if (result[0] == null) {
            final IConnectionDescriptor finalDescriptor = descriptor;
            JRockitBrowserPlugin.getDefault().runProgressTask(false, true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ConnectionWizardPage_TESTING_CONNECTION_CAPTION, 1);
                    try {
                        try {
                            IConnectionHandle connector = RJMXPlugin.getDefault().getConnectionManager().connect(finalDescriptor);
                            RJMXPlugin.getDefault().getConnectionManager().disconnect(connector);
                            result[0] = Messages.ConnectionWizardPage_STATUS_IS_CONNECTED;
                        }
                        catch (IOException e) {
                            result[0] = Messages.ConnectionWizardPage_STATUS_IS_NOT_CONNECTED;
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        this.testConnectionStatusText.setText(result[0]);
    }

    private String generateConnectionName() {
        if (Integer.toString(ConnectionDescriptorToolkit.getDefaultPort()).equals(this.portField.getText().trim())) {
            return this.hostNameField.getText().trim();
        }
        return String.valueOf(this.hostNameField.getText().trim()) + ":" + this.portField.getText().trim();
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private int getPort() {
        try {
            return Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private String getConnectionName() {
        return this.connectionNameField.getText().trim();
    }

    private String getUserName() {
        return this.userNameField.getText().trim();
    }

    private String getPassword() throws SecurityException {
        if (this.passwordField.getText().trim() != null && !this.passwordField.getText().trim().equals("")) {
            return this.passwordField.getText().trim();
        }
        return null;
    }

    private String getHostName() {
        return this.hostNameField.getText().trim();
    }

    private class InputVerifier
    implements ModifyListener {
        private InputVerifier() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ConnectionWizardPage.this.enableTextVerifier) {
                return;
            }
            ConnectionWizardPage.this.testConnectionStatusText.setText(Messages.ConnectionWizardPage_STATUS_IS_UNTESTED);
            if (e.getSource() == ConnectionWizardPage.this.connectionNameField) {
                ConnectionWizardPage.this.hasEditedConnectionName = true;
            } else if (e.getSource() == ConnectionWizardPage.this.serviceUrlField) {
                ConnectionWizardPage.this.enableTextVerifier = false;
                ConnectionWizardPage.this.updateHostAndPortFromServiceURL();
                ConnectionWizardPage.this.enableTextVerifier = true;
            }
            if (!ConnectionWizardPage.this.hasEditedConnectionName) {
                ConnectionWizardPage.this.enableTextVerifier = false;
                ConnectionWizardPage.this.connectionNameField.setText(ConnectionWizardPage.this.generateConnectionName());
                ConnectionWizardPage.this.enableTextVerifier = true;
            }
            ConnectionWizardPage.this.checkIsPageComplete();
        }
    }

    private class JDKVersionSelector
    extends SelectionAdapter {
        private JDKVersionSelector() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == ConnectionWizardPage.this.rmpButton || e.getSource() == ConnectionWizardPage.this.jmxrmiButton) {
                if (ConnectionWizardPage.this.customUrlButton.getSelection()) {
                    return;
                }
                boolean supportsJmxrmi = ConnectionWizardPage.this.jmxrmiButton.getSelection();
                try {
                    IConnectionDescriptor portHostDeriver = new JMXDescriptorBuilder().url(ConnectionWizardPage.this.currentUrl).build();
                    IConnectionDescriptor desc = new JMXDescriptorBuilder().hostName(ConnectionDescriptorToolkit.getHostName((IConnectionDescriptor)portHostDeriver)).port(ConnectionDescriptorToolkit.getPort((IConnectionDescriptor)portHostDeriver)).useRMP(!supportsJmxrmi).build();
                    ConnectionWizardPage.this.currentUrl = desc.createJMXServiceURL();
                }
                catch (IllegalStateException ex) {
                    JRockitBrowserPlugin.getDefault().getLogger().log(Level.FINE, ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    JRockitBrowserPlugin.getDefault().getLogger().log(Level.FINE, ex.getMessage(), ex);
                }
            }
            ConnectionWizardPage.this.setInputFieldsShowing(ConnectionWizardPage.this.customUrlButton.getSelection());
        }
    }
}

