/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.wizards.ConnectionWizardPage;
import com.jrockit.mc.browser.wizards.Messages;
import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class ConnectionWizard
extends Wizard {
    private static final String SECTION_CONNECTION_WIZARD = "com.jrockit.mc.browser.wizards.ConnectionWizard";
    private IConnectionDescriptor m_descriptor;
    private IConnectionDescriptor m_result;

    public ConnectionWizard(IConnectionDescriptor descriptor) {
        this.setNeedsProgressMonitor(false);
        if (descriptor != null) {
            this.m_descriptor = descriptor;
        }
        this.initializeDefaultPageImageDescriptor();
        this.initializeDialogSettings();
    }

    private void initializeDialogSettings() {
        IDialogSettings wizardSettings = JRockitBrowserPlugin.getDefault().getDialogSettings().getSection(SECTION_CONNECTION_WIZARD);
        if (wizardSettings == null) {
            JRockitBrowserPlugin.getDefault().getDialogSettings().addNewSection(SECTION_CONNECTION_WIZARD);
        }
        this.setDialogSettings(wizardSettings);
    }

    private void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JRockitBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
    }

    public boolean performFinish() {
        try {
            this.m_result = ((ConnectionWizardPage)this.getPage(ConnectionWizardPage.PAGE_NAME)).storeToModel();
        }
        catch (SecurityException e) {
            DialogToolkit.showExceptionDialogAsync((Display)this.getShell().getDisplay(), (String)Messages.ConnectionWizard_EXCEPTION_COULD_NOT_STORE_CONNECTION, (Throwable)e);
            return false;
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ConnectionWizardPage(this.m_descriptor));
    }

    public boolean performCancel() {
        this.m_result = null;
        return true;
    }

    public IConnectionDescriptor getConnector() {
        return this.m_result;
    }
}

