/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.wizards.Messages;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.wizards.SimpleImportFromFileWizardPage;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.AbstractConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.NodeStructureChangeContext;
import com.jrockit.mc.rjmx.internal.JMXConnectionDescriptor;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConnectionImportWizard
extends Wizard
implements IImportWizard {
    private SimpleImportFromFileWizardPage m_wizardPage;
    static /* synthetic */ Class class$0;

    public boolean performFinish() {
        File file = this.m_wizardPage.getFile();
        if (file != null) {
            try {
                boolean importConnections = this.importConnections(file);
                if (importConnections) {
                    this.m_wizardPage.storeFilename();
                }
                return importConnections;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConnectionImportWizard_ERROR_IMPORTING_CONNECTIONS_TITLE, (String)MessageFormat.format(Messages.ConnectionImportWizard_ERROR_IMPORTING_FROM_FILE_X_TEXT, file.toString()), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    private Document createDocument(File file) throws FileNotFoundException, IOException, SAXException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Document document = XmlToolkit.loadDocumentFromStream((InputStream)new BufferedInputStream(is));
            return document;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private boolean importConnections(File file) throws FileNotFoundException, IOException, SAXException {
        Document doc = this.createDocument(file);
        if ("connections".equals(doc.getDocumentElement().getTagName())) {
            RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.importFromDocToNode(doc, ((ConnectionDescriptorRepository)rJMXPlugin.getService((Class)clazz)).getUserNode());
            NodeStructureChangeContext c = AbstractConnectionDescriptorNode.getNodeStructureChangeContext();
            if (c != null) {
                c.refreshTree();
            }
            return true;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConnectionImportWizard_ERROR_IMPORTING_TITLE, null, (IStatus)StatusFactory.createErr((String)MessageFormat.format(Messages.ConnectionImportWizard_NOT_VALID_CONNECTION_FILE_X_TEXT, file.toString())));
        return false;
    }

    private void importFromDocToNode(Document doc, IConnectionDescriptorNode parentNode) {
        List nodes = XmlToolkit.getChildNodesByTag((Node)doc.getDocumentElement(), (String)"connection");
        Map children = this.createChildrenMap(parentNode);
        ArrayList<JMXConnectionDescriptor> conflictList = new ArrayList<JMXConnectionDescriptor>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            JMXConnectionDescriptor descriptor = this.createConnectionFromXML((Element)iter.next());
            if (descriptor != null) {
                if (!children.containsKey(descriptor.getName())) {
                    parentNode.addConnectionDescriptor((IConnectionDescriptor)descriptor);
                    continue;
                }
                conflictList.add(descriptor);
                continue;
            }
            JRockitBrowserPlugin.getDefault().getLogger().warning("Could not create ConnectionDescriptor from XML.");
        }
        if (!conflictList.isEmpty()) {
            this.showLog(conflictList);
        }
    }

    private void showLog(ArrayList log) {
        MessageBox box = new MessageBox(this.getShell(), 8);
        String message = String.valueOf(Messages.ConnectionImportWizard_CONNECTION_CONFLICT_TEXT) + "\n\n";
        Iterator it = log.iterator();
        while (it.hasNext()) {
            JMXConnectionDescriptor desc = (JMXConnectionDescriptor)it.next();
            message = String.valueOf(message) + "\u2022 " + desc.getName() + "\n";
        }
        box.setMessage(message);
        box.setText(Messages.ConnectionImportWizard_CONNECTION_CONFLICT_WARNING_TITLE);
        box.open();
    }

    private Map createChildrenMap(IConnectionDescriptorNode parentNode) {
        HashMap<String, IConnectionDescriptorNode> map = new HashMap<String, IConnectionDescriptorNode>();
        int count = parentNode.getChildCount();
        int n = 0;
        while (n < count) {
            IConnectionDescriptorNode child = parentNode.getChildAt(n);
            map.put(child.getName(), child);
            ++n;
        }
        return map;
    }

    private JMXConnectionDescriptor createConnectionFromXML(Element element) {
        JMXConnectionDescriptor desc = XmlSerializerToolkit.createConnectionDescriptorFromXml((Element)element);
        if (desc == null) {
            JRockitBrowserPlugin.getDefault().getLogger().warning("Could not create ConnectionDecsriptor from XML");
        }
        return desc;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(JRockitBrowserPlugin.getDefault().getDialogSettings());
        this.m_wizardPage = new SimpleImportFromFileWizardPage(Messages.ConnectionImportWizard_IMPORT_CONNECTION_WIZARD_NAME, "xml");
        this.m_wizardPage.setTitle(Messages.ConnectionImportWizard_IMPORTCONNECTIONS_TITLE);
        this.m_wizardPage.setMessage(Messages.ConnectionImportWizard_SELECT_CONNECTION_FILE_FOR_IMPORT_TEXT);
        this.m_wizardPage.setImageDescriptor(JRockitBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
        this.addPage((IWizardPage)this.m_wizardPage);
    }
}

