/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.views.BrowserLabelProvider;
import com.jrockit.mc.browser.views.BrowserModelContentProvider;
import com.jrockit.mc.browser.wizards.Messages;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.wizards.ExportToFileWizardPage;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository;
import com.jrockit.mc.rjmx.internal.JMXConnectionDescriptor;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionExportWizard
extends Wizard
implements IExportWizard {
    private ExportToFileWizardPage m_wizardPage;
    static /* synthetic */ Class class$0;

    public boolean performFinish() {
        if (this.m_wizardPage.isExportToFileOk()) {
            try {
                boolean export = this.export(this.m_wizardPage.getFile(), this.filterOutNodes(this.m_wizardPage.getSelectedItems()));
                if (export) {
                    this.m_wizardPage.storeFilename();
                }
                return export;
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConnectionExportWizard_EXPORT_FILE_ERROR_TITLE, (String)(String.valueOf(Messages.ConnectionExportWizard_FILE_ERROR_EXPORT_TEXT) + "\n\n" + this.m_wizardPage.getFile()), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    protected boolean export(File file, Collection selection) throws IOException {
        FileWriter fw = null;
        try {
            Document doc = XmlToolkit.createNewDocument((String)"connections");
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                IConnectionDescriptor desc = (IConnectionDescriptor)it.next();
                if (!(desc instanceof JMXConnectionDescriptor)) continue;
                XmlSerializerToolkit.exportToXml((JMXConnectionDescriptor)((JMXConnectionDescriptor)desc), (Element)doc.getDocumentElement());
            }
            fw = new FileWriter(file);
            fw.write(XmlToolkit.storeDocumentToString((Document)doc));
        }
        catch (Throwable throwable) {
            this.closeWriter(fw);
            throw throwable;
        }
        this.closeWriter(fw);
        return true;
    }

    protected Collection filterOutNodes(Collection collection) {
        HashSet<IConnectionDescriptor> rules = new HashSet<IConnectionDescriptor>();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof ConnectionDescriptorNode)) continue;
            rules.add(((ConnectionDescriptorNode)next).getConnectionDescriptor());
        }
        return rules;
    }

    protected final void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(JRockitBrowserPlugin.getDefault().getDialogSettings());
        this.m_wizardPage = new ExportConnectionsToFile(Messages.ConnectionExportWizard_ECPORT_CONNECTIONS_WIZARD_PAGE_NAME);
        this.m_wizardPage.setTitle(Messages.ConnectionExportWizard_EXPORT_CONNECTIONS_TITLE);
        this.m_wizardPage.setMessage(Messages.ConnectionExportWizard_SELECTIONCONNECTIONS_TO_EXPORT);
        this.m_wizardPage.setImageDescriptor(JRockitBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
        this.setWindowTitle(Messages.ConnectionExportWizard_WIZARD_EXPORT_CONNECTION_TITLE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean canFinish() {
        return this.m_wizardPage != null && this.m_wizardPage.isPageComplete();
    }

    private static class ExportConnectionsToFile
    extends ExportToFileWizardPage {
        private ExportConnectionsToFile(String pageName) {
            super(pageName, "xml");
        }

        protected void initializeViewer(TreeViewer viewer) {
            viewer.setAutoExpandLevel(2);
            viewer.setContentProvider((IContentProvider)new BrowserModelContentProvider());
            RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            viewer.setInput((Object)((ConnectionDescriptorRepository)rJMXPlugin.getService((Class)clazz)).getBrowserModelRoot());
            viewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
            viewer.setFilters(new ViewerFilter[]{new NotDiscoveredFilter()});
        }

        private class NotDiscoveredFilter
        extends ViewerFilter {
            private NotDiscoveredFilter() {
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return !((ConnectionDescriptorRepository)rJMXPlugin.getService((Class)clazz)).getAutoDetectNode().equals(element);
            }
        }
    }
}

