/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.views.JRockitBrowserNodeTransfer;
import com.jrockit.mc.browser.views.JRockitBrowserView;
import com.jrockit.mc.browser.views.Messages;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.connections.internal.AbstractConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorFolderNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.TreeItem;

public class JRockitBrowserViewDropTarget
extends DropTargetAdapter {
    private JRockitBrowserView m_view;

    public JRockitBrowserViewDropTarget(JRockitBrowserView view, TreeViewer viewer) {
        this.m_view = view;
        DropTarget target = new DropTarget(viewer.getControl(), 3);
        target.setTransfer(new Transfer[]{JRockitBrowserNodeTransfer.getInstance()});
        target.addDropListener((DropTargetListener)this);
    }

    public void drop(DropTargetEvent event) {
        TreeItem item;
        super.drop(event);
        if (event.data != null && event.item instanceof TreeItem && (item = (TreeItem)event.item).getData() instanceof ConnectionDescriptorFolderNode) {
            ConnectionDescriptorFolderNode target = (ConnectionDescriptorFolderNode)item.getData();
            if (event.data instanceof IConnectionDescriptorNode) {
                if (this.m_view.isAutoDetectList((IConnectionDescriptorNode)target)) {
                    System.out.println(Messages.JRockitBrowserViewDropTarget_NOT_IMPLEMENTED);
                    event.detail = 1;
                    return;
                }
                IConnectionDescriptorNode node = (IConnectionDescriptorNode)event.data;
                target.addChild(node);
                if (node.isConnectionNode()) {
                    this.clearJDPFlag((ConnectionDescriptorNode)node);
                }
                this.m_view.highlightNode(node, 500);
                event.detail = 2;
                return;
            }
        }
        event.detail = 0;
    }

    private void clearJDPFlag(ConnectionDescriptorNode node) {
        IConnectionDescriptor descriptor = node.getConnectionDescriptor();
        if (descriptor != null) {
            descriptor.getExtendedProperties().remove("com.jrockit.connectioninfo.jdp.discovered");
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (event.item instanceof TreeItem) {
            AbstractConnectionDescriptorNode fnode;
            TreeItem item = (TreeItem)event.item;
            event.detail = item.getData() instanceof ConnectionDescriptorFolderNode ? ((fnode = (AbstractConnectionDescriptorNode)item.getData()).getParent() == this.m_view.getBrowserModel().getDiscoveryNode() || fnode == this.m_view.getBrowserModel().getDiscoveryNode() ? 0 : 2) : 0;
        }
    }
}

