/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.autodiscovery.IDescriptorListener;
import com.jrockit.mc.browser.autodiscovery.IDescriptorProvider;
import com.jrockit.mc.browser.views.BrowserLabelProvider;
import com.jrockit.mc.browser.views.BrowserModelContentProvider;
import com.jrockit.mc.browser.views.JRockitBrowserToolkit;
import com.jrockit.mc.browser.views.JRockitBrowserViewDragSource;
import com.jrockit.mc.browser.views.JRockitBrowserViewDropTarget;
import com.jrockit.mc.browser.views.Messages;
import com.jrockit.mc.browser.wizards.ConnectionWizardDialog;
import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.idesupport.StandardPerspective;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.ui.FontToolkit;
import com.jrockit.mc.rjmx.ConnectionDescriptorToolkit;
import com.jrockit.mc.rjmx.ConnectionManager;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.connections.internal.AbstractConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionHandler;
import com.jrockit.mc.rjmx.core.connections.internal.NodeStructureChangeContext;
import com.jrockit.mc.rjmx.security.IPasswordProvider;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.InternalToolkit;
import com.jrockit.mc.rjmx.ui.security.SecurityToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class JRockitBrowserView
extends ViewPart
implements NodeStructureChangeContext {
    public static String ID = "com.jrockit.mc.browser.views.JRockitBrowserView";
    private static final char EXPANSION_STATE_DELIMITER = '\u0002';
    private TreeViewer m_viewer;
    private Action m_actionDisconnect;
    private Action m_actionNewFolder;
    private Action m_actionNewConnection;
    private Action m_doubleClickAction;
    private Action m_actionRemove;
    private Action m_actionEdit;
    private Action m_actionDebug;
    private Font m_normal;
    private Font m_bold;
    private MenuManager m_menuManager;
    private final List m_highlightList = new ArrayList();
    private List m_discoveryListeners = new ArrayList();
    private ConnectionDescriptorRepository connectionDescriptorRepository;
    static /* synthetic */ Class class$0;

    public JRockitBrowserView() {
        AbstractConnectionDescriptorNode.setNodeStructureChangeContext((NodeStructureChangeContext)this);
        RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.connectionDescriptorRepository = (ConnectionDescriptorRepository)rJMXPlugin.getService((Class)clazz);
    }

    public void createPartControl(Composite parent) {
        if (!this.isRunningOnJRockit()) {
            new MessageDialog(parent.getShell(), Messages.JRockitBrowserView_DIALOG_NON_JROCKIT_TITLE, null, Messages.JRockitBrowserView_DIALOG_NON_JROCKIT_MESSAGE, 0, new String[]{Messages.JRockitBrowserView_DIALOG_NON_JROCKIT_BUTTON_LABEL}, 0).open();
        }
        this.registerPasswordProvider(parent.getShell());
        this.m_viewer = new TreeViewer(parent, 770);
        this.m_viewer.setContentProvider((IContentProvider)new BrowserModelContentProvider());
        this.m_normal = this.m_viewer.getTree().getFont();
        this.m_bold = FontToolkit.deriveFont((Device)this.m_viewer.getControl().getDisplay(), (Font)this.m_normal, (int)1, (int)-1);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new JRockitBrowserFontLabelProvider());
        this.m_viewer.setSorter((ViewerSorter)new NameSorter());
        this.m_viewer.setInput((Object)this.connectionDescriptorRepository.getBrowserModelRoot());
        this.loadExpansionState();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.m_viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.m_viewer.getControl(), "com.jrockit.mc.browser.tree");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JRockitBrowserView.this.recomputeActionEnablement();
            }
        });
        this.m_viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                JRockitBrowserView.this.m_viewer.getControl().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        JRockitBrowserView.access$4(2.access$0(this.this$1));
                    }
                });
            }

            public void treeExpanded(TreeExpansionEvent event) {
                JRockitBrowserView.this.m_viewer.getControl().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        JRockitBrowserView.access$4(2.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ JRockitBrowserView access$0(2 var0) {
                return var0.JRockitBrowserView.this;
            }
        });
        this.setUpDiscoveryListeners();
        this.hookDragAndDrop();
        this.showViewIfClosedWithAnEditor(parent.getDisplay());
    }

    private void showViewIfClosedWithAnEditor(Display display) {
        DisplayToolkit.safeAsyncExec((Display)display, (Runnable)new Runnable(){

            public void run() {
                JRockitBrowserView.this.showView(JRockitBrowserView.this.getSite().getWorkbenchWindow().getActivePage(), ID);
            }
        });
    }

    private void showView(IWorkbenchPage activePage, String id) {
        try {
            IPerspectiveDescriptor pd;
            if (activePage != null && StandardPerspective.isClosedWithEditorOpened() && (pd = activePage.getPerspective()) != null && "com.jrockit.mc.core.idesupport.StandardPerspective".equals(pd.getId())) {
                StandardPerspective.setClosedWithEditor((boolean)false);
                activePage.showView(id);
            }
        }
        catch (Exception e) {
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Error trying to show JRockit Browser view at startup (after application closed with an opened editor)");
        }
    }

    private void registerPasswordProvider(final Shell shell) {
        ((ConnectionManager)RJMXPlugin.getDefault().getConnectionManager()).setPasswordProvider(new IPasswordProvider(){

            public String getPassword(IConnectionDescriptor descriptor) throws SecurityException, IllegalArgumentException {
                String pwd;
                if (descriptor.getEnvironment() != null && (pwd = ConnectionDescriptorToolkit.getCredentials((IConnectionDescriptor)descriptor)[1]) != null) {
                    return pwd;
                }
                String encryptedPwd = (String)descriptor.getExtendedProperties().get("com.jrockit.connectioninfo.password.encrypted");
                if (encryptedPwd != null) {
                    return SecurityToolkit.decrypt((Shell)shell, (String)encryptedPwd, (String)((String)descriptor.getExtendedProperties().get("com.jrockit.connectioninfo.password.encryption.scheme")));
                }
                return null;
            }
        });
    }

    private boolean isRunningOnJRockit() {
        String vmName = System.getProperty("java.vm.name");
        return vmName.startsWith("BEA JRockit") || vmName.startsWith("Oracle JRockit");
    }

    private void setUpDiscoveryListeners() {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("com.jrockit.mc.browser", "descriptorProvider");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                try {
                    if (configs[j].getName().equals("provider")) {
                        IDescriptorProvider provider = (IDescriptorProvider)configs[j].createExecutableExtension("class");
                        this.m_discoveryListeners.add(new BrowserDiscoveryHandler(provider));
                        break;
                    }
                }
                catch (CoreException e) {
                    JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to start up a IDescriptorProvider! This is usually due to the provider demanding a certain JDK-level.", e);
                }
                ++j;
            }
            ++i;
        }
    }

    private void hookDragAndDrop() {
        new JRockitBrowserViewDragSource(this, this.m_viewer);
        new JRockitBrowserViewDropTarget(this, this.m_viewer);
    }

    private void hookContextMenu() {
        this.m_menuManager = new MenuManager("#PopupMenu");
        this.m_menuManager.setRemoveAllWhenShown(true);
        this.m_menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JRockitBrowserView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.m_menuManager.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.m_menuManager, (ISelectionProvider)this.m_viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.m_actionNewConnection);
        manager.add((IAction)this.m_actionNewFolder);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.m_actionDisconnect);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.m_actionNewFolder);
        manager.add((IAction)this.m_actionNewConnection);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.m_actionDisconnect);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.m_actionRemove);
        if (Boolean.getBoolean("com.jrockit.mc.browser.debug")) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.m_actionDebug);
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.m_actionEdit);
    }

    private boolean isConnectionOrIgnoreListRoot(IConnectionDescriptorNode node) {
        if (node == null) {
            return false;
        }
        return node.getParent().equals(this.connectionDescriptorRepository.getBrowserModelRoot());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.m_actionNewConnection);
        manager.add((IAction)this.m_actionNewFolder);
        manager.add((IAction)this.m_actionDisconnect);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.m_actionDisconnect = new Action(){

            public void run() {
                InternalToolkit.disconnect((Shell)JRockitBrowserView.this.m_viewer.getControl().getShell(), (Collection)JRockitBrowserView.this.getSelectedConnectionNodes());
                JRockitBrowserView.this.m_viewer.refresh();
            }
        };
        this.m_actionDisconnect.setText(Messages.JRockitBrowserView_ACTION_DISCONNECT_TEXT);
        this.m_actionDisconnect.setToolTipText(Messages.JRockitBrowserView_ACTION_DISCONNECT_TOOLTIP);
        this.m_actionDisconnect.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("disconnect.gif"));
        this.m_actionNewFolder = new Action(){

            public void run() {
                this.showNewFolderDialog();
            }

            private void showNewFolderDialog() {
                IStructuredSelection selection = (IStructuredSelection)JRockitBrowserView.this.m_viewer.getSelection();
                IConnectionDescriptorNode node = null;
                if (!selection.isEmpty()) {
                    Iterator iter = selection.iterator();
                    node = (IConnectionDescriptorNode)iter.next();
                }
                if (node == null) {
                    JRockitBrowserView.this.showMessage(Messages.JRockitBrowserView_DIALOG_NEW_FOLDER_ERROR_MESSAGE_NO_SELECTED_NODE);
                    return;
                }
                InputDialog dlg = new InputDialog(JRockitBrowserView.this.m_viewer.getControl().getShell(), Messages.JRockitBrowserView_DIALOG_NEW_FOLDER_TITLE, Messages.JRockitBrowserView_DIALOG_NEW_FOLDER_TEXT, Messages.JRockitBrowserView_DIALOG_NEW_FOLDER_DEFAULT_VALUE, JRockitBrowserView.this.createFolderStringValidator());
                dlg.open();
                if (dlg.getReturnCode() == 0) {
                    String folderName = dlg.getValue();
                    node.addFolder(folderName);
                    JRockitBrowserView.this.connectionDescriptorRepository.storeSettings();
                    JRockitBrowserView.this.refreshTree();
                }
            }
        };
        this.m_actionNewFolder.setText(Messages.JRockitBrowserView_ACTION_NEW_FOLDER_TEXT);
        this.m_actionNewFolder.setToolTipText(Messages.JRockitBrowserView_ACTION_NEW_FOLDER_TOOLTIP);
        this.m_actionNewFolder.setImageDescriptor(JRockitBrowserPlugin.getDefault().getMCImageDescriptor("newfolder.gif"));
        this.m_actionRemove = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)JRockitBrowserView.this.m_viewer.getSelection();
                if (selection == null || selection.size() == 0) {
                    JRockitBrowserView.this.showMessage(Messages.JRockitBrowserView_ACTION_REMOVE_ERROR_MESSAGE_NOTHING_SELECTED);
                    return;
                }
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    IConnectionDescriptorNode node = (IConnectionDescriptorNode)iter.next();
                    if (JRockitBrowserView.this.isConnectionOrIgnoreListRoot(node) || JRockitBrowserView.this.isDescendantOfAutodiscovery(node) && !node.isConnectionNode()) {
                        if (JRockitBrowserView.this.connectionDescriptorRepository.getBrowserModelRoot().getChildAt(0) == node) {
                            JRockitBrowserView.this.showMessage(Messages.JRockitBrowserView_ACTION_REMOVE_ERROR_MESSAGE_CANNOT_REMOVE_ROOT);
                            continue;
                        }
                        if (!JRockitBrowserView.this.isDescendantOfAutodiscovery(node) || node.isConnectionNode()) continue;
                        JRockitBrowserView.this.showMessage(Messages.JRockitBrowserView_ACTION_REMOVE_ERROR_MESSAGE_CANNOT_REMOVE_IGNORE_LIST);
                        continue;
                    }
                    if (!JRockitBrowserView.isConfirmingDeletes()) {
                        this.removeNode(node);
                        continue;
                    }
                    if (!MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.JRockitBrowserView_DIALOG_REMOVE_TITLE, (String)NLS.bind((String)Messages.JRockitBrowserView_DIALOG_REMOVE_TEXT, (Object)node))) continue;
                    this.removeNode(node);
                }
            }

            private void removeNode(IConnectionDescriptorNode node) {
                Set connectionNodes = JRockitBrowserToolkit.getConnectionNodes(node);
                Iterator iter = connectionNodes.iterator();
                while (iter.hasNext()) {
                    ConnectionDescriptorNode cnode = (ConnectionDescriptorNode)iter.next();
                    ArrayList handlers = new ArrayList(cnode.getConnectionHandlers());
                    Iterator iter2 = handlers.iterator();
                    while (iter2.hasNext()) {
                        IConnectionHandler handler = (IConnectionHandler)iter2.next();
                        handler.shutDown(true);
                        cnode.removeConnectionHandler(handler);
                    }
                }
                Set descriptors = AbstractConnectionDescriptorNode.getConnectionDescriptors((IConnectionDescriptorNode)node);
                Iterator iter2 = descriptors.iterator();
                while (iter2.hasNext()) {
                    RJMXPlugin.getDefault().getDescriptorRepository().remove((IConnectionDescriptor)iter2.next());
                }
                node.removeFromParent();
                JRockitBrowserView.this.connectionDescriptorRepository.storeSettings();
                JRockitBrowserView.this.refreshTree();
            }
        };
        this.m_actionRemove.setText(Messages.JRockitBrowserView_ACTION_REMOVE_TEXT);
        this.m_actionRemove.setToolTipText(Messages.JRockitBrowserView_ACTION_REMOVE_TOOLTIP);
        this.m_actionRemove.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("delete-16.png"));
        this.m_viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f') {
                    JRockitBrowserView.this.m_actionRemove.run();
                }
            }
        });
        this.m_actionNewConnection = new Action(){

            public void run() {
                IConnectionDescriptor descriptor = ConnectionWizardDialog.editConnection(Display.getCurrent().getActiveShell(), Messages.JRockitBrowserView_DIALOG_TITLE_NEW_CONNECTION, null);
                if (descriptor != null) {
                    Iterator iter;
                    IStructuredSelection selection = (IStructuredSelection)JRockitBrowserView.this.m_viewer.getSelection();
                    IConnectionDescriptorNode node = null;
                    if (!selection.isEmpty() && (iter = selection.iterator()) != null && iter.hasNext()) {
                        node = (IConnectionDescriptorNode)iter.next();
                    }
                    if (node == null || node.getLevel() <= 1) {
                        node = JRockitBrowserView.this.connectionDescriptorRepository.getBrowserModelRoot().getChildAt(0);
                    }
                    node.addConnectionDescriptor(descriptor);
                    JRockitBrowserView.this.m_viewer.setExpandedState((Object)node, true);
                    JRockitBrowserView.this.connectionDescriptorRepository.storeSettings();
                    JRockitBrowserView.this.refreshTree();
                }
            }
        };
        this.m_actionNewConnection.setText(Messages.JRockitBrowserView_ACTION_NEW_CONNECTION_TEXT);
        this.m_actionNewConnection.setToolTipText(Messages.JRockitBrowserView_ACTION_NEW_CONNECTION_TOOLTIP);
        this.m_actionNewConnection.setImageDescriptor(JRockitBrowserPlugin.getDefault().getMCImageDescriptor("newconnection.gif"));
        this.m_doubleClickAction = new Action(){

            public void run() {
                Object elem = ((IStructuredSelection)JRockitBrowserView.this.m_viewer.getSelection()).getFirstElement();
                if (elem == null) {
                    return;
                }
                JRockitBrowserView.this.m_viewer.setExpandedState(elem, !JRockitBrowserView.this.m_viewer.getExpandedState(elem));
            }
        };
        this.m_actionEdit = new Action(){

            public void run() {
                IConnectionDescriptorNode node = JRockitBrowserView.this.getSelectedNode();
                if (node == null) {
                    MessageDialog.openInformation((Shell)JRockitBrowserView.this.m_viewer.getControl().getShell(), (String)Messages.JRockitBrowserView_DIALOG_SELECT_TITLE, (String)Messages.JRockitBrowserView_DIALOG_SELECT_MESSAGE);
                    return;
                }
                if (JRockitBrowserView.this.isConnectionOrIgnoreListRoot(node) || JRockitBrowserView.this.isDescendantOfAutodiscovery(node) && !node.isConnectionNode()) {
                    MessageDialog.openInformation((Shell)JRockitBrowserView.this.m_viewer.getControl().getShell(), (String)Messages.JRockitBrowserView_DIALOG_NOT_EDITABLE_TITLE, (String)Messages.JRockitBrowserView_DIALOG_NOT_EDITABLE_MESSAGE);
                    return;
                }
                if (node.isConnectionNode()) {
                    ConnectionDescriptorNode cnode = (ConnectionDescriptorNode)node;
                    if (cnode.isConnected()) {
                        MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.JRockitBrowserView_DIALOG_NODE_IS_CONNECTED_TITLE, (String)Messages.JRockitBrowserView_DIALOG_NODE_IS_CONNECTED_MESSAGE);
                    }
                    IConnectionDescriptor previous = node.getConnectionDescriptor();
                    IConnectionDescriptor descriptor = ConnectionWizardDialog.editConnection(JRockitBrowserView.this.m_viewer.getControl().getShell(), Messages.JRockitBrowserView_DIALOG_TITLE_CONNECTION_PROPERTIES, previous);
                    if (descriptor != null) {
                        cnode.setConnectionDescriptor(descriptor);
                        JRockitBrowserView.this.connectionDescriptorRepository.storeSettings();
                    }
                } else {
                    InputDialog dlg = new InputDialog(JRockitBrowserView.this.m_viewer.getControl().getShell(), Messages.JRockitBrowserView_FOLDER_PROPERTIES_TITLE_TEXT, Messages.JRockitBrowserView_FOLDER_NAME_TEXT, node.getName(), JRockitBrowserView.this.createFolderStringValidator());
                    dlg.open();
                    if (dlg.getReturnCode() == 0) {
                        String folderName = dlg.getValue();
                        node.setName(folderName);
                        JRockitBrowserView.this.connectionDescriptorRepository.storeSettings();
                    }
                }
            }
        };
        this.m_actionEdit.setText(Messages.JRockitBrowserView_ACTION_EDIT_TEXT);
        this.m_actionEdit.setToolTipText(Messages.JRockitBrowserView_ACTION_EDIT_TOOLTIP);
        this.m_actionDebug = new Action(){

            public void run() {
                ConnectionDescriptorNode node;
                System.out.println("==================START==================");
                System.out.println("\nCurrently registered RJMXConnectorModels:");
                System.out.println("=========================================");
                Iterator iter = RJMXPlugin.getDefault().getDescriptorRepository().getConnectionDescriptors().iterator();
                while (iter.hasNext()) {
                    IConnectionDescriptor descriptor = (IConnectionDescriptor)iter.next();
                    System.out.println(String.valueOf(descriptor.getName()) + " \t " + "ID=" + descriptor.getGUID());
                }
                System.out.println("\nCurrently selected RJMXConnectorModels:");
                System.out.println("=========================================");
                iter = JRockitBrowserView.this.getSelectedConnectionNodes().iterator();
                while (iter.hasNext()) {
                    node = (ConnectionDescriptorNode)iter.next();
                    System.out.println(String.valueOf(node.getConnectionDescriptor().getName()) + " \t " + "ID=" + node.getConnectionDescriptor().getGUID());
                }
                System.out.println("\nRegistered connection handlers:");
                System.out.println("=========================================");
                iter = JRockitBrowserToolkit.getConnectionNodes(JRockitBrowserView.this.connectionDescriptorRepository.getBrowserModelRoot()).iterator();
                while (iter.hasNext()) {
                    node = (ConnectionDescriptorNode)iter.next();
                    System.out.println("Connection Handlers for " + node.getName() + ":");
                    Iterator handlerIter = node.getConnectionHandlers().iterator();
                    while (handlerIter.hasNext()) {
                        System.out.println("\t" + ((IConnectionHandler)handlerIter.next()).getHandlerName());
                    }
                }
                System.out.println("\nConnectionDescriptors:");
                System.out.println("=========================================");
                iter = JRockitBrowserToolkit.getConnectionNodes(JRockitBrowserView.this.connectionDescriptorRepository.getBrowserModelRoot()).iterator();
                while (iter.hasNext()) {
                    node = (ConnectionDescriptorNode)iter.next();
                    System.out.println(String.valueOf(node.getName()) + ":");
                    IConnectionDescriptor descriptor = node.getConnectionDescriptor();
                    System.out.println("\tCompact name:\t" + ConnectionDescriptorToolkit.getCompactName((IConnectionDescriptor)descriptor));
                    System.out.println("\tHost name:\t" + ConnectionDescriptorToolkit.getHostName((IConnectionDescriptor)descriptor));
                    System.out.println("\tPort:\t" + ConnectionDescriptorToolkit.getPort((IConnectionDescriptor)descriptor));
                    try {
                        System.out.println("\tService URL:\t" + descriptor.createJMXServiceURL());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    System.out.println("\tExtended(" + descriptor.getExtendedProperties().keySet().size() + "):");
                    Iterator extIter = descriptor.getExtendedProperties().keySet().iterator();
                    while (extIter.hasNext()) {
                        Object key = extIter.next();
                        System.out.println("\t\t" + key + "\t=\t" + descriptor.getExtendedProperties().get(key));
                    }
                }
                System.out.println("\nTesting logging:");
                System.out.println("=========================================");
                JRockitBrowserPlugin.getDefault().getLogger().info("Info log message");
                JRockitBrowserPlugin.getDefault().getLogger().warning("Warning log message");
                JRockitBrowserPlugin.getDefault().getLogger().severe("Severe log message");
                System.out.println("===================END===================");
                System.out.println("\n");
                JRockitBrowserView.this.loadExpansionState();
            }
        };
        this.m_actionDebug.setText("Debug (\u57fa\u672c\u8a2d\u5b9a\u304c\u3059\u3079\u3066\u81ea\u52d5\u8a2d\u5b9a\u3055\u308c\u307e\u3059 !)");
        this.m_actionDebug.setToolTipText("Lists UID's of all connections");
    }

    private void hookDoubleClickAction() {
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JRockitBrowserView.this.m_doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.m_viewer.getControl().getShell(), (String)Messages.JRockitBrowserView_DIALOG_MESSAGE_TITLE, (String)message);
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    public void dispose() {
        Iterator iter = this.m_discoveryListeners.iterator();
        while (iter.hasNext()) {
            ((BrowserDiscoveryHandler)iter.next()).shutDown();
        }
        if (this.m_bold != null) {
            this.m_bold.dispose();
        }
    }

    public IConnectionDescriptorNode getSelectedNode() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            return (IConnectionDescriptorNode)iter.next();
        }
        return null;
    }

    public Set getSelectedConnectionNodes() {
        return JRockitBrowserToolkit.getConnectionNodes(this.m_viewer.getSelection());
    }

    private void storeExpansionState() {
        Object[] expandedElements = this.m_viewer.getExpandedElements();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < expandedElements.length) {
            buffer.append(expandedElements[i]);
            buffer.append('\u0002');
            ++i;
        }
        JRockitBrowserPlugin.getDefault().getPreferenceStore().setValue("expanded", buffer.toString());
    }

    private void loadExpansionState() {
        String state = JRockitBrowserPlugin.getDefault().getPreferenceStore().getString("expanded");
        StringTokenizer st = new StringTokenizer(state, "\u0002");
        HashMap<String, Boolean> stateMap = new HashMap<String, Boolean>();
        while (st.hasMoreTokens()) {
            stateMap.put(st.nextToken(), Boolean.TRUE);
        }
        ArrayList elements = new ArrayList();
        this.setupExpansion(this.connectionDescriptorRepository.getBrowserModelRoot(), stateMap, elements);
        if (elements.size() > 0) {
            Object[] array = elements.toArray(new Object[elements.size()]);
            int i = 0;
            while (i < array.length) {
                this.m_viewer.setExpandedState(array[i], true);
                ++i;
            }
        }
    }

    private void setupExpansion(IConnectionDescriptorNode node, HashMap stateMap, ArrayList elements) {
        if (stateMap.containsKey(node.toString())) {
            elements.add(node);
        }
        if (node.getChildCount() > 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.setupExpansion(node.getChildAt(i), stateMap, elements);
                ++i;
            }
        }
    }

    public boolean isAutoDetectList(IConnectionDescriptorNode fnode) {
        return this.connectionDescriptorRepository.getAutoDetectNode() == fnode;
    }

    private IInputValidator createFolderStringValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                int i = 0;
                while (i < newText.length()) {
                    char c = newText.charAt(i);
                    if (!Character.isDigit(c) && !Character.isLetter(c) && c != ' ' && c != '_' && c != '-') {
                        return Messages.JRockitBrowserView_DIALOG_NEW_FOLDER_ERROR_MESSAGE_VALIDATION;
                    }
                    ++i;
                }
                return null;
            }
        };
    }

    public void highlightNode(IConnectionDescriptorNode jnode, int htime) {
        final IConnectionDescriptorNode node = jnode;
        final int time = htime;
        this.m_viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (node != null && node.getParent() != null && !JRockitBrowserView.this.m_viewer.getTree().isDisposed()) {
                    if (node.getParent().getParent() != null) {
                        JRockitBrowserView.this.m_viewer.setExpandedState((Object)node.getParent().getParent(), true);
                    }
                    JRockitBrowserView.this.m_viewer.setExpandedState((Object)node.getParent(), true);
                    JRockitBrowserView.this.m_highlightList.add(node);
                    JRockitBrowserView.this.m_viewer.refresh();
                    IConnectionDescriptorNode finalNode = node;
                    JRockitBrowserView.this.m_viewer.getControl().getDisplay().timerExec(time, new Runnable(this, finalNode){
                        final /* synthetic */ 18 this$1;
                        private final /* synthetic */ IConnectionDescriptorNode val$finalNode;
                        {
                            this.this$1 = var1_1;
                            this.val$finalNode = iConnectionDescriptorNode;
                        }

                        public void run() {
                            JRockitBrowserView.access$0(18.access$0(this.this$1)).remove(this.val$finalNode);
                            if (!JRockitBrowserView.access$3(18.access$0(this.this$1)).getControl().isDisposed()) {
                                JRockitBrowserView.access$3(18.access$0(this.this$1)).refresh();
                            }
                        }
                    });
                }
            }

            static /* synthetic */ JRockitBrowserView access$0(18 var0) {
                return var0.JRockitBrowserView.this;
            }
        });
    }

    public void refreshTree() {
        this.m_viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!JRockitBrowserView.this.m_viewer.getTree().isDisposed()) {
                    JRockitBrowserView.this.m_viewer.refresh();
                }
            }
        });
    }

    public static int getHighlightTime() {
        int time = JRockitBrowserPlugin.getDefault().getPreferenceStore().getInt("highlightPreference");
        if (time < 0) {
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Badly specified highlight time. Value was " + time + ".");
            return 1500;
        }
        return time;
    }

    public void recomputeActionEnablement() {
        this.m_viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!JRockitBrowserView.this.m_viewer.getTree().isDisposed()) {
                    IStructuredSelection selection = (IStructuredSelection)JRockitBrowserView.this.m_viewer.getSelection();
                    boolean isRemoveAllowed = true;
                    boolean isAutoDiscoveryDescendant = false;
                    boolean isFolders = true;
                    int connected = 0;
                    int disconnected = 0;
                    Iterator iter = selection.iterator();
                    while (iter.hasNext()) {
                        IConnectionDescriptorNode node = (IConnectionDescriptorNode)iter.next();
                        if (JRockitBrowserView.this.isConnectionOrIgnoreListRoot(node)) {
                            isRemoveAllowed = false;
                        }
                        if (JRockitBrowserView.this.isDescendantOfAutodiscovery(node)) {
                            isAutoDiscoveryDescendant = true;
                        }
                        if (node.isConnectionNode()) {
                            isFolders = false;
                            if (((ConnectionDescriptorNode)node).isConnected()) {
                                ++connected;
                                continue;
                            }
                            ++disconnected;
                            continue;
                        }
                        Iterator conIter = JRockitBrowserToolkit.getConnectionNodes(node).iterator();
                        while (conIter.hasNext()) {
                            boolean isConnected = ((ConnectionDescriptorNode)conIter.next()).isConnected();
                            if (isConnected) {
                                ++connected;
                                continue;
                            }
                            ++disconnected;
                        }
                    }
                    boolean isAutoDiscoveryFolder = isAutoDiscoveryDescendant && isFolders;
                    JRockitBrowserView.this.m_actionDisconnect.setEnabled(connected > 0 || disconnected > 0 && connected > 0);
                    JRockitBrowserView.this.m_actionNewFolder.setEnabled(!isAutoDiscoveryDescendant);
                    JRockitBrowserView.this.m_actionNewConnection.setEnabled(!isAutoDiscoveryDescendant);
                    JRockitBrowserView.this.m_actionRemove.setEnabled(isRemoveAllowed && !isAutoDiscoveryFolder);
                    JRockitBrowserView.this.m_actionEdit.setEnabled(selection.size() == 1 && !isAutoDiscoveryFolder);
                }
            }
        });
    }

    private static boolean isConfirmingDeletes() {
        return JRockitBrowserPlugin.getDefault().getPreferenceStore().getBoolean("confirmDeleteNodesPreference");
    }

    private boolean isDescendantOfAutodiscovery(IConnectionDescriptorNode node) {
        IConnectionDescriptorNode testNode = node;
        while (testNode.getParent() != null) {
            if (this.isAutoDetectList(testNode)) {
                return true;
            }
            testNode = testNode.getParent();
        }
        return false;
    }

    ConnectionDescriptorRepository getBrowserModel() {
        return this.connectionDescriptorRepository;
    }

    static /* synthetic */ void access$4(JRockitBrowserView jRockitBrowserView) {
        jRockitBrowserView.storeExpansionState();
    }

    private class BrowserDiscoveryHandler
    implements IDescriptorListener {
        private IConnectionDescriptorNode m_node;
        private IDescriptorProvider m_provider;

        public BrowserDiscoveryHandler(IDescriptorProvider provider) {
            this.m_provider = provider;
            RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.m_node = ((ConnectionDescriptorRepository)rJMXPlugin.getService((Class)clazz)).getDiscoveryNode().addFolder(this.m_provider.getName());
            this.m_provider.addDescriptorListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorChange(IConnectionDescriptor descriptor, IDescriptorListener.EventType eventType) {
            IConnectionDescriptorNode iConnectionDescriptorNode = this.m_node;
            synchronized (iConnectionDescriptorNode) {
                if (eventType == IDescriptorListener.EventType.DESCRIPTOR_ADD) {
                    if (!RJMXPlugin.getDefault().getDescriptorRepository().contains(descriptor)) {
                        IConnectionDescriptorNode nodeToAddTo = this.m_node;
                        if (descriptor.getExtendedProperties().containsKey("com.jrockit.connectioninfo.path")) {
                            nodeToAddTo = this.createPath(this.m_node, (String)descriptor.getExtendedProperties().get("com.jrockit.connectioninfo.path"));
                        }
                        JRockitBrowserView.this.highlightNode(nodeToAddTo.addConnectionDescriptor(descriptor), JRockitBrowserView.getHighlightTime());
                    }
                } else if (eventType == IDescriptorListener.EventType.DESCRIPTOR_REMOVE) {
                    IConnectionDescriptorNode nodeToRemoveFrom = this.m_node;
                    if (descriptor.getExtendedProperties().containsKey("com.jrockit.connectioninfo.path")) {
                        nodeToRemoveFrom = this.createPath(this.m_node, (String)descriptor.getExtendedProperties().get("com.jrockit.connectioninfo.path"));
                    }
                    int i = 0;
                    int size = nodeToRemoveFrom.getChildCount();
                    while (i < size) {
                        if (descriptor.equals(nodeToRemoveFrom.getChildAt(i).getConnectionDescriptor())) {
                            nodeToRemoveFrom.removeChild(nodeToRemoveFrom.getChildAt(i));
                            break;
                        }
                        ++i;
                    }
                    while (nodeToRemoveFrom != this.m_node) {
                        if (nodeToRemoveFrom.getChildCount() > 0) break;
                        IConnectionDescriptorNode parent = nodeToRemoveFrom.getParent();
                        parent.removeChild(nodeToRemoveFrom);
                        nodeToRemoveFrom = parent;
                    }
                }
            }
            JRockitBrowserView.this.refreshTree();
        }

        private IConnectionDescriptorNode createPath(IConnectionDescriptorNode node, String string) {
            String[] pathElements = string.split("/");
            IConnectionDescriptorNode currentNode = node;
            int i = 0;
            while (i < pathElements.length) {
                String element = pathElements[i];
                if (element != null && element.length() != 0) {
                    IConnectionDescriptorNode folder = this.getFolderNamed(currentNode, element);
                    currentNode = folder != null ? folder : currentNode.addFolder(element);
                }
                ++i;
            }
            return currentNode;
        }

        private IConnectionDescriptorNode getFolderNamed(IConnectionDescriptorNode node, String element) {
            int j = 0;
            while (j < node.getChildCount()) {
                if (node.getChildAt(j).getName().equals(element) && !node.getChildAt(j).isConnectionNode()) {
                    return node.getChildAt(j);
                }
                ++j;
            }
            return null;
        }

        public void shutDown() {
            this.m_provider.removeDescriptorListener(this);
        }
    }

    class JRockitBrowserFontLabelProvider
    extends BrowserLabelProvider
    implements IFontProvider {
        JRockitBrowserFontLabelProvider() {
        }

        public Font getFont(Object element) {
            if (JRockitBrowserView.this.m_highlightList.contains(element)) {
                return JRockitBrowserView.this.m_bold;
            }
            return JRockitBrowserView.this.m_normal;
        }
    }

    private class NameSorter
    extends ViewerSorter {
        private NameSorter() {
        }
    }
}

