/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.utils.ErrorJob;
import com.jrockit.mc.browser.utils.PreConnectJob;
import com.jrockit.mc.browser.views.IEditorOpener;
import com.jrockit.mc.browser.views.Messages;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionDescriptorNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;

public class JRockitBrowserToolkit {
    static /* synthetic */ Class class$0;

    public static Set getConnectionNodes(ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            HashSet connectionNodes = new HashSet();
            Iterator iter = sselection.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof IConnectionDescriptorNode)) {
                    return Collections.EMPTY_SET;
                }
                JRockitBrowserToolkit.getConnectionNodes((IConnectionDescriptorNode)next, connectionNodes);
            }
            return connectionNodes;
        }
        return Collections.EMPTY_SET;
    }

    public static Set getAdaptedSelection(ISelection selection, Class adapterClass) {
        return JRockitBrowserToolkit.getAdaptedCollection(JRockitBrowserToolkit.getConnectionNodes(selection), adapterClass);
    }

    private static Set getAdaptedCollection(Collection collection, Class adapterClass) {
        Iterator iter = collection.iterator();
        HashSet<Object> result = new HashSet<Object>();
        while (iter.hasNext()) {
            Object adapted;
            Object obj = iter.next();
            if (adapterClass.isInstance(obj)) {
                result.add(obj);
                continue;
            }
            if (!(obj instanceof IAdaptable) || (adapted = ((IAdaptable)obj).getAdapter(adapterClass)) == null) continue;
            result.add(adapted);
        }
        return result;
    }

    public static Set getConnectionNodes(ISelection selection, IWorkbenchWindow window, IEditorOpener opener) {
        Set connections = JRockitBrowserToolkit.getConnectionNodes(selection);
        if (connections.isEmpty()) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)opener.getFullName(), (String)NLS.bind((String)Messages.JRockitBrowserToolkit_ERROR_NEED_TO_SELECT_JROCKITS_MSG, (Object)opener.getFullName()));
        }
        return connections;
    }

    private static Set getInputs(Collection connections, IWorkbenchWindow window, IEditorOpener opener) {
        Set adapted = JRockitBrowserToolkit.getAdaptedCollection(connections, opener.getEditorInputClass());
        if (adapted.isEmpty()) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)opener.getFullName(), (String)NLS.bind((String)Messages.JRockitBrowserToolkit_ERROR_SELECTED_JROCKITS_UNSUITABLE_MSG, (Object)opener.getFullName()));
        }
        return adapted;
    }

    public static Set getInputs(ISelection selection, IWorkbenchWindow window, IEditorOpener opener) {
        Set connections = JRockitBrowserToolkit.getConnectionNodes(selection, window, opener);
        if (connections.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return JRockitBrowserToolkit.getInputs(connections, window, opener);
    }

    public static void openEditors(ISelection selection, IWorkbenchWindow window, IEditorOpener opener) {
        Set inputs = JRockitBrowserToolkit.getInputs(selection, window, opener);
        if (!inputs.isEmpty()) {
            JRockitBrowserToolkit.openEditorsForInputs(inputs, window, opener);
        }
    }

    public static void openEditors(Collection connections, IWorkbenchWindow window, IEditorOpener opener) {
        Set inputs = JRockitBrowserToolkit.getInputs(connections, window, opener);
        if (!inputs.isEmpty()) {
            JRockitBrowserToolkit.openEditorsForInputs(inputs, window, opener);
        }
    }

    public static void openEditorsForInputs(Collection inputs, IWorkbenchWindow window, IEditorOpener opener) {
        Iterator inputIter = inputs.iterator();
        while (inputIter.hasNext()) {
            JRockitBrowserToolkit.openEditor((IEditorInput)inputIter.next(), window, opener);
        }
    }

    public static void openEditor(IEditorInput input, IWorkbenchWindow window, IEditorOpener opener) {
        Job job;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((job = JRockitBrowserToolkit.getExistingJobFor(input, clazz)) == null) {
            job = new PreConnectJob(opener, input, window);
        } else {
            Object[] params = new Object[]{opener.getFullName(), input.getName(), job.getName()};
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.INFO, "Attempt to open {0} for {1}, although a {2} job exists.", params);
            job = new ErrorJob(job, opener, input);
        }
        job.schedule();
    }

    public static boolean isEntireSelectionAdaptable(ISelection selection, Class adapterClass) {
        Iterator connections = JRockitBrowserToolkit.getConnectionNodes(selection).iterator();
        boolean hasAny = connections.hasNext();
        while (connections.hasNext()) {
            Object conn = connections.next();
            if (adapterClass.isInstance(conn) || Platform.getAdapterManager().hasAdapter(conn, adapterClass.getName())) continue;
            return false;
        }
        return hasAny;
    }

    public static Set getConnectionNodes(IConnectionDescriptorNode node) {
        HashSet set = new HashSet();
        JRockitBrowserToolkit.getConnectionNodes(node, set);
        return set;
    }

    public static void getConnectionNodes(IConnectionDescriptorNode node, Set set) {
        if (node.isConnectionNode()) {
            set.add(node);
        } else {
            int i = 0;
            int size = node.getChildCount();
            while (i < size) {
                JRockitBrowserToolkit.getConnectionNodes(node.getChildAt(i), set);
                ++i;
            }
        }
    }

    public static Job getExistingJobFor(IEditorInput input, Class filter) {
        Class<?> clazz;
        block5: {
            block4: {
                if (filter != null) break block4;
                clazz = class$0;
                if (clazz != null) break block5;
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block5;
            }
            clazz = filter;
        }
        Class<?> type = clazz;
        Job[] jobs = Job.getJobManager().find((Object)input);
        int i = 0;
        while (i < jobs.length) {
            if (type.isInstance(jobs[i]) && !(jobs[i] instanceof ErrorJob)) {
                return jobs[i];
            }
            ++i;
        }
        return null;
    }
}

