/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.views.JRockitBrowserNodeTransferData;
import com.jrockit.mc.browser.views.JRockitBrowserViewDragSource;
import com.jrockit.mc.browser.views.Messages;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorFolderNode;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.w3c.dom.Document;

public class JRockitBrowserNodeTransfer
extends ByteArrayTransfer {
    private static final JRockitBrowserNodeTransfer m_instance = new JRockitBrowserNodeTransfer();
    private static final String TYPE_NAME = "jrockitbrowser-transfer-format-1.1";
    private static final int TYPE_ID = JRockitBrowserNodeTransfer.registerType((String)"jrockitbrowser-transfer-format-1.1");

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        Document doc;
        if (!(object instanceof JRockitBrowserNodeTransferData)) {
            DND.error((int)2003);
            return;
        }
        JRockitBrowserNodeTransferData node = (JRockitBrowserNodeTransferData)object;
        try {
            doc = XmlToolkit.createNewDocument((String)node.getJRockitNode().getComponentTag());
            doc.getDocumentElement().setAttribute("transferid", node.getTransferID().toString());
        }
        catch (IOException e) {
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JRockitBrowserNodeTransfer_LOG_MESSAGE_CAN_NOT_CREATE_DOCUMENT, e);
            return;
        }
        node.getJRockitNode().exportToXml(doc.getDocumentElement());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        try {
            dos.writeUTF(XmlToolkit.storeDocumentToString((Document)doc));
            dos.close();
            out.close();
            super.javaToNative((Object)out.toByteArray(), transferData);
        }
        catch (IOException e) {
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JRockitBrowserNodeTransfer_LOG_MESSAGE_CAN_NOT_SERIALIZE_TO_NATIVE, e);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        ConnectionDescriptorFolderNode browserNode = null;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            JRockitBrowserNodeTransferData data;
            Document doc = XmlToolkit.loadDocumentFromString((String)in.readUTF());
            String transId = doc.getDocumentElement().getAttribute("transferid");
            if (transId != null && (data = JRockitBrowserViewDragSource.getTransferDataByID(new Integer(Integer.parseInt(transId)))) != null) {
                JRockitBrowserViewDragSource.removeDataByID(data.getTransferID());
                return data.getJRockitNode();
            }
            if ("folder_node".equals(doc.getDocumentElement().getNodeName())) {
                browserNode = new ConnectionDescriptorFolderNode(null, "");
            } else if ("connector_node".equals(doc.getDocumentElement().getNodeName())) {
                browserNode = new ConnectionDescriptorNode(null, null);
            }
            if (browserNode != null) {
                browserNode.initializeFromXml(doc.getDocumentElement());
                return browserNode;
            }
        }
        catch (Exception e) {
            JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, Messages.JRockitBrowserNodeTransfer_LOG_MESSAGE_CAN_NOT_SERIALIZE_TO_JAVA, e);
        }
        return null;
    }

    public static JRockitBrowserNodeTransfer getInstance() {
        return m_instance;
    }
}

