/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.utils;

import com.jrockit.common.rmp.JRockitServerNotListeningException;
import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.utils.Messages;
import com.jrockit.mc.browser.views.IEditorOpener;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.ui.HelpSupport;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionHandler;
import com.jrockit.mc.rjmx.proxy.LicenseException;
import java.io.IOException;
import java.rmi.ConnectException;
import java.util.logging.Level;
import javax.naming.ServiceUnavailableException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.IProgressConstants;

public class PreConnectJob
extends Job
implements IConnectionHandler {
    private IEditorInput input;
    private IEditorOpener opener;
    private IWorkbenchWindow window;
    private boolean wasNonJRockit = false;

    public PreConnectJob(IEditorOpener opener, IEditorInput input, IWorkbenchWindow window) {
        super(NLS.bind((String)Messages.PreConnectJob_JOB_NAME_PRE_CONNECT_MSG, (Object[])new Object[]{opener.getFullName(), input.getName(), opener.getShortName()}));
        this.opener = opener;
        this.input = input;
        this.window = window;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ConnectionDescriptorNode node = ConnectionDescriptorNode.getConnectionNodeFor((Object)this.input);
        if (!this.isJRockit(node)) {
            this.window.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!MessageDialog.openConfirm((Shell)PreConnectJob.this.window.getShell(), (String)Messages.PreConnectJob_TITLE_NOT_A_JROCKIT, (String)Messages.PreConnectJob_MESSAGE_NOT_A_JROCKIT)) {
                        PreConnectJob.this.wasNonJRockit = true;
                    }
                }
            });
        }
        if (this.wasNonJRockit) {
            return StatusFactory.createOk((String)Messages.PreConnectJob_MESSAGE_CONNECTION_ABORTED_BY_USER);
        }
        node.addConnectionHandler((IConnectionHandler)this);
        try {
            try {
                this.opener.preConnect(this.window, this.input, monitor, this);
                if (!monitor.isCanceled()) {
                    this.window.getWorkbench().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                PreConnectJob.this.opener.openEditor(PreConnectJob.this.window, PreConnectJob.this.input);
                            }
                            catch (PartInitException e) {
                                JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Could not open editor.", e);
                            }
                        }
                    });
                }
            }
            catch (LicenseException e) {
                this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(Messages.PreConnectJob_LICENSE_HELP){

                    public void run() {
                        BusyIndicator.showWhile((Display)PreConnectJob.this.window.getShell().getDisplay(), (Runnable)new Runnable(this){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                HelpSupport.showHelp((String)"com.jrockit.mc.docs.LicenseIntro");
                            }
                        });
                    }
                });
                IStatus status = this.opener.customStatusForThrown((Exception)((Object)e), this.input);
                if (status == null) {
                    status = StatusFactory.createErr((String)this.stdBind(Messages.PreConnectJob_LICENSE_NOT_FOUND_MSG), (Throwable)e, (boolean)false);
                }
                IStatus iStatus = status;
                try {
                    this.opener.releaseConnect(this.input, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ConnectionDescriptorNode.getConnectionNodeFor((Object)this.input).removeConnectionHandler((IConnectionHandler)this);
                return iStatus;
            }
            catch (Exception e) {
                IStatus status = this.opener.customStatusForThrown(e, this.input);
                if (status == null) {
                    status = this.commonStatusForThrown(e);
                }
                if (status == null) {
                    status = StatusFactory.createErr((String)this.stdBind(Messages.PreConnectJob_STATUS_COULD_NOT_OPEN_MSG), (Throwable)e, (boolean)true);
                }
                IStatus iStatus = status;
                try {
                    this.opener.releaseConnect(this.input, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ConnectionDescriptorNode.getConnectionNodeFor((Object)this.input).removeConnectionHandler((IConnectionHandler)this);
                return iStatus;
            }
        }
        finally {
            try {
                this.opener.releaseConnect(this.input, this);
            }
            catch (Exception exception) {}
            ConnectionDescriptorNode.getConnectionNodeFor((Object)this.input).removeConnectionHandler((IConnectionHandler)this);
        }
        return StatusFactory.createOk((String)Messages.PreConnectJob_STATUS_MESSAGE_CONNECTED);
    }

    private boolean isJRockit(ConnectionDescriptorNode node) {
        if (node == null) {
            return true;
        }
        Boolean test = (Boolean)node.getConnectionDescriptor().getExtendedProperties().get("com.jrockit.connectioninfo.jrockit");
        return test == null || test != false;
    }

    protected IStatus commonStatusForThrown(Exception exception) {
        String msg = null;
        Throwable cause = exception;
        if (exception instanceof SecurityException) {
            msg = Messages.PreConnectJob_MESSAGE_AUTHENTICATION_FAILED;
        } else if ("com.jrockit.mc.browser.attach.LazyServiceURLResolveException".equals(exception.getClass().getName())) {
            msg = Messages.PreConnectJob_MESSAGE_LOCAL_CONNECT_NOT_SUPPORTED;
        } else if (exception instanceof IOException) {
            cause = exception.getCause();
            if (cause instanceof ServiceUnavailableException && cause.getCause() instanceof ConnectException) {
                cause = cause.getCause();
                msg = Messages.PreConnectJob_NO_SERVER_RUNNING_MSG;
            } else if (cause instanceof JRockitServerNotListeningException) {
                msg = Messages.PreConnectJob_NO_SERVER_RUNNING_MSG;
            }
        }
        if (msg != null) {
            return StatusFactory.createErr((String)this.stdBind(msg), (Throwable)cause, (boolean)false);
        }
        return null;
    }

    protected String stdBind(String formatMsg) {
        return NLS.bind((String)formatMsg, (Object[])new Object[]{this.opener.getFullName(), this.input.getName(), this.opener.getShortName()});
    }

    public String getHandlerName() {
        return this.getName();
    }

    public boolean isConnected() {
        return true;
    }

    public boolean belongsTo(Object family) {
        return family == this.opener || this.input.equals(family);
    }

    public void shutDown(boolean hardDisconnect) {
        this.cancel();
    }
}

