/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.internal;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.eclipse.albireo.core.AwtEnvironment;
import org.eclipse.albireo.core.SwingControl;
import org.eclipse.albireo.core.ThreadingHandler;
import org.eclipse.albireo.internal.Platform;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class SwtPopupHandler {
    private static final boolean CREATE_POPUP_PARENT_SHELL;
    private static final boolean DELAY_MOUSE_DOWN_SWT_POPUP_TRIGGERS;
    private boolean pendingSwtPopup = false;
    private AWTEventListener popupEventListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                switch (mouseEvent.getID()) {
                    case 501: {
                        boolean bl = mouseEvent.isPopupTrigger();
                        if (DELAY_MOUSE_DOWN_SWT_POPUP_TRIGGERS && CREATE_POPUP_PARENT_SHELL && bl) {
                            SwtPopupHandler.this.pendingSwtPopup = true;
                            bl = false;
                        }
                        if (!bl) break;
                        SwtPopupHandler.this.handlePopupTrigger(mouseEvent);
                        break;
                    }
                    case 502: {
                        if (SwtPopupHandler.this.pendingSwtPopup) {
                            SwtPopupHandler.this.handlePopupTrigger(mouseEvent);
                            SwtPopupHandler.this.pendingSwtPopup = false;
                        }
                        if (!mouseEvent.isPopupTrigger()) break;
                        SwtPopupHandler.this.handlePopupTrigger(mouseEvent);
                        break;
                    }
                    case 500: {
                        if (!mouseEvent.isPopupTrigger()) break;
                        SwtPopupHandler.this.handlePopupTrigger(mouseEvent);
                    }
                }
            }
        }
    };
    private WeakHashMap popupSupportedToolkits = new WeakHashMap();
    private static SwtPopupHandler theHandler;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.internal.SwtPopupHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        CREATE_POPUP_PARENT_SHELL = Platform.isGtk();
        DELAY_MOUSE_DOWN_SWT_POPUP_TRIGGERS = Platform.isGtk();
        theHandler = new SwtPopupHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorAwtComponent(Component component) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Toolkit toolkit = component.getToolkit();
        WeakHashMap weakHashMap = this.popupSupportedToolkits;
        synchronized (weakHashMap) {
            if (this.popupSupportedToolkits.get(toolkit) == null) {
                toolkit.addAWTEventListener(this.popupEventListener, 16L);
                this.popupSupportedToolkits.put(toolkit, Boolean.TRUE);
            }
        }
    }

    protected SwingControl getSwtParent(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            return (SwingControl)((Object)jComponent.getClientProperty("org.eclipse.albireo.swtParent"));
        }
        return null;
    }

    protected void handlePopupTrigger(MouseEvent mouseEvent) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Component component = (Component)mouseEvent.getSource();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Component component2 = component;
        while (component2 != null && this.getSwtParent(component2) == null) {
            n += component2.getX();
            n2 += component2.getY();
            component2 = component2.getParent();
        }
        if (component2 != null) {
            SwingControl swingControl = this.getSwtParent(component2);
            int n3 = n;
            int n4 = n2;
            Component component3 = (Component)mouseEvent.getSource();
            this.showPopupMenu(swingControl, component3, n, n2, n3, n4);
        }
    }

    protected void showPopupMenu(final SwingControl swingControl, final Component component, final int n, final int n2, final int n3, final int n4) {
        Display display;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        try {
            display = swingControl.getDisplay();
        }
        catch (SWTException sWTException) {
            if (sWTException.code == 24) {
                return;
            }
            throw sWTException;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (!swingControl.isDisposed()) {
                        SwtPopupHandler.this.showPopupMenuSWTThread(swingControl, component, n, n2, n3, n4);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        };
        try {
            ThreadingHandler.getInstance().asyncExec(display, runnable);
        }
        catch (SWTException sWTException) {
            if (sWTException.code == 45) {
                return;
            }
            throw sWTException;
        }
    }

    protected void showPopupMenuSWTThread(SwingControl swingControl, Component component, int n, int n2, int n3, int n4) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        final Menu menu = swingControl.getMenu(component, n, n2, n3, n4);
        Display display = swingControl.getDisplay();
        if (menu != null) {
            final Shell shell = AwtEnvironment.getInstance(display).getSwtPopupParent(swingControl);
            if (DELAY_MOUSE_DOWN_SWT_POPUP_TRIGGERS) {
                shell.addListener(6, new Listener(){

                    public void handleEvent(Event event) {
                        if (CREATE_POPUP_PARENT_SHELL) {
                            menu.addListener(23, new Listener(this, shell, menu){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ Shell val$popupParent;
                                private final /* synthetic */ Menu val$menu;
                                {
                                    this.this$1 = var1_1;
                                    this.val$popupParent = shell;
                                    this.val$menu = menu;
                                }

                                public void handleEvent(Event event) {
                                    if (!this.val$popupParent.isDisposed()) {
                                        this.val$popupParent.setVisible(false);
                                    }
                                    this.val$menu.removeListener(23, (Listener)this);
                                }
                            });
                        }
                        if (!menu.isDisposed()) {
                            menu.setVisible(true);
                        }
                        shell.removeListener(6, (Listener)this);
                    }
                });
            }
            if (CREATE_POPUP_PARENT_SHELL) {
                shell.setLocation(display.getCursorLocation());
                shell.open();
            }
            if (!DELAY_MOUSE_DOWN_SWT_POPUP_TRIGGERS) {
                menu.setVisible(true);
            }
        }
    }

    public static SwtPopupHandler getInstance() {
        return theHandler;
    }

    public static void setInstance(SwtPopupHandler swtPopupHandler) {
        theHandler = swtPopupHandler;
    }
}

