/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Library;

public class Platform {
    private static String platformString = SWT.getPlatform();
    public static final int JAVA_VERSION = Platform.parseVersion(System.getProperty("java.version"));
    public static final int SWT_VERSION = Library.SWT_VERSION;
    public static final int SWT_33 = Platform.swtVersion(3, 346);
    public static final int SWT_FIX216431 = Platform.swtVersion(3, 426);

    private Platform() {
    }

    public static boolean isWin32() {
        return "win32".equals(platformString);
    }

    public static boolean isGtk() {
        return "gtk".equals(platformString);
    }

    public static boolean isMotif() {
        return "motif".equals(platformString);
    }

    public static boolean isCarbon() {
        return "carbon".equals(platformString);
    }

    static int parseVersion(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n2 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n3 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return Platform.javaVersion(n, n2, n3);
    }

    public static int javaVersion(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    private static int swtVersion(int n, int n2) {
        return Library.SWT_VERSION((int)n, (int)n2);
    }
}

